/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.jnr.constants.platform.linux.powerpc64;

import com.spotify.docker.client.shaded.jnr.constants.Constant;
import java.util.EnumMap;
import java.util.Map;

public enum Errno implements Constant
{
    EPERM(1L),
    ENOENT(2L),
    ESRCH(3L),
    EINTR(4L),
    EIO(5L),
    ENXIO(6L),
    E2BIG(7L),
    ENOEXEC(8L),
    EBADF(9L),
    ECHILD(10L),
    EDEADLK(35L),
    ENOMEM(12L),
    EACCES(13L),
    EFAULT(14L),
    ENOTBLK(15L),
    EBUSY(16L),
    EEXIST(17L),
    EXDEV(18L),
    ENODEV(19L),
    ENOTDIR(20L),
    EISDIR(21L),
    EINVAL(22L),
    ENFILE(23L),
    EMFILE(24L),
    ENOTTY(25L),
    ETXTBSY(26L),
    EFBIG(27L),
    ENOSPC(28L),
    ESPIPE(29L),
    EROFS(30L),
    EMLINK(31L),
    EPIPE(32L),
    EDOM(33L),
    ERANGE(34L),
    EWOULDBLOCK(11L),
    EAGAIN(11L),
    EINPROGRESS(115L),
    EALREADY(114L),
    ENOTSOCK(88L),
    EDESTADDRREQ(89L),
    EMSGSIZE(90L),
    EPROTOTYPE(91L),
    ENOPROTOOPT(92L),
    EPROTONOSUPPORT(93L),
    ESOCKTNOSUPPORT(94L),
    EOPNOTSUPP(95L),
    EPFNOSUPPORT(96L),
    EAFNOSUPPORT(97L),
    EADDRINUSE(98L),
    EADDRNOTAVAIL(99L),
    ENETDOWN(100L),
    ENETUNREACH(101L),
    ENETRESET(102L),
    ECONNABORTED(103L),
    ECONNRESET(104L),
    ENOBUFS(105L),
    EISCONN(106L),
    ENOTCONN(107L),
    ESHUTDOWN(108L),
    ETOOMANYREFS(109L),
    ETIMEDOUT(110L),
    ECONNREFUSED(111L),
    ELOOP(40L),
    ENAMETOOLONG(36L),
    EHOSTDOWN(112L),
    EHOSTUNREACH(113L),
    ENOTEMPTY(39L),
    EUSERS(87L),
    EDQUOT(122L),
    ESTALE(116L),
    EREMOTE(66L),
    ENOLCK(37L),
    ENOSYS(38L),
    EOVERFLOW(75L),
    EIDRM(43L),
    ENOMSG(42L),
    EILSEQ(84L),
    EBADMSG(74L),
    EMULTIHOP(72L),
    ENODATA(61L),
    ENOLINK(67L),
    ENOSR(63L),
    ENOSTR(60L),
    EPROTO(71L),
    ETIME(62L),
    ECHRNG(44L),
    EL2NSYNC(45L),
    EL3HLT(46L),
    EL3RST(47L),
    ELNRNG(48L),
    EUNATCH(49L),
    ENOCSI(50L),
    EL2HLT(51L),
    EBADE(52L),
    EBADR(53L),
    EXFULL(54L),
    ENOANO(55L),
    EBADRQC(56L),
    EBADSLT(57L),
    EDEADLOCK(58L),
    EBFONT(59L),
    ENONET(64L),
    ENOPKG(65L),
    EADV(68L),
    ESRMNT(69L),
    ECOMM(70L),
    EDOTDOT(73L),
    ENOTUNIQ(76L),
    EBADFD(77L),
    EREMCHG(78L),
    ELIBACC(79L),
    ELIBBAD(80L),
    ELIBSCN(81L),
    ELIBMAX(82L),
    ELIBEXEC(83L),
    ERESTART(85L),
    ESTRPIPE(86L),
    EUCLEAN(117L),
    ENOTNAM(118L),
    ENAVAIL(119L),
    EISNAM(120L),
    EREMOTEIO(121L),
    ECANCELED(125L),
    EKEYEXPIRED(127L),
    EKEYREJECTED(129L),
    EKEYREVOKED(128L),
    EMEDIUMTYPE(124L),
    ENOKEY(126L),
    ENOMEDIUM(123L),
    ENOTRECOVERABLE(131L),
    EOWNERDEAD(130L),
    ERFKILL(132L),
    ENOTSUP(95L),
    EHWPOISON(133L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 133L;

    private Errno(long value) {
        this.value = value;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<Errno, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Errno, String> generateTable() {
            EnumMap<Errno, String> map = new EnumMap<Errno, String>(Errno.class);
            map.put(EPERM, "Operation not permitted");
            map.put(ENOENT, "No such file or directory");
            map.put(ESRCH, "No such process");
            map.put(EINTR, "Interrupted system call");
            map.put(EIO, "Input/output error");
            map.put(ENXIO, "No such device or address");
            map.put(E2BIG, "Argument list too long");
            map.put(ENOEXEC, "Exec format error");
            map.put(EBADF, "Bad file descriptor");
            map.put(ECHILD, "No child processes");
            map.put(EDEADLK, "Resource deadlock avoided");
            map.put(ENOMEM, "Cannot allocate memory");
            map.put(EACCES, "Permission denied");
            map.put(EFAULT, "Bad address");
            map.put(ENOTBLK, "Block device required");
            map.put(EBUSY, "Device or resource busy");
            map.put(EEXIST, "File exists");
            map.put(EXDEV, "Invalid cross-device link");
            map.put(ENODEV, "No such device");
            map.put(ENOTDIR, "Not a directory");
            map.put(EISDIR, "Is a directory");
            map.put(EINVAL, "Invalid argument");
            map.put(ENFILE, "Too many open files in system");
            map.put(EMFILE, "Too many open files");
            map.put(ENOTTY, "Inappropriate ioctl for device");
            map.put(ETXTBSY, "Text file busy");
            map.put(EFBIG, "File too large");
            map.put(ENOSPC, "No space left on device");
            map.put(ESPIPE, "Illegal seek");
            map.put(EROFS, "Read-only file system");
            map.put(EMLINK, "Too many links");
            map.put(EPIPE, "Broken pipe");
            map.put(EDOM, "Numerical argument out of domain");
            map.put(ERANGE, "Numerical result out of range");
            map.put(EWOULDBLOCK, "Resource temporarily unavailable");
            map.put(EAGAIN, "Resource temporarily unavailable");
            map.put(EINPROGRESS, "Operation now in progress");
            map.put(EALREADY, "Operation already in progress");
            map.put(ENOTSOCK, "Socket operation on non-socket");
            map.put(EDESTADDRREQ, "Destination address required");
            map.put(EMSGSIZE, "Message too long");
            map.put(EPROTOTYPE, "Protocol wrong type for socket");
            map.put(ENOPROTOOPT, "Protocol not available");
            map.put(EPROTONOSUPPORT, "Protocol not supported");
            map.put(ESOCKTNOSUPPORT, "Socket type not supported");
            map.put(EOPNOTSUPP, "Operation not supported");
            map.put(EPFNOSUPPORT, "Protocol family not supported");
            map.put(EAFNOSUPPORT, "Address family not supported by protocol");
            map.put(EADDRINUSE, "Address already in use");
            map.put(EADDRNOTAVAIL, "Cannot assign requested address");
            map.put(ENETDOWN, "Network is down");
            map.put(ENETUNREACH, "Network is unreachable");
            map.put(ENETRESET, "Network dropped connection on reset");
            map.put(ECONNABORTED, "Software caused connection abort");
            map.put(ECONNRESET, "Connection reset by peer");
            map.put(ENOBUFS, "No buffer space available");
            map.put(EISCONN, "Transport endpoint is already connected");
            map.put(ENOTCONN, "Transport endpoint is not connected");
            map.put(ESHUTDOWN, "Cannot send after transport endpoint shutdown");
            map.put(ETOOMANYREFS, "Too many references: cannot splice");
            map.put(ETIMEDOUT, "Connection timed out");
            map.put(ECONNREFUSED, "Connection refused");
            map.put(ELOOP, "Too many levels of symbolic links");
            map.put(ENAMETOOLONG, "File name too long");
            map.put(EHOSTDOWN, "Host is down");
            map.put(EHOSTUNREACH, "No route to host");
            map.put(ENOTEMPTY, "Directory not empty");
            map.put(EUSERS, "Too many users");
            map.put(EDQUOT, "Disk quota exceeded");
            map.put(ESTALE, "Stale file handle");
            map.put(EREMOTE, "Object is remote");
            map.put(ENOLCK, "No locks available");
            map.put(ENOSYS, "Function not implemented");
            map.put(EOVERFLOW, "Value too large for defined data type");
            map.put(EIDRM, "Identifier removed");
            map.put(ENOMSG, "No message of desired type");
            map.put(EILSEQ, "Invalid or incomplete multibyte or wide character");
            map.put(EBADMSG, "Bad message");
            map.put(EMULTIHOP, "Multihop attempted");
            map.put(ENODATA, "No data available");
            map.put(ENOLINK, "Link has been severed");
            map.put(ENOSR, "Out of streams resources");
            map.put(ENOSTR, "Device not a stream");
            map.put(EPROTO, "Protocol error");
            map.put(ETIME, "Timer expired");
            map.put(ECHRNG, "Channel number out of range");
            map.put(EL2NSYNC, "Level 2 not synchronized");
            map.put(EL3HLT, "Level 3 halted");
            map.put(EL3RST, "Level 3 reset");
            map.put(ELNRNG, "Link number out of range");
            map.put(EUNATCH, "Protocol driver not attached");
            map.put(ENOCSI, "No CSI structure available");
            map.put(EL2HLT, "Level 2 halted");
            map.put(EBADE, "Invalid exchange");
            map.put(EBADR, "Invalid request descriptor");
            map.put(EXFULL, "Exchange full");
            map.put(ENOANO, "No anode");
            map.put(EBADRQC, "Invalid request code");
            map.put(EBADSLT, "Invalid slot");
            map.put(EDEADLOCK, "File locking deadlock error");
            map.put(EBFONT, "Bad font file format");
            map.put(ENONET, "Machine is not on the network");
            map.put(ENOPKG, "Package not installed");
            map.put(EADV, "Advertise error");
            map.put(ESRMNT, "Srmount error");
            map.put(ECOMM, "Communication error on send");
            map.put(EDOTDOT, "RFS specific error");
            map.put(ENOTUNIQ, "Name not unique on network");
            map.put(EBADFD, "File descriptor in bad state");
            map.put(EREMCHG, "Remote address changed");
            map.put(ELIBACC, "Can not access a needed shared library");
            map.put(ELIBBAD, "Accessing a corrupted shared library");
            map.put(ELIBSCN, ".lib section in a.out corrupted");
            map.put(ELIBMAX, "Attempting to link in too many shared libraries");
            map.put(ELIBEXEC, "Cannot exec a shared library directly");
            map.put(ERESTART, "Interrupted system call should be restarted");
            map.put(ESTRPIPE, "Streams pipe error");
            map.put(EUCLEAN, "Structure needs cleaning");
            map.put(ENOTNAM, "Not a XENIX named type file");
            map.put(ENAVAIL, "No XENIX semaphores available");
            map.put(EISNAM, "Is a named type file");
            map.put(EREMOTEIO, "Remote I/O error");
            map.put(ECANCELED, "Operation canceled");
            map.put(EKEYEXPIRED, "Key has expired");
            map.put(EKEYREJECTED, "Key was rejected by service");
            map.put(EKEYREVOKED, "Key has been revoked");
            map.put(EMEDIUMTYPE, "Wrong medium type");
            map.put(ENOKEY, "Required key not available");
            map.put(ENOMEDIUM, "No medium found");
            map.put(ENOTRECOVERABLE, "State not recoverable");
            map.put(EOWNERDEAD, "Owner died");
            map.put(ERFKILL, "Operation not possible due to RF-kill");
            map.put(ENOTSUP, "Operation not supported");
            map.put(EHWPOISON, "Memory page has hardware error");
            return map;
        }
    }
}

