/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.shaded.com.google.common.util.concurrent;

import com.spotify.docker.client.shaded.com.google.common.annotations.GwtCompatible;
import com.spotify.docker.client.shaded.com.google.common.base.Preconditions;
import com.spotify.docker.client.shaded.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.spotify.docker.client.shaded.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class Platform {
    static boolean isInstanceOfThrowableClass(@CheckForNull Throwable t, Class<? extends Throwable> expectedClass) {
        return expectedClass.isInstance(t);
    }

    static void restoreInterruptIfIsInterruptedException(Throwable t) {
        Preconditions.checkNotNull(t);
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private Platform() {
    }
}

