/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.spotify.docker.client.DockerConfigReader;
import com.spotify.docker.client.DockerCredentialHelper;
import com.spotify.docker.client.ObjectMapperProvider;
import com.spotify.docker.client.messages.DockerCredentialHelperAuth;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.core.type.TypeReference;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.spotify.docker.client.shaded.com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
class SystemCredentialHelperDelegate
implements DockerCredentialHelper.CredentialHelperDelegate {
    private static final Logger log = LoggerFactory.getLogger(DockerConfigReader.class);
    private static final ObjectMapper mapper = ObjectMapperProvider.objectMapper();

    SystemCredentialHelperDelegate() {
    }

    @Override
    public int store(String credsStore, DockerCredentialHelperAuth auth) throws IOException, InterruptedException {
        Process process = this.exec("store", credsStore);
        try (OutputStreamWriter outStreamWriter = new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8);
             BufferedWriter writer = new BufferedWriter(outStreamWriter);){
            writer.write(mapper.writeValueAsString(auth));
            writer.newLine();
            writer.flush();
        }
        return process.waitFor();
    }

    @Override
    public int erase(String credsStore, String registry) throws IOException, InterruptedException {
        Process process = this.exec("erase", credsStore);
        try (OutputStreamWriter outStreamWriter = new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8);
             BufferedWriter writer = new BufferedWriter(outStreamWriter);){
            writer.write(registry);
            writer.newLine();
            writer.flush();
        }
        return process.waitFor();
    }

    @Override
    public DockerCredentialHelperAuth get(String credsStore, String registry) throws IOException {
        Process process = this.exec("get", credsStore);
        try (OutputStreamWriter outStreamWriter = new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8);
             BufferedWriter writer = new BufferedWriter(outStreamWriter);){
            writer.write(registry);
            writer.newLine();
            writer.flush();
        }
        try (InputStreamReader reader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);){
            DockerCredentialHelperAuth dockerCredentialHelperAuth;
            try (BufferedReader input = new BufferedReader(reader);){
                dockerCredentialHelperAuth = SystemCredentialHelperDelegate.readServerAuthDetails(input);
            }
            return dockerCredentialHelperAuth;
        }
    }

    @Override
    public Map<String, String> list(String credsStore) throws IOException {
        Process process = this.exec("list", credsStore);
        try (InputStreamReader reader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);){
            String serverAuthDetails;
            BufferedReader input;
            block12: {
                Map<String, String> map;
                input = new BufferedReader(reader);
                try {
                    serverAuthDetails = input.readLine();
                    if (!"The specified item could not be found in the keychain.".equals(serverAuthDetails)) break block12;
                    map = null;
                }
                catch (Throwable throwable) {
                    try {
                        input.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                input.close();
                return map;
            }
            Map<String, String> map = mapper.readValue(serverAuthDetails, new TypeReference<Map<String, String>>(){});
            input.close();
            return map;
        }
    }

    @VisibleForTesting
    static DockerCredentialHelperAuth readServerAuthDetails(BufferedReader input) throws IOException {
        String serverAuthDetails = input.lines().collect(Collectors.joining());
        if ("credentials not found in native keychain".equals(serverAuthDetails)) {
            return null;
        }
        return mapper.readValue(serverAuthDetails, DockerCredentialHelperAuth.class);
    }

    private Process exec(String subcommand, String credsStore) throws IOException {
        String cmd = "docker-credential-" + credsStore + " " + subcommand;
        log.debug("Executing \"{}\"", (Object)cmd);
        return Runtime.getRuntime().exec(cmd);
    }
}

