/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.jms.client;

import com.rabbitmq.client.impl.Version;
import com.rabbitmq.jms.client.GenericVersion;
import com.rabbitmq.jms.client.JMSMetaData;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.JMSException;
import java.util.Enumeration;

public class RMQConnectionMetaData
implements ConnectionMetaData {
    JMSMetaData jmsMetaData = new JMSMetaData();
    private static final GenericVersion RABBITMQ_VERSION_OBJECT = new GenericVersion(Version.class.getPackage().getImplementationVersion());
    private static final String RABBITMQ_VERSION = RABBITMQ_VERSION_OBJECT.toString();
    private static final int RABBITMQ_MAJOR_VERSION = RABBITMQ_VERSION_OBJECT.getMajor();
    private static final int RABBITMQ_MINOR_VERSION = RABBITMQ_VERSION_OBJECT.getMinor();
    public static final String JMSX_GROUP_ID_LABEL = "JMSXGroupID";
    public static final String JMSX_GROUP_SEQ_LABEL = "JMSXGroupSeq";

    public String getJMSVersion() throws JMSException {
        return this.jmsMetaData.getJMSVersion();
    }

    public int getJMSMajorVersion() throws JMSException {
        return this.jmsMetaData.getJMSMajorVersion();
    }

    public int getJMSMinorVersion() throws JMSException {
        return this.jmsMetaData.getJMSMinorVersion();
    }

    public String getJMSProviderName() throws JMSException {
        return this.jmsMetaData.getJMSProviderName();
    }

    public String getProviderVersion() throws JMSException {
        return RABBITMQ_VERSION;
    }

    public int getProviderMajorVersion() throws JMSException {
        return RABBITMQ_MAJOR_VERSION;
    }

    public int getProviderMinorVersion() throws JMSException {
        return RABBITMQ_MINOR_VERSION;
    }

    public Enumeration<String> getJMSXPropertyNames() throws JMSException {
        return new JMSMetaData.JmsXEnumerator();
    }
}

