/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.checks.header.AbstractHeaderCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@StatelessCheck
public class RegexpHeaderCheck
extends AbstractHeaderCheck {
    public static final String MSG_HEADER_MISSING = "header.missing";
    public static final String MSG_HEADER_MISMATCH = "header.mismatch";
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final String EMPTY_LINE_PATTERN = "^$";
    private static final Pattern BLANK_LINE = Pattern.compile("^$");
    private final List<Pattern> headerRegexps = new ArrayList<Pattern>();
    private int[] multiLines = EMPTY_INT_ARRAY;

    public void setMultiLines(int ... list) {
        this.multiLines = new int[list.length];
        System.arraycopy(list, 0, this.multiLines, 0, list.length);
        Arrays.sort(this.multiLines);
    }

    @Override
    protected void processFiltered(File file, FileText fileText) {
        int fileSize;
        int headerSize = this.getHeaderLines().size();
        if (headerSize - this.multiLines.length > (fileSize = fileText.size())) {
            this.log(1, MSG_HEADER_MISSING, new Object[0]);
        } else {
            int index;
            int headerLineNo = 0;
            for (index = 0; headerLineNo < headerSize && index < fileSize; ++index) {
                String line = fileText.get(index);
                boolean isMatch = this.isMatch(line, headerLineNo);
                while (!isMatch && this.isMultiLine(headerLineNo)) {
                    isMatch = ++headerLineNo == headerSize || this.isMatch(line, headerLineNo);
                }
                if (!isMatch) {
                    this.log(index + 1, MSG_HEADER_MISMATCH, this.getHeaderLine(headerLineNo));
                    break;
                }
                if (this.isMultiLine(headerLineNo)) continue;
                ++headerLineNo;
            }
            if (index == fileSize) {
                this.logFirstSinglelineLine(headerLineNo, headerSize);
            }
        }
    }

    private String getHeaderLine(int headerLineNo) {
        String line = this.getHeaderLines().get(headerLineNo);
        if (line.isEmpty()) {
            line = EMPTY_LINE_PATTERN;
        }
        return line;
    }

    private void logFirstSinglelineLine(int startHeaderLine, int headerSize) {
        for (int lineNum = startHeaderLine; lineNum < headerSize; ++lineNum) {
            if (this.isMultiLine(lineNum)) continue;
            this.log(1, MSG_HEADER_MISSING, new Object[0]);
            break;
        }
    }

    private boolean isMatch(String line, int headerLineNo) {
        return this.headerRegexps.get(headerLineNo).matcher(line).find();
    }

    private boolean isMultiLine(int lineNo) {
        return Arrays.binarySearch(this.multiLines, lineNo + 1) >= 0;
    }

    @Override
    protected void postProcessHeaderLines() {
        List<String> headerLines = this.getHeaderLines();
        for (String line : headerLines) {
            try {
                if (line.isEmpty()) {
                    this.headerRegexps.add(BLANK_LINE);
                    continue;
                }
                this.headerRegexps.add(Pattern.compile(line));
            }
            catch (PatternSyntaxException ex) {
                throw new IllegalArgumentException("line " + (this.headerRegexps.size() + 1) + " in header specification is not a regular expression", ex);
            }
        }
    }

    @Override
    public void setHeader(String header) {
        if (!CommonUtil.isBlank(header)) {
            if (!CommonUtil.isPatternValid(header)) {
                throw new IllegalArgumentException("Unable to parse format: " + header);
            }
            super.setHeader(header);
        }
    }
}

