/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.xpath;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import com.puppycrawl.tools.checkstyle.utils.XpathUtil;
import com.puppycrawl.tools.checkstyle.xpath.AbstractElementNode;
import com.puppycrawl.tools.checkstyle.xpath.AbstractNode;
import com.puppycrawl.tools.checkstyle.xpath.AttributeNode;
import java.util.List;

public class ElementNode
extends AbstractElementNode {
    private final DetailAST detailAst;

    public ElementNode(AbstractNode root, AbstractNode parent, DetailAST detailAst, int depth, int indexAmongSiblings) {
        super(root, parent, depth, indexAmongSiblings);
        this.detailAst = detailAst;
    }

    @Override
    protected List<AbstractNode> createChildren() {
        return XpathUtil.createChildren(this.getRoot(), this, this.detailAst.getFirstChild());
    }

    public boolean hasChildNodes() {
        return this.detailAst.hasChildren();
    }

    public String getLocalPart() {
        return TokenUtil.getTokenName(this.detailAst.getType());
    }

    public int getLineNumber() {
        return this.detailAst.getLineNo();
    }

    public int getColumnNumber() {
        return this.detailAst.getColumnNo();
    }

    @Override
    public int getTokenType() {
        return this.detailAst.getType();
    }

    @Override
    public DetailAST getUnderlyingNode() {
        return this.detailAst;
    }

    @Override
    protected AttributeNode createAttributeNode() {
        AttributeNode result = XpathUtil.supportsTextAttribute(this.detailAst) ? new AttributeNode("text", XpathUtil.getTextAttributeValue(this.detailAst)) : null;
        return result;
    }
}

