/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

@FileStatefulCheck
public class FinalLocalVariableCheck
extends AbstractCheck {
    public static final String MSG_KEY = "final.variable";
    private static final BitSet ASSIGN_OPERATOR_TYPES = TokenUtil.asBitSet(25, 26, 80, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 129, 130);
    private static final BitSet LOOP_TYPES = TokenUtil.asBitSet(91, 84, 85);
    private final Deque<ScopeData> scopeStack = new ArrayDeque<ScopeData>();
    private final Deque<Deque<DetailAST>> prevScopeUninitializedVariables = new ArrayDeque<Deque<DetailAST>>();
    private final Deque<Deque<DetailAST>> currentScopeAssignedVariables = new ArrayDeque<Deque<DetailAST>>();
    private boolean validateEnhancedForLoopVariable;

    public final void setValidateEnhancedForLoopVariable(boolean validateEnhancedForLoopVariable) {
        this.validateEnhancedForLoopVariable = validateEnhancedForLoopVariable;
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{58, 8, 9, 7, 6, 86, 91, 28};
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{58, 8, 9, 7, 6, 86, 91, 10, 28};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{58, 8, 9, 7, 6, 86, 91, 10, 21, 28};
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 6: 
            case 8: 
            case 9: 
            case 91: {
                this.scopeStack.push(new ScopeData());
                break;
            }
            case 7: {
                this.currentScopeAssignedVariables.push(new ArrayDeque());
                if (ast.getParent().getType() == 33 && ast.getParent().getParent().findFirstToken(33) != ast.getParent()) break;
                this.storePrevScopeUninitializedVariableData();
                this.scopeStack.push(new ScopeData());
                break;
            }
            case 21: {
                if (FinalLocalVariableCheck.isInLambda(ast) || ast.findFirstToken(5).findFirstToken(39) != null || FinalLocalVariableCheck.isInAbstractOrNativeMethod(ast) || ScopeUtil.isInInterfaceBlock(ast) || FinalLocalVariableCheck.isMultipleTypeCatch(ast) || CheckUtil.isReceiverParameter(ast)) break;
                this.insertParameter(ast);
                break;
            }
            case 10: {
                if (ast.getParent().getType() == 6 || ast.findFirstToken(5).findFirstToken(39) != null || FinalLocalVariableCheck.isVariableInForInit(ast) || !this.shouldCheckEnhancedForLoopVariable(ast)) break;
                this.insertVariable(ast);
                break;
            }
            case 58: {
                int parentType = ast.getParent().getType();
                if (!FinalLocalVariableCheck.isAssignOperator(parentType) || !FinalLocalVariableCheck.isFirstChild(ast)) break;
                Optional<FinalVariableCandidate> candidate = this.getFinalCandidate(ast);
                if (candidate.isPresent()) {
                    FinalLocalVariableCheck.determineAssignmentConditions(ast, candidate.get());
                    this.currentScopeAssignedVariables.peek().add(ast);
                }
                this.removeFinalVariableCandidateFromStack(ast);
                break;
            }
            case 86: {
                this.scopeStack.peek().containsBreak = true;
                break;
            }
            case 28: {
                if (ast.getParent().getType() != 208) break;
                this.storePrevScopeUninitializedVariableData();
                break;
            }
            default: {
                throw new IllegalStateException("Incorrect token type");
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        Map<String, FinalVariableCandidate> scope = null;
        DetailAST parentAst = ast.getParent();
        switch (ast.getType()) {
            case 6: 
            case 8: 
            case 9: 
            case 91: {
                scope = this.scopeStack.pop().scope;
                break;
            }
            case 28: {
                if (parentAst.getType() != 208) break;
                Deque<DetailAST> prevScopeUninitializedVariableData = this.prevScopeUninitializedVariables.peek();
                if (!FinalLocalVariableCheck.shouldUpdateUninitializedVariables(parentAst)) break;
                this.updateAllUninitializedVariables(prevScopeUninitializedVariableData);
                break;
            }
            case 7: {
                Deque<DetailAST> prevScopeUninitializedVariableData = this.prevScopeUninitializedVariables.peek();
                boolean containsBreak = false;
                if (parentAst.getType() != 33 || FinalLocalVariableCheck.findLastCaseGroupWhichContainsSlist(parentAst.getParent()) == parentAst) {
                    containsBreak = this.scopeStack.peek().containsBreak;
                    scope = this.scopeStack.pop().scope;
                    this.prevScopeUninitializedVariables.pop();
                }
                if (containsBreak || FinalLocalVariableCheck.shouldUpdateUninitializedVariables(parentAst)) {
                    this.updateAllUninitializedVariables(prevScopeUninitializedVariableData);
                }
                this.updateCurrentScopeAssignedVariables();
                break;
            }
        }
        if (scope != null) {
            for (FinalVariableCandidate candidate : scope.values()) {
                DetailAST ident = candidate.variableIdent;
                this.log(ident, MSG_KEY, ident.getText());
            }
        }
    }

    private void updateCurrentScopeAssignedVariables() {
        Deque<DetailAST> poppedScopeAssignedVariableData = this.currentScopeAssignedVariables.pop();
        Deque<DetailAST> currentScopeAssignedVariableData = this.currentScopeAssignedVariables.peek();
        if (currentScopeAssignedVariableData != null) {
            currentScopeAssignedVariableData.addAll(poppedScopeAssignedVariableData);
        }
    }

    private static void determineAssignmentConditions(DetailAST ident, FinalVariableCandidate candidate) {
        if (candidate.assigned) {
            int[] blockTypes = new int[]{92, 33, 208};
            if (!FinalLocalVariableCheck.isInSpecificCodeBlocks(ident, blockTypes)) {
                candidate.alreadyAssigned = true;
            }
        } else {
            candidate.assigned = true;
        }
    }

    private static boolean isInSpecificCodeBlocks(DetailAST node, int ... blockTypes) {
        boolean returnValue = false;
        block0: for (int blockType : blockTypes) {
            for (DetailAST token = node.getParent(); token != null; token = token.getParent()) {
                int type = token.getType();
                if (type != blockType) continue;
                returnValue = true;
                continue block0;
            }
        }
        return returnValue;
    }

    private Optional<FinalVariableCandidate> getFinalCandidate(DetailAST ast) {
        Optional<FinalVariableCandidate> result = Optional.empty();
        Iterator<ScopeData> iterator = this.scopeStack.descendingIterator();
        while (iterator.hasNext() && result.isEmpty()) {
            ScopeData scopeData = iterator.next();
            result = scopeData.findFinalVariableCandidateForAst(ast);
        }
        return result;
    }

    private void storePrevScopeUninitializedVariableData() {
        ScopeData scopeData = this.scopeStack.peek();
        ArrayDeque prevScopeUninitializedVariableData = new ArrayDeque();
        scopeData.uninitializedVariables.forEach(prevScopeUninitializedVariableData::push);
        this.prevScopeUninitializedVariables.push(prevScopeUninitializedVariableData);
    }

    private void updateAllUninitializedVariables(Deque<DetailAST> prevScopeUninitializedVariableData) {
        boolean hasSomeScopes;
        boolean bl = hasSomeScopes = !this.currentScopeAssignedVariables.isEmpty();
        if (hasSomeScopes) {
            this.updateUninitializedVariables(prevScopeUninitializedVariableData);
            this.prevScopeUninitializedVariables.forEach(this::updateUninitializedVariables);
        }
    }

    private void updateUninitializedVariables(Deque<DetailAST> scopeUninitializedVariableData) {
        Iterator<DetailAST> iterator = this.currentScopeAssignedVariables.peek().iterator();
        while (iterator.hasNext()) {
            DetailAST assignedVariable = iterator.next();
            boolean shouldRemove = false;
            for (DetailAST variable : scopeUninitializedVariableData) {
                for (ScopeData scopeData : this.scopeStack) {
                    FinalVariableCandidate candidate = scopeData.scope.get(variable.getText());
                    DetailAST storedVariable = null;
                    if (candidate != null) {
                        storedVariable = candidate.variableIdent;
                    }
                    if (storedVariable == null || !FinalLocalVariableCheck.isSameVariables(storedVariable, variable) || !FinalLocalVariableCheck.isSameVariables(assignedVariable, variable)) continue;
                    scopeData.uninitializedVariables.push(variable);
                    shouldRemove = true;
                }
            }
            if (!shouldRemove) continue;
            iterator.remove();
        }
    }

    private static boolean shouldUpdateUninitializedVariables(DetailAST ast) {
        return ast.getLastChild().getType() == 92 || FinalLocalVariableCheck.isCaseTokenWithAnotherCaseFollowing(ast);
    }

    private static boolean isCaseTokenWithAnotherCaseFollowing(DetailAST ast) {
        boolean result = false;
        if (ast.getType() == 33) {
            result = FinalLocalVariableCheck.findLastCaseGroupWhichContainsSlist(ast.getParent()) != ast;
        } else if (ast.getType() == 208) {
            result = ast.getNextSibling().getType() == 208;
        }
        return result;
    }

    private static DetailAST findLastCaseGroupWhichContainsSlist(DetailAST literalSwitchAst) {
        DetailAST returnValue = null;
        for (DetailAST astIterator = literalSwitchAst.getFirstChild(); astIterator != null; astIterator = astIterator.getNextSibling()) {
            if (astIterator.findFirstToken(7) == null) continue;
            returnValue = astIterator;
        }
        return returnValue;
    }

    private boolean shouldCheckEnhancedForLoopVariable(DetailAST ast) {
        return this.validateEnhancedForLoopVariable || ast.getParent().getType() != 156;
    }

    private void insertParameter(DetailAST ast) {
        Map<String, FinalVariableCandidate> scope = this.scopeStack.peek().scope;
        DetailAST astNode = ast.findFirstToken(58);
        scope.put(astNode.getText(), new FinalVariableCandidate(astNode));
    }

    private void insertVariable(DetailAST ast) {
        Map<String, FinalVariableCandidate> scope = this.scopeStack.peek().scope;
        DetailAST astNode = ast.findFirstToken(58);
        FinalVariableCandidate candidate = new FinalVariableCandidate(astNode);
        candidate.assigned = ast.getParent().getType() == 156;
        scope.put(astNode.getText(), candidate);
        if (!FinalLocalVariableCheck.isInitialized(astNode)) {
            this.scopeStack.peek().uninitializedVariables.add(astNode);
        }
    }

    private static boolean isInitialized(DetailAST ast) {
        return ast.getParent().getLastChild().getType() == 80;
    }

    private static boolean isFirstChild(DetailAST ast) {
        return ast.getPreviousSibling() == null;
    }

    private void removeFinalVariableCandidateFromStack(DetailAST ast) {
        Iterator<ScopeData> iterator = this.scopeStack.descendingIterator();
        while (iterator.hasNext()) {
            ScopeData scopeData = iterator.next();
            Map<String, FinalVariableCandidate> scope = scopeData.scope;
            FinalVariableCandidate candidate = scope.get(ast.getText());
            DetailAST storedVariable = null;
            if (candidate != null) {
                storedVariable = candidate.variableIdent;
            }
            if (storedVariable == null || !FinalLocalVariableCheck.isSameVariables(storedVariable, ast)) continue;
            if (!FinalLocalVariableCheck.shouldRemoveFinalVariableCandidate(scopeData, ast)) break;
            scope.remove(ast.getText());
            break;
        }
    }

    private static boolean isMultipleTypeCatch(DetailAST parameterDefAst) {
        DetailAST typeAst = parameterDefAst.findFirstToken(13);
        return typeAst.findFirstToken(112) != null;
    }

    private static boolean shouldRemoveFinalVariableCandidate(ScopeData scopeData, DetailAST ast) {
        boolean shouldRemove = true;
        for (DetailAST variable : scopeData.uninitializedVariables) {
            DetailAST currVarLoopAstParent;
            if (!variable.getText().equals(ast.getText())) continue;
            DetailAST currAstLoopAstParent = FinalLocalVariableCheck.getLoopAstParent(ast);
            if (currAstLoopAstParent == (currVarLoopAstParent = FinalLocalVariableCheck.getLoopAstParent(variable))) {
                FinalVariableCandidate candidate = scopeData.scope.get(ast.getText());
                shouldRemove = candidate.alreadyAssigned;
            }
            scopeData.uninitializedVariables.remove(variable);
            break;
        }
        return shouldRemove;
    }

    private static DetailAST getLoopAstParent(DetailAST ast) {
        DetailAST loopAstParent;
        for (loopAstParent = ast.getParent(); loopAstParent != null && !FinalLocalVariableCheck.isLoopAst(loopAstParent.getType()); loopAstParent = loopAstParent.getParent()) {
        }
        return loopAstParent;
    }

    private static boolean isAssignOperator(int parentType) {
        return ASSIGN_OPERATOR_TYPES.get(parentType);
    }

    private static boolean isVariableInForInit(DetailAST variableDef) {
        return variableDef.getParent().getType() == 35;
    }

    private static boolean isInAbstractOrNativeMethod(DetailAST ast) {
        boolean abstractOrNative = false;
        for (DetailAST parent = ast.getParent(); parent != null && !abstractOrNative; parent = parent.getParent()) {
            if (parent.getType() != 9) continue;
            DetailAST modifiers = parent.findFirstToken(5);
            abstractOrNative = modifiers.findFirstToken(40) != null || modifiers.findFirstToken(66) != null;
        }
        return abstractOrNative;
    }

    private static boolean isInLambda(DetailAST paramDef) {
        return paramDef.getParent().getParent().getType() == 181;
    }

    private static DetailAST findFirstUpperNamedBlock(DetailAST ast) {
        DetailAST astTraverse = ast;
        while (!TokenUtil.isOfType(astTraverse, 9, 14, 154, 8, 203) && !ScopeUtil.isClassFieldDef(astTraverse)) {
            astTraverse = astTraverse.getParent();
        }
        return astTraverse;
    }

    private static boolean isSameVariables(DetailAST ast1, DetailAST ast2) {
        DetailAST classOrMethodOfAst2;
        DetailAST classOrMethodOfAst1 = FinalLocalVariableCheck.findFirstUpperNamedBlock(ast1);
        return classOrMethodOfAst1 == (classOrMethodOfAst2 = FinalLocalVariableCheck.findFirstUpperNamedBlock(ast2)) && ast1.getText().equals(ast2.getText());
    }

    private static boolean isLoopAst(int ast) {
        return LOOP_TYPES.get(ast);
    }

    private static final class FinalVariableCandidate {
        private final DetailAST variableIdent;
        private boolean assigned;
        private boolean alreadyAssigned;

        private FinalVariableCandidate(DetailAST variableIdent) {
            this.variableIdent = variableIdent;
        }
    }

    private static final class ScopeData {
        private final Map<String, FinalVariableCandidate> scope = new HashMap<String, FinalVariableCandidate>();
        private final Deque<DetailAST> uninitializedVariables = new ArrayDeque<DetailAST>();
        private boolean containsBreak;

        private ScopeData() {
        }

        public Optional<FinalVariableCandidate> findFinalVariableCandidateForAst(DetailAST ast) {
            Optional<FinalVariableCandidate> result = Optional.empty();
            DetailAST storedVariable = null;
            Optional<FinalVariableCandidate> candidate = Optional.ofNullable(this.scope.get(ast.getText()));
            if (candidate.isPresent()) {
                storedVariable = candidate.get().variableIdent;
            }
            if (storedVariable != null && FinalLocalVariableCheck.isSameVariables(storedVariable, ast)) {
                result = candidate;
            }
            return result;
        }
    }
}

