/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.PKCS12;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.PBE;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class PKCS12Safe
implements ASN1Object,
Externalizable {
    private PKCS12 parent;
    private ASN1ObjectID pbeOID;
    private AlgorithmIdentifier prfAlgID;
    private AlgorithmIdentifier cipherAlgID;
    private ArrayList<PKCS12Bag> bags;
    private char[] passwd;
    private ASN1Sequence contents;

    public PKCS12Safe() {
    }

    public PKCS12Safe(PKCS12 parent) {
        this.parent = parent;
        this.bags = new ArrayList();
    }

    public PKCS12Safe(PKCS12 parent, int mode) {
        this(parent);
        this.setMode(mode);
    }

    public PKCS12Safe(PKCS12 parent, ASN1ObjectID pbeOID) {
        this(parent);
        this.setPBEOID(pbeOID);
    }

    public PKCS12Safe(PKCS12 parent, InputStream is) throws IOException {
        this(parent);
        this.input(is);
    }

    public PKCS12Safe(PKCS12 parent, ASN1Sequence s) throws IOException {
        this(parent);
        this.input(s);
    }

    void reset() {
        this.contents = null;
        if (this.parent != null) {
            this.parent.reset();
        }
    }

    public void input(InputStream is) throws IOException {
        this.input(new ASN1Sequence(is));
    }

    public void input(ASN1Sequence s) throws IOException {
        this.reset();
        try {
            ASN1ObjectID ct = (ASN1ObjectID)s.elementAt(0);
            ASN1GenericConstructed c = (ASN1GenericConstructed)s.elementAt(1);
            byte[] plain = null;
            if (ct.equals(ASN1Utils.pkcsID, 7, 1)) {
                this.pbeOID = null;
                plain = ((ASN1OctetString)c.elementAt(0)).getValue();
            } else if (ct.equals(ASN1Utils.pkcsID, 7, 6)) {
                byte[] content;
                ASN1Sequence ed = (ASN1Sequence)c.elementAt(0);
                ASN1Sequence eci = (ASN1Sequence)ed.elementAt(1);
                ASN1Sequence cea = (ASN1Sequence)eci.elementAt(1);
                PBEAlgorithmIdentifier algID = new PBEAlgorithmIdentifier(Utils.toStream((Streamable)cea));
                this.pbeOID = algID.getOID();
                this.cipherAlgID = algID.getEncryptionScheme();
                this.prfAlgID = algID.getPseudorandomFunc();
                ASN1Object ec = eci.elementAt(2);
                if (ec instanceof ASN1GenericPrimitive) {
                    content = ((ASN1OctetString)((ASN1GenericPrimitive)ec).withTag(4)).getValue();
                } else if (ec instanceof ASN1GenericConstructed) {
                    ArrayList v = ((ASN1GenericConstructed)ec).elementsAsList();
                    byte[][] vals = new byte[v.size()][0];
                    int len = 0;
                    int size = vals.length;
                    for (int i = 0; i < size; ++i) {
                        vals[i] = ((ASN1OctetString)v.get(i)).getValue();
                        len += vals[i].length;
                    }
                    content = new byte[len];
                    int off = 0;
                    int size2 = vals.length;
                    for (int i = 0; i < size2; ++i) {
                        System.arraycopy(vals[i], 0, content, off, vals[i].length);
                        off += vals[i].length;
                    }
                } else {
                    throw new InvalidInputException("Cound not read encrypted content.");
                }
                PBE pbe = PBE.getInstance((AlgorithmIdentifier)algID);
                plain = pbe.decrypt(this.getPassword(), content);
            } else {
                throw new IOException("Unrecognized ContentType " + ct);
            }
            ASN1SequenceInputStream sc = new ASN1SequenceInputStream((InputStream)new UnsyncByteArrayInputStream(plain));
            while (sc.hasMoreData()) {
                this.addBag(PKCS12Bag.inputBag(this, new ASN1Sequence((InputStream)sc)));
            }
            sc.terminate();
        }
        catch (ClassCastException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (CipherException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        catch (AlgorithmIdentifierException ex) {
            throw new ASN1FormatException(ex.toString());
        }
        this.contents = s;
    }

    private static byte[] makeSalt() {
        return PKCS12Safe.randomBytes(8);
    }

    private static byte[] makeAES_CBC_IV() {
        return PKCS12Safe.randomBytes(16);
    }

    private static byte[] randomBytes(int numBytes) {
        byte[] bytes;
        if (TransitionMode.isJCEUseEnabled()) {
            SecureRandom rand = JCEUtil.getSecureRandom();
            bytes = new byte[numBytes];
            rand.nextBytes(bytes);
        } else {
            bytes = RandomBitsSource.getDefault().randomBytes(new byte[numBytes]);
        }
        return bytes;
    }

    public void output(OutputStream os) throws IOException {
        this.outputASN1().output(os);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence s = new ASN1Sequence();
        byte[] plain = Utils.toBytes((Streamable)new ASN1Sequence(this.bags));
        if (this.pbeOID == null) {
            s.addElement((ASN1Object)new ASN1ObjectID(ASN1Utils.pkcsID, 7, 1));
            s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)new ASN1OctetString(plain), 0));
        } else {
            try {
                PBEAlgorithmIdentifier pbeAlgoId;
                byte[] salt = PKCS12Safe.makeSalt();
                if (this.pbeOID.equals((Object)PBEAlgorithmIdentifier.id_PBES2)) {
                    int keyLength = 0;
                    if (this.cipherAlgID.getOID().equals((Object)AlgID.aes128_CBC.getOID())) {
                        keyLength = 16;
                    } else if (this.cipherAlgID.getOID().equals((Object)AlgID.aes192_CBC.getOID())) {
                        keyLength = 24;
                    } else if (this.cipherAlgID.getOID().equals((Object)AlgID.aes256_CBC.getOID())) {
                        keyLength = 32;
                    }
                    byte[] iv = PKCS12Safe.makeAES_CBC_IV();
                    pbeAlgoId = new PBEAlgorithmIdentifier(salt, 10000, keyLength, this.prfAlgID, (AlgorithmIdentifier)new CBCAlgorithmIdentifier(this.cipherAlgID.getOID(), iv));
                } else {
                    pbeAlgoId = new PBEAlgorithmIdentifier(this.pbeOID, salt, 10000);
                }
                PBE pbe = PBE.getInstance((AlgorithmIdentifier)pbeAlgoId);
                byte[] cipher = pbe.encrypt(this.getPassword(), plain);
                s.addElement((ASN1Object)new ASN1ObjectID(ASN1Utils.pkcsID, 7, 6));
                ASN1Sequence ed = new ASN1Sequence();
                ed.addElement((ASN1Object)new ASN1Integer(0L));
                ASN1Sequence eci = new ASN1Sequence();
                eci.addElement((ASN1Object)new ASN1ObjectID(ASN1Utils.pkcsID, 7, 1));
                eci.addElement((ASN1Object)pbeAlgoId);
                eci.addElement((ASN1Object)new ASN1GenericPrimitive((ASN1Object)new ASN1OctetString(cipher), 0));
                ed.addElement((ASN1Object)eci);
                s.addElement((ASN1Object)new ASN1GenericConstructed((ASN1Object)ed, 0));
            }
            catch (AlgorithmIdentifierException ex) {
                throw new StreamableOutputException(ex.toString());
            }
            catch (CipherException ce) {
                throw new StreamableOutputException(ce.toString());
            }
        }
        this.contents = s;
        return s;
    }

    public int length() {
        return this.outputASN1().length();
    }

    public void setPassword(String passwd) {
        this.passwd = passwd == null ? null : passwd.toCharArray();
        this.reset();
    }

    public void setPasswd(char[] passwd) {
        this.passwd = passwd;
        this.reset();
    }

    public String getPassword() {
        return this.passwd != null ? new String(this.passwd) : this.parent.getPassword();
    }

    public char[] getPasswd() {
        return this.passwd != null ? this.passwd : this.parent.getPasswd();
    }

    public Vector<PKCS12Bag> getBags() {
        return this.bags == null ? null : new VectorOverArrayList(this.bags);
    }

    public ArrayList<PKCS12Bag> getBagsAsList() {
        return this.bags;
    }

    public void setBags(Vector<PKCS12Bag> bags) {
        this.setBags((List<PKCS12Bag>)bags);
    }

    public void setBags(List<PKCS12Bag> bags) {
        this.bags = bags == null ? null : (bags instanceof ArrayList ? (ArrayList<Object>)bags : new ArrayList<PKCS12Bag>(bags));
        this.reset();
    }

    public void addBag(PKCS12Bag b) {
        this.bags.add(b);
        this.reset();
    }

    public int getMode() {
        if (this.pbeOID == null) {
            return 0;
        }
        if (this.pbeOID.equals((Object)PBEAlgorithmIdentifier.pbeWithMD2AndDES_CBC)) {
            return -2;
        }
        if (this.pbeOID.equals((Object)PBEAlgorithmIdentifier.pbeWithMD5AndDES_CBC)) {
            return -1;
        }
        return this.pbeOID.getValue()[this.pbeOID.getValue().length - 1];
    }

    public void setMode(int mode) {
        this.reset();
        if (mode == -2) {
            this.setPBEOID(PBEAlgorithmIdentifier.pbeWithMD2AndDES_CBC);
        } else if (mode == -1) {
            this.setPBEOID(PBEAlgorithmIdentifier.pbeWithMD5AndDES_CBC);
        } else if (mode == 0) {
            this.setPBEOID(null);
        } else {
            this.setPBEOID(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs12PBEids, mode));
        }
    }

    public void setPBEOID(ASN1ObjectID pbeOID) {
        this.pbeOID = pbeOID;
        this.reset();
    }

    public void setPBES2Parameters(ASN1ObjectID pbeOID, AlgorithmIdentifier prfAlgID, AlgorithmIdentifier cipherAlgID) {
        this.pbeOID = pbeOID;
        this.prfAlgID = prfAlgID;
        this.cipherAlgID = cipherAlgID;
        this.reset();
    }

    public ASN1ObjectID getPBEOID() {
        return this.pbeOID;
    }

    public String toString() {
        String s = "pbeOID = {" + this.pbeOID + "}";
        for (PKCS12Bag b : this.bags) {
            s = s + ", {" + b + "}";
        }
        return s;
    }

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    @Override
    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

