/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.cert.ext.AuthorityKeyIDExtension;
import oracle.security.crypto.cert.ext.BasicConstraintsExtension;
import oracle.security.crypto.cert.ext.CRLNumberExtension;
import oracle.security.crypto.cert.ext.CertificatePoliciesExtension;
import oracle.security.crypto.cert.ext.KeyUsageExtension;
import oracle.security.crypto.cert.ext.NetscapeCertTypeExtension;
import oracle.security.crypto.cert.ext.SubjectKeyIDExtension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class X509Attributes {
    public static final int CERTIFICATE = 0;
    public static final int CR_LIST = 1;
    public static final int OTHER = 2;
    private boolean CA;
    private boolean CACritical;
    private boolean CADefined;
    public static final int DIGITAL_SIGNATURE = 1;
    public static final int NON_REPUDIATION = 2;
    public static final int KEY_ENCIPHERMENT = 4;
    public static final int DATA_ENCIPHERMENT = 8;
    public static final int KEY_AGREEMENT = 16;
    public static final int KEY_CERT_SIGN = 32;
    public static final int CRL_SIGN = 64;
    public static final int ENCIPHER_ONLY = 128;
    public static final int DECIPHER_ONLY = 256;
    private int keyUsage;
    private boolean kuCritical;
    private boolean kuDefined;
    private Vector certificatePolicies;
    private boolean cpCritical;
    private boolean cpDefined;
    private byte[] authorityKeyID;
    private X500Name authorityKeyIssuer;
    private BigInteger authorityKeySerial;
    private boolean akidCritical;
    private boolean akidIsnDefined;
    private boolean akidIdDefined;
    private byte[] subjectKeyID;
    private boolean skidCritical;
    private boolean skidDefined;
    public static final int NETSCAPE_SSL_CLIENT = 1;
    public static final int NETSCAPE_SSL_SERVER = 2;
    public static final int NETSCAPE_EMAIL = 4;
    public static final int NETSCAPE_OBJECT_SIGNER = 8;
    public static final int NETSCAPE_SSL_CA = 32;
    public static final int NETSCAPE_EMAIL_CA = 64;
    public static final int NETSCAPE_CODE_SIGNING_CA = 128;
    private int netscapeCertType;
    private boolean nctCritical;
    private boolean nctDefined;
    public static final int SET_CARD = 1;
    public static final int SET_MER = 2;
    public static final int SET_PGWY = 4;
    public static final int SET_CCA = 8;
    public static final int SET_MCA = 16;
    public static final int SET_PCA = 32;
    public static final int SET_GCA = 64;
    public static final int SET_BCA = 128;
    public static final int SET_RCA = 256;
    public static final int SET_ACQ = 512;
    private int setCertType;
    private boolean sctCritical;
    private boolean sctDefined;
    private BigInteger CRLNumber;
    private boolean crlnCritical;
    private boolean crlnDefined;
    private Vector genericExts;

    public static X509ExtensionSet toExtensionSet(X509Attributes attr) {
        X509Extension ext;
        X509ExtensionSet set = new X509ExtensionSet();
        if (attr.CADefined) {
            set.addExtension(new BasicConstraintsExtension(attr.CA, attr.CACritical));
        }
        if (attr.kuDefined) {
            ext = new KeyUsageExtension(attr.kuCritical);
            if ((attr.keyUsage & 1) != 0) {
                ((KeyUsageExtension)ext).setUsageFlag(0);
            }
            if ((attr.keyUsage & 2) != 0) {
                ((KeyUsageExtension)ext).setUsageFlag(1);
            }
            if ((attr.keyUsage & 4) != 0) {
                ((KeyUsageExtension)ext).setUsageFlag(2);
            }
            if ((attr.keyUsage & 8) != 0) {
                ((KeyUsageExtension)ext).setUsageFlag(3);
            }
            if ((attr.keyUsage & 0x10) != 0) {
                ((KeyUsageExtension)ext).setUsageFlag(4);
            }
            if ((attr.keyUsage & 0x20) != 0) {
                ((KeyUsageExtension)ext).setUsageFlag(5);
            }
            if ((attr.keyUsage & 0x40) != 0) {
                ((KeyUsageExtension)ext).setUsageFlag(6);
            }
            if ((attr.keyUsage & 0x80) != 0) {
                ((KeyUsageExtension)ext).setUsageFlag(7);
            }
            if ((attr.keyUsage & 0x100) != 0) {
                ((KeyUsageExtension)ext).setUsageFlag(8);
            }
            set.addExtension(ext);
        }
        if (attr.cpDefined) {
            set.addExtension(new CertificatePoliciesExtension(attr.certificatePolicies, attr.cpCritical));
        }
        if (attr.akidIdDefined) {
            set.addExtension(new AuthorityKeyIDExtension(attr.authorityKeyID, attr.akidCritical));
        } else if (attr.akidIsnDefined) {
            set.addExtension(new AuthorityKeyIDExtension(new GeneralName(attr.authorityKeyIssuer), attr.authorityKeySerial, attr.akidCritical));
        }
        if (attr.skidDefined) {
            set.addExtension(new SubjectKeyIDExtension(attr.subjectKeyID, attr.skidCritical));
        }
        if (attr.nctDefined) {
            ext = new NetscapeCertTypeExtension(attr.nctCritical);
            if ((attr.netscapeCertType & 1) != 0) {
                ((NetscapeCertTypeExtension)ext).setUsageFlag(0);
            }
            if ((attr.netscapeCertType & 2) != 0) {
                ((NetscapeCertTypeExtension)ext).setUsageFlag(1);
            }
            if ((attr.netscapeCertType & 4) != 0) {
                ((NetscapeCertTypeExtension)ext).setUsageFlag(2);
            }
            if ((attr.netscapeCertType & 8) != 0) {
                ((NetscapeCertTypeExtension)ext).setUsageFlag(3);
            }
            if ((attr.netscapeCertType & 0x20) != 0) {
                ((NetscapeCertTypeExtension)ext).setUsageFlag(5);
            }
            if ((attr.netscapeCertType & 0x40) != 0) {
                ((NetscapeCertTypeExtension)ext).setUsageFlag(6);
            }
            if ((attr.netscapeCertType & 0x80) != 0) {
                ((NetscapeCertTypeExtension)ext).setUsageFlag(7);
            }
            set.addExtension(ext);
        }
        if (attr.sctDefined) {
            set.addExtension(new X509Extension(X509Extension.id_set_ce_type, attr.sctCritical, (ASN1Object)new ASN1BitString(BigInteger.valueOf(attr.setCertType))));
        }
        if (attr.crlnDefined) {
            set.addExtension(new CRLNumberExtension(attr.CRLNumber, attr.crlnCritical));
        }
        if (attr.genericExts != null) {
            Enumeration e = attr.genericExts.elements();
            while (e.hasMoreElements()) {
                set.addExtension((X509Extension)e.nextElement());
            }
        }
        return set;
    }

    public static X509Attributes fromExtensionSet(X509ExtensionSet set, int container) {
        X509Attributes attr = new X509Attributes();
        Enumeration e = set.getExtensions().elements();
        while (e.hasMoreElements()) {
            X509Extension ext = (X509Extension)e.nextElement();
            ASN1ObjectID type = ext.getType();
            if (container == 0 && type.equals((Object)PKIX.id_ce_basicConstraints)) {
                attr.CADefined = true;
                attr.CACritical = ext.getCritical();
                attr.CA = ((BasicConstraintsExtension)ext).getCA();
                continue;
            }
            if (container == 0 && type.equals((Object)PKIX.id_ce_keyUsage)) {
                attr.kuDefined = true;
                attr.kuCritical = ext.getCritical();
                KeyUsageExtension ku = (KeyUsageExtension)ext;
                if (ku.hasUsageFlag(0)) {
                    attr.keyUsage |= 1;
                }
                if (ku.hasUsageFlag(1)) {
                    attr.keyUsage |= 2;
                }
                if (ku.hasUsageFlag(2)) {
                    attr.keyUsage |= 4;
                }
                if (ku.hasUsageFlag(3)) {
                    attr.keyUsage |= 8;
                }
                if (ku.hasUsageFlag(4)) {
                    attr.keyUsage |= 0x10;
                }
                if (ku.hasUsageFlag(5)) {
                    attr.keyUsage |= 0x20;
                }
                if (ku.hasUsageFlag(6)) {
                    attr.keyUsage |= 0x40;
                }
                if (ku.hasUsageFlag(7)) {
                    attr.keyUsage |= 0x80;
                }
                if (!ku.hasUsageFlag(8)) continue;
                attr.keyUsage |= 0x100;
                continue;
            }
            if (container == 0 && type.equals((Object)PKIX.id_ce_certificatePolicies)) {
                attr.cpDefined = true;
                attr.cpCritical = ext.getCritical();
                attr.certificatePolicies = ((CertificatePoliciesExtension)ext).getCertificatePolicies();
                continue;
            }
            if ((container == 0 || container == 1) && type.equals((Object)PKIX.id_ce_authorityKeyIdentifier)) {
                attr.akidCritical = ext.getCritical();
                AuthorityKeyIDExtension akid = (AuthorityKeyIDExtension)ext;
                attr.authorityKeyID = akid.getAuthorityKeyID();
                Enumeration i = akid.authorityCertIssuer();
                while (i != null && i.hasMoreElements()) {
                    Object o = i.nextElement();
                    if (!(o instanceof X500Name)) continue;
                    attr.authorityKeyIssuer = (X500Name)o;
                    break;
                }
                attr.authorityKeySerial = akid.getAuthorityCertSerialNo();
                if (attr.authorityKeyID != null) {
                    attr.akidIdDefined = true;
                }
                if (attr.authorityKeyIssuer == null || attr.authorityKeySerial == null) continue;
                attr.akidIsnDefined = true;
                continue;
            }
            if (container == 0 && type.equals((Object)PKIX.id_ce_subjectKeyIdentifier)) {
                attr.skidDefined = true;
                attr.skidCritical = ext.getCritical();
                attr.subjectKeyID = ((SubjectKeyIDExtension)ext).getSubjectKeyID();
                continue;
            }
            if (container == 0 && type.equals((Object)X509Extension.id_netscape_ce_type)) {
                attr.nctDefined = true;
                attr.nctCritical = ext.getCritical();
                NetscapeCertTypeExtension nct = (NetscapeCertTypeExtension)ext;
                if (nct.hasUsageFlag(0)) {
                    attr.netscapeCertType |= 1;
                }
                if (nct.hasUsageFlag(1)) {
                    attr.netscapeCertType |= 2;
                }
                if (nct.hasUsageFlag(2)) {
                    attr.netscapeCertType |= 4;
                }
                if (nct.hasUsageFlag(3)) {
                    attr.netscapeCertType |= 8;
                }
                if (nct.hasUsageFlag(5)) {
                    attr.netscapeCertType |= 0x20;
                }
                if (nct.hasUsageFlag(6)) {
                    attr.netscapeCertType |= 0x40;
                }
                if (!nct.hasUsageFlag(7)) continue;
                attr.netscapeCertType |= 0x80;
                continue;
            }
            if (container == 0 && type.equals((Object)X509Extension.id_set_ce_type)) {
                attr.sctDefined = true;
                attr.sctCritical = ext.getCritical();
                try {
                    attr.setCertType = new ASN1BitString((InputStream)new UnsyncByteArrayInputStream(ext.getValue())).intValue();
                }
                catch (IOException ex) {
                    attr.setCertType = 0;
                }
                continue;
            }
            if (container == 1 && type.equals((Object)PKIX.id_ce_cRLNumber)) {
                attr.crlnDefined = true;
                attr.crlnCritical = ext.getCritical();
                attr.CRLNumber = ((CRLNumberExtension)ext).getCRLNumber();
                continue;
            }
            attr.addGenericExt(ext);
        }
        return attr;
    }

    public boolean isCADefined() {
        return this.CADefined;
    }

    public boolean isCACritical() {
        this.check(this.CADefined);
        return this.CACritical;
    }

    public boolean getCA() {
        this.check(this.CADefined);
        return this.CA;
    }

    public void setCA(boolean CA) {
        this.setCA(CA, true);
    }

    public void setCA(boolean CA, boolean critical) {
        this.CA = CA;
        this.CACritical = critical;
        this.CADefined = true;
    }

    public boolean isKeyUsageDefined() {
        return this.kuDefined;
    }

    public boolean isKeyUsageCritical() {
        this.check(this.kuDefined);
        return this.kuCritical;
    }

    public int getKeyUsage() {
        this.check(this.kuDefined);
        return this.keyUsage;
    }

    public void setKeyUsage(int ku) {
        this.setKeyUsage(ku, true);
    }

    public void setKeyUsage(int ku, boolean critical) {
        this.keyUsage = ku;
        this.kuCritical = critical;
        this.kuDefined = true;
    }

    public boolean isCertificatePoliciesDefined() {
        return this.cpDefined;
    }

    public boolean isCertificatePoliciesCritical() {
        this.check(this.cpDefined);
        return this.cpCritical;
    }

    public Vector getCertificatePolicies() {
        this.check(this.cpDefined);
        return this.certificatePolicies;
    }

    public void setCertificatePolicies(Vector cp) {
        this.setCertificatePolicies(cp, false);
    }

    public void setCertificatePolicies(Vector cp, boolean critical) {
        this.certificatePolicies = cp;
        this.cpCritical = critical;
        this.cpDefined = true;
    }

    public boolean isAuthorityKeyIdentifierDefined() {
        return this.akidIsnDefined || this.akidIdDefined;
    }

    public boolean isAuthorityKeyIdentifierIsnDefined() {
        return this.akidIsnDefined;
    }

    public boolean isAuthorityKeyIdentifierIdDefined() {
        return this.akidIdDefined;
    }

    public boolean isAuthorityKeyIdentifierCritical() {
        this.check(this.akidIsnDefined || this.akidIdDefined);
        return this.akidCritical;
    }

    public X500Name getAuthorityKeyIdentifierIssuer() {
        this.check(this.akidIsnDefined);
        return this.authorityKeyIssuer;
    }

    public BigInteger getAuthorityKeyIdentifierSerialNo() {
        this.check(this.akidIsnDefined);
        return this.authorityKeySerial;
    }

    public byte[] getAuthorityKeyIdentifierID() {
        this.check(this.akidIdDefined);
        return this.authorityKeyID;
    }

    public void setAuthorityKeyIdentifier(byte[] id) {
        this.setAuthorityKeyIdentifier(id, false);
    }

    public void setAuthorityKeyIdentifier(X509 is) {
        this.setAuthorityKeyIdentifier((X500Name)is.getHolder(), is.getSerialNo(), false);
    }

    public void setAuthorityKeyIdentifier(X500Name is, BigInteger sn) {
        this.setAuthorityKeyIdentifier(is, sn, false);
    }

    public void setAuthorityKeyIdentifier(byte[] id, boolean critical) {
        this.authorityKeyID = id;
        this.akidCritical = critical;
        this.akidIdDefined = true;
    }

    public void setAuthorityKeyIdentifier(X509 is, boolean critical) {
        this.setAuthorityKeyIdentifier((X500Name)is.getHolder(), is.getSerialNo(), critical);
    }

    public void setAuthorityKeyIdentifier(X500Name is, BigInteger sn, boolean critical) {
        this.authorityKeyIssuer = is;
        this.authorityKeySerial = sn;
        this.akidCritical = critical;
        this.akidIsnDefined = true;
    }

    public boolean isSubjectKeyIdentifierDefined() {
        return this.skidDefined;
    }

    public boolean isSubjectKeyIdentifierCritical() {
        this.check(this.skidDefined);
        return this.skidCritical;
    }

    public byte[] getSubjectKeyIdentifier() {
        this.check(this.skidDefined);
        return this.subjectKeyID;
    }

    public void setSubjectKeyIdentifier(byte[] id) {
        this.setSubjectKeyIdentifier(id, false);
    }

    public void setSubjectKeyIdentifier(byte[] id, boolean critical) {
        this.subjectKeyID = id;
        this.skidCritical = critical;
        this.skidDefined = true;
    }

    public boolean isNetscapeCertTypeDefined() {
        return this.nctDefined;
    }

    public boolean isNetscapeCertTypeCritical() {
        this.check(this.nctDefined);
        return this.nctCritical;
    }

    public int getNetscapeCertType() {
        this.check(this.nctDefined);
        return this.netscapeCertType;
    }

    public void setNetscapeCertType(int nct) {
        this.setNetscapeCertType(nct, false);
    }

    public void setNetscapeCertType(int nct, boolean critical) {
        this.netscapeCertType = nct;
        this.nctCritical = critical;
        this.nctDefined = true;
    }

    public boolean isSETCertTypeDefined() {
        return this.sctDefined;
    }

    public boolean isSETCertTypeCritical() {
        this.check(this.sctDefined);
        return this.sctCritical;
    }

    public int getSETCertType() {
        this.check(this.sctDefined);
        return this.setCertType;
    }

    public void setSETCertType(int sct) {
        this.setSETCertType(sct, true);
    }

    public void setSETCertType(int sct, boolean critical) {
        this.setCertType = sct;
        this.sctCritical = critical;
        this.sctDefined = true;
    }

    public boolean isCRLNumberDefined() {
        return this.crlnDefined;
    }

    public boolean isCRLNumberCritical() {
        this.check(this.crlnDefined);
        return this.crlnCritical;
    }

    public BigInteger getCRLNumber() {
        this.check(this.crlnDefined);
        return this.CRLNumber;
    }

    public void setCRLNumber(BigInteger cn) {
        this.setCRLNumber(cn, false);
    }

    public void setCRLNumber(BigInteger cn, boolean critical) {
        this.CRLNumber = cn;
        this.crlnCritical = critical;
        this.crlnDefined = true;
    }

    public Vector getGenericExts() {
        return this.genericExts;
    }

    public void setGenericExts(Vector genericExts) {
        this.genericExts = genericExts;
    }

    public void addGenericExt(X509Extension ext) {
        if (this.genericExts == null) {
            this.genericExts = new Vector();
        }
        this.genericExts.addElement(ext);
    }

    private void check(boolean defined) throws IllegalStateException {
        if (!defined) {
            throw new IllegalStateException("Attempt to access an undefined attribute");
        }
    }

    public String toString() {
        int i;
        boolean m;
        String[] attr;
        String s = "";
        if (this.CADefined) {
            s = s + ", CA = " + this.CA;
        }
        if (this.kuDefined) {
            attr = new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly"};
            s = s + ", keyUsage = {";
            m = false;
            for (i = 0; i < 7; ++i) {
                if ((this.keyUsage & 1 << i) == 0) continue;
                if (m) {
                    s = s + ", ";
                }
                m = true;
                s = s + attr[i];
            }
            s = s + "}";
        }
        if (this.cpDefined) {
            s = s + ", certificatePolicies = " + this.certificatePolicies;
        }
        if (this.skidDefined) {
            s = s + ", subjectKeyIdentifier = " + Utils.toHexString((byte[])this.subjectKeyID);
        }
        if (this.akidIdDefined || this.akidIsnDefined) {
            s = s + ", authorityKeyIdentifier = ";
            s = this.akidIsnDefined ? s + "{issuer = " + this.authorityKeyIssuer + ", serialNo = " + this.authorityKeySerial + "}" : s + "{keyID = " + Utils.toHexString((byte[])this.authorityKeyID) + "}";
        }
        if (this.nctDefined) {
            attr = new String[]{"SSL-client", "SSL-server", "E-mail", "Object-Signer", "unknown4", "SSL-CA", "E-mail-CA", "Object-Signing-CA"};
            s = s + ", netscapeCertType = {";
            m = false;
            for (i = 0; i < 8; ++i) {
                if ((this.netscapeCertType & 1 << i) == 0) continue;
                if (m) {
                    s = s + ", ";
                }
                m = true;
                s = s + attr[i];
            }
            s = s + "}";
        }
        if (this.sctDefined) {
            attr = new String[]{"card", "mer", "pgwy", "cca", "mca", "pca", "gca", "bca", "rca", "acq"};
            s = s + ", setCertType = {";
            m = false;
            for (i = 0; i < 10; ++i) {
                if ((this.setCertType & 1 << i) == 0) continue;
                if (m) {
                    s = s + ", ";
                }
                m = true;
                s = s + attr[i];
            }
            s = s + "}";
        }
        if (this.crlnDefined) {
            s = s + ", CRLNumber = " + this.CRLNumber;
        }
        if (this.genericExts != null && this.genericExts.size() > 0) {
            s = s + ", genericExts = {";
            boolean mid = false;
            Enumeration e = this.genericExts.elements();
            while (e.hasMoreElements()) {
                if (mid) {
                    s = s + ", ";
                } else {
                    mid = true;
                }
                s = s + "[" + (X509Extension)e.nextElement() + "]";
            }
            s = s + "}";
        }
        if (s.length() > 0) {
            return s.substring(2);
        }
        return s;
    }
}

