/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.X509ExtensionSet;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class RevokedCertificate
implements ASN1Object,
Externalizable {
    private BigInteger serialNo;
    private Date revocationDate;
    private X509ExtensionSet extensions = null;
    private ASN1Sequence seq = null;

    public RevokedCertificate() {
    }

    public RevokedCertificate(BigInteger sn, Date rd) {
        this.serialNo = sn;
        this.revocationDate = rd;
    }

    public RevokedCertificate(BigInteger sn, Date rd, X509ExtensionSet exts) {
        this(sn, rd);
        if (exts != null && exts.size() > 0) {
            this.extensions = exts;
        }
    }

    public RevokedCertificate(BigInteger sn, Date rd, Vector exts) {
        this(sn, rd);
        if (exts != null && exts.size() > 0) {
            this.extensions = new X509ExtensionSet(exts);
        }
    }

    public RevokedCertificate(InputStream is) throws IOException {
        this.input(is);
    }

    public BigInteger getSerialNo() {
        return this.serialNo;
    }

    public Date getRevocationDate() {
        return this.revocationDate;
    }

    public void addExtension(X509Extension ext) {
        if (this.extensions == null) {
            this.extensions = new X509ExtensionSet();
        }
        this.extensions.addExtension(ext);
    }

    public X509ExtensionSet getExtensionSet() {
        return this.extensions;
    }

    public Vector getExtensions() {
        return this.extensions != null ? this.extensions.getExtensions() : null;
    }

    public Enumeration extensionTypes() {
        return this.extensions != null ? this.extensions.types() : null;
    }

    public X509Extension getExtension(ASN1ObjectID type) {
        return this.extensions != null ? this.extensions.getExtension(type) : null;
    }

    public String toString() {
        String s = "serialNo = " + this.serialNo + ", revocationDate = " + this.revocationDate;
        if (this.extensions != null && this.extensions.size() > 0) {
            s = s + ", extensions = " + this.extensions;
        }
        return s;
    }

    public void input(InputStream is) throws IOException {
        this.reset();
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        this.serialNo = new ASN1Integer((InputStream)sis).getValue();
        this.revocationDate = new ASN1Date((InputStream)sis).getValue();
        this.extensions = sis.hasMoreData() ? new X509ExtensionSet((InputStream)sis) : null;
        sis.terminate();
    }

    private void reset() {
        this.seq = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.seq == null) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)new ASN1Integer(this.getSerialNo()));
            s.addElement((ASN1Object)new ASN1Date(this.getRevocationDate()));
            if (this.extensions != null && this.extensions.size() > 0) {
                s.addElement((ASN1Object)this.extensions);
            }
            this.seq = s;
        }
        return this.seq;
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    public void writeExternal(ObjectOutput os) throws IOException {
        os.writeObject(Utils.toBytes((Streamable)this));
    }

    public void readExternal(ObjectInput is) throws IOException, ClassNotFoundException {
        byte[] data;
        try {
            data = (byte[])is.readObject();
        }
        catch (ClassCastException ex) {
            throw new InvalidInputException((Exception)ex);
        }
        this.input((InputStream)new UnsyncByteArrayInputStream(data));
    }
}

