/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.analytics.impl;

import android.content.Context;
import android.os.Bundle;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.core.internal.config.ConfigModel;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.notifications.internal.analytics.IAnalyticsTracker;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/onesignal/notifications/internal/analytics/impl/FirebaseAnalyticsTracker;", "Lcom/onesignal/notifications/internal/analytics/IAnalyticsTracker;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "_time", "Lcom/onesignal/core/internal/time/ITime;", "(Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/core/internal/config/ConfigModelStore;Lcom/onesignal/core/internal/time/ITime;)V", "isEnabled", "", "()Z", "lastOpenedTime", "Ljava/util/concurrent/atomic/AtomicLong;", "lastReceivedNotificationCampaign", "", "lastReceivedNotificationId", "lastReceivedTime", "mFirebaseAnalyticsInstance", "", "getFirebaseAnalyticsInstance", "trackInfluenceOpenEvent", "", "trackOpenedEvent", "notificationId", "campaign", "trackReceivedEvent", "Companion", "com.onesignal.notifications"})
public final class FirebaseAnalyticsTracker
implements IAnalyticsTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final ConfigModelStore _configModelStore;
    @NotNull
    private final ITime _time;
    @Nullable
    private AtomicLong lastReceivedTime;
    @Nullable
    private AtomicLong lastOpenedTime;
    @Nullable
    private String lastReceivedNotificationId;
    @Nullable
    private String lastReceivedNotificationCampaign;
    @Nullable
    private Object mFirebaseAnalyticsInstance;
    @Nullable
    private static Class<?> firebaseAnalyticsClass;
    @NotNull
    private static final String EVENT_NOTIFICATION_OPENED = "os_notification_opened";
    @NotNull
    private static final String EVENT_NOTIFICATION_INFLUENCE_OPEN = "os_notification_influence_open";
    @NotNull
    private static final String EVENT_NOTIFICATION_RECEIVED = "os_notification_received";

    public FirebaseAnalyticsTracker(@NotNull IApplicationService _applicationService, @NotNull ConfigModelStore _configModelStore, @NotNull ITime _time) {
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        Intrinsics.checkNotNullParameter((Object)_time, (String)"_time");
        this._applicationService = _applicationService;
        this._configModelStore = _configModelStore;
        this._time = _time;
    }

    private final boolean isEnabled() {
        return ((ConfigModel)this._configModelStore.getModel()).getFirebaseAnalytics();
    }

    @Override
    public void trackInfluenceOpenEvent() {
        if (!this.isEnabled() || this.lastReceivedTime == null || this.lastReceivedNotificationId == null) {
            return;
        }
        long now = this._time.getCurrentTimeMillis();
        AtomicLong atomicLong = this.lastReceivedTime;
        Intrinsics.checkNotNull((Object)atomicLong);
        if (now - atomicLong.get() > 120000L) {
            return;
        }
        if (this.lastOpenedTime != null) {
            AtomicLong atomicLong2 = this.lastOpenedTime;
            Intrinsics.checkNotNull((Object)atomicLong2);
            if (now - atomicLong2.get() < 30000L) {
                return;
            }
        }
        try {
            Object firebaseAnalyticsInstance = this.getFirebaseAnalyticsInstance();
            Method trackMethod = FirebaseAnalyticsTracker.Companion.getTrackMethod(FirebaseAnalyticsTracker.firebaseAnalyticsClass);
            String event = EVENT_NOTIFICATION_INFLUENCE_OPEN;
            Bundle bundle = new Bundle();
            bundle.putString("source", "OneSignal");
            bundle.putString("medium", "notification");
            String string = this.lastReceivedNotificationId;
            Intrinsics.checkNotNull((Object)string);
            bundle.putString("notification_id", string);
            String string2 = this.lastReceivedNotificationCampaign;
            Intrinsics.checkNotNull((Object)string2);
            bundle.putString("campaign", string2);
            Method method = trackMethod;
            Intrinsics.checkNotNull((Object)method);
            Object[] objectArray = new Object[]{event, bundle};
            method.invoke(firebaseAnalyticsInstance, objectArray);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void trackOpenedEvent(@NotNull String notificationId, @NotNull String campaign) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)campaign, (String)"campaign");
        if (!this.isEnabled()) {
            return;
        }
        if (this.lastOpenedTime == null) {
            this.lastOpenedTime = new AtomicLong();
        }
        AtomicLong atomicLong = this.lastOpenedTime;
        Intrinsics.checkNotNull((Object)atomicLong);
        atomicLong.set(this._time.getCurrentTimeMillis());
        try {
            Object firebaseAnalyticsInstance = this.getFirebaseAnalyticsInstance();
            Method trackMethod = FirebaseAnalyticsTracker.Companion.getTrackMethod(FirebaseAnalyticsTracker.firebaseAnalyticsClass);
            Bundle bundle = new Bundle();
            bundle.putString("source", "OneSignal");
            bundle.putString("medium", "notification");
            bundle.putString("notification_id", notificationId);
            bundle.putString("campaign", campaign);
            Method method = trackMethod;
            Intrinsics.checkNotNull((Object)method);
            Object[] objectArray = new Object[]{EVENT_NOTIFICATION_OPENED, bundle};
            method.invoke(firebaseAnalyticsInstance, objectArray);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public void trackReceivedEvent(@NotNull String notificationId, @NotNull String campaign) {
        Intrinsics.checkNotNullParameter((Object)notificationId, (String)"notificationId");
        Intrinsics.checkNotNullParameter((Object)campaign, (String)"campaign");
        if (!this.isEnabled()) {
            return;
        }
        try {
            Object firebaseAnalyticsInstance = this.getFirebaseAnalyticsInstance();
            Method trackMethod = FirebaseAnalyticsTracker.Companion.getTrackMethod(FirebaseAnalyticsTracker.firebaseAnalyticsClass);
            Bundle bundle = new Bundle();
            bundle.putString("source", "OneSignal");
            bundle.putString("medium", "notification");
            bundle.putString("notification_id", notificationId);
            bundle.putString("campaign", campaign);
            Method method = trackMethod;
            Intrinsics.checkNotNull((Object)method);
            Object[] objectArray = new Object[]{EVENT_NOTIFICATION_RECEIVED, bundle};
            method.invoke(firebaseAnalyticsInstance, objectArray);
            if (this.lastReceivedTime == null) {
                this.lastReceivedTime = new AtomicLong();
            }
            AtomicLong atomicLong = this.lastReceivedTime;
            Intrinsics.checkNotNull((Object)atomicLong);
            atomicLong.set(this._time.getCurrentTimeMillis());
            this.lastReceivedNotificationId = notificationId;
            this.lastReceivedNotificationCampaign = campaign;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Object getFirebaseAnalyticsInstance() {
        if (this.mFirebaseAnalyticsInstance == null) {
            Object object;
            Method getInstanceMethod = FirebaseAnalyticsTracker.Companion.getInstanceMethod(FirebaseAnalyticsTracker.firebaseAnalyticsClass);
            FirebaseAnalyticsTracker firebaseAnalyticsTracker = this;
            try {
                FirebaseAnalyticsTracker firebaseAnalyticsTracker2 = firebaseAnalyticsTracker;
                Method method = getInstanceMethod;
                Intrinsics.checkNotNull((Object)method);
                object = new Object[]{this._applicationService.getAppContext()};
                object = method.invoke(null, object);
            }
            catch (Throwable throwable) {
                void e;
                FirebaseAnalyticsTracker firebaseAnalyticsTracker3 = firebaseAnalyticsTracker;
                e.printStackTrace();
                return null;
            }
            firebaseAnalyticsTracker2.mFirebaseAnalyticsInstance = object;
        }
        return this.mFirebaseAnalyticsInstance;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bH\u0002J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\f2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/onesignal/notifications/internal/analytics/impl/FirebaseAnalyticsTracker$Companion;", "", "()V", "EVENT_NOTIFICATION_INFLUENCE_OPEN", "", "EVENT_NOTIFICATION_OPENED", "EVENT_NOTIFICATION_RECEIVED", "firebaseAnalyticsClass", "Ljava/lang/Class;", "canTrack", "", "getInstanceMethod", "Ljava/lang/reflect/Method;", "clazz", "getTrackMethod", "com.onesignal.notifications"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean canTrack() {
            boolean bl;
            try {
                firebaseAnalyticsClass = Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
                bl = true;
            }
            catch (ClassNotFoundException e) {
                bl = false;
            }
            return bl;
        }

        private final Method getTrackMethod(Class<?> clazz) {
            Object object;
            try {
                Class<?> clazz2 = clazz;
                Intrinsics.checkNotNull(clazz2);
                object = new Class[]{String.class, Bundle.class};
                object = clazz2.getMethod("logEvent", (Class<?>)object);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                object = null;
            }
            return object;
        }

        private final Method getInstanceMethod(Class<?> clazz) {
            Object object;
            try {
                Class<?> clazz2 = clazz;
                Intrinsics.checkNotNull(clazz2);
                object = new Class[]{Context.class};
                object = clazz2.getMethod("getInstance", (Class<?>)object);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                object = null;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

