/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.data.impl;

import com.onesignal.core.internal.config.ConfigModel;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.notifications.internal.data.INotificationQueryHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/onesignal/notifications/internal/data/impl/NotificationQueryHelper;", "Lcom/onesignal/notifications/internal/data/INotificationQueryHelper;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "_time", "Lcom/onesignal/core/internal/time/ITime;", "(Lcom/onesignal/core/internal/config/ConfigModelStore;Lcom/onesignal/core/internal/time/ITime;)V", "recentUninteractedWithNotificationsWhere", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "com.onesignal.notifications"})
public final class NotificationQueryHelper
implements INotificationQueryHelper {
    @NotNull
    private final ConfigModelStore _configModelStore;
    @NotNull
    private final ITime _time;

    public NotificationQueryHelper(@NotNull ConfigModelStore _configModelStore, @NotNull ITime _time) {
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        Intrinsics.checkNotNullParameter((Object)_time, (String)"_time");
        this._configModelStore = _configModelStore;
        this._time = _time;
    }

    @Override
    @NotNull
    public StringBuilder recentUninteractedWithNotificationsWhere() {
        long currentTimeSec = this._time.getCurrentTimeMillis() / 1000L;
        long createdAtCutoff = currentTimeSec - 604800L;
        StringBuilder where = new StringBuilder("created_time > " + createdAtCutoff + " AND dismissed = 0 AND opened = 0 AND is_summary = 0");
        boolean useTtl = ((ConfigModel)this._configModelStore.getModel()).getRestoreTTLFilter();
        if (useTtl) {
            String expireTimeWhere = " AND expire_time > " + currentTimeSec;
            where.append(expireTimeWhere);
        }
        return where;
    }
}

