/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.common;

import android.content.Context;
import androidx.work.Configuration;
import androidx.work.WorkManager;
import com.onesignal.debug.internal.logging.Logging;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\t"}, d2={"Lcom/onesignal/notifications/internal/common/OSWorkManagerHelper;", "", "()V", "getInstance", "Landroidx/work/WorkManager;", "context", "Landroid/content/Context;", "initializeWorkManager", "", "com.onesignal.notifications"})
public final class OSWorkManagerHelper {
    @NotNull
    public static final OSWorkManagerHelper INSTANCE = new OSWorkManagerHelper();

    private OSWorkManagerHelper() {
    }

    @NotNull
    public final synchronized WorkManager getInstance(@NotNull Context context) {
        WorkManager workManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            WorkManager workManager2 = WorkManager.getInstance((Context)context);
            Intrinsics.checkNotNullExpressionValue((Object)workManager2, (String)"{\n            WorkManage\u2026stance(context)\n        }");
            workManager = workManager2;
        }
        catch (IllegalStateException e) {
            Logging.error((String)"OSWorkManagerHelper.getInstance failed, attempting to initialize: ", (Throwable)e);
            this.initializeWorkManager(context);
            WorkManager workManager3 = WorkManager.getInstance((Context)context);
            Intrinsics.checkNotNullExpressionValue((Object)workManager3, (String)"{\n            /*\n       \u2026stance(context)\n        }");
            workManager = workManager3;
        }
        return workManager;
    }

    private final void initializeWorkManager(Context context) {
        try {
            Context context2 = context.getApplicationContext();
            Configuration.Provider provider = context2 instanceof Configuration.Provider ? (Configuration.Provider)context2 : null;
            if (provider == null || (provider = provider.getWorkManagerConfiguration()) == null) {
                provider = new Configuration.Builder().build();
            }
            Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"(context.applicationCont\u2026uration.Builder().build()");
            Configuration.Provider configuration = provider;
            WorkManager.initialize((Context)context, (Configuration)configuration);
        }
        catch (IllegalStateException e) {
            Logging.error((String)"OSWorkManagerHelper initializing WorkManager failed: ", (Throwable)e);
        }
    }
}

