/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal.channels.impl;

import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.core.internal.language.ILanguageContext;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.notifications.internal.channels.INotificationChannelManager;
import com.onesignal.notifications.internal.common.NotificationGenerationJob;
import com.onesignal.notifications.internal.common.NotificationHelper;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0003J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/onesignal/notifications/internal/channels/impl/NotificationChannelManager;", "Lcom/onesignal/notifications/internal/channels/INotificationChannelManager;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "_languageContext", "Lcom/onesignal/core/internal/language/ILanguageContext;", "(Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/core/internal/language/ILanguageContext;)V", "hexPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "createChannel", "", "context", "Landroid/content/Context;", "notificationManager", "Landroid/app/NotificationManager;", "payload", "Lorg/json/JSONObject;", "createDefaultChannel", "createNotificationChannel", "notificationJob", "Lcom/onesignal/notifications/internal/common/NotificationGenerationJob;", "createRestoreChannel", "priorityToImportance", "", "priority", "processChannelList", "", "list", "Lorg/json/JSONArray;", "Companion", "notifications_release"})
public final class NotificationChannelManager
implements INotificationChannelManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final ILanguageContext _languageContext;
    private final Pattern hexPattern;
    @NotNull
    private static final String DEFAULT_CHANNEL_ID = "fcm_fallback_notification_channel";
    @NotNull
    private static final String RESTORE_CHANNEL_ID = "restored_OS_notifications";
    @NotNull
    private static final String CHANNEL_PREFIX = "OS_";

    public NotificationChannelManager(@NotNull IApplicationService _applicationService, @NotNull ILanguageContext _languageContext) {
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_languageContext, (String)"_languageContext");
        this._applicationService = _applicationService;
        this._languageContext = _languageContext;
        this.hexPattern = Pattern.compile("^([A-Fa-f0-9]{8})$");
    }

    @Override
    @NotNull
    public String createNotificationChannel(@NotNull NotificationGenerationJob notificationJob) {
        String otherChannel;
        Intrinsics.checkNotNullParameter((Object)notificationJob, (String)"notificationJob");
        if (Build.VERSION.SDK_INT < 26) {
            return DEFAULT_CHANNEL_ID;
        }
        Context context = this._applicationService.getAppContext();
        JSONObject jSONObject = notificationJob.getJsonPayload();
        Intrinsics.checkNotNull((Object)jSONObject);
        JSONObject jsonPayload = jSONObject;
        NotificationManager notificationManager = NotificationHelper.INSTANCE.getNotificationManager(context);
        if (notificationJob.isRestoring()) {
            return this.createRestoreChannel(notificationManager);
        }
        if (jsonPayload.has("oth_chnl") && notificationManager.getNotificationChannel(otherChannel = jsonPayload.optString("oth_chnl")) != null) {
            Intrinsics.checkNotNullExpressionValue((Object)otherChannel, (String)"otherChannel");
            return otherChannel;
        }
        if (!jsonPayload.has("chnl")) {
            return this.createDefaultChannel(notificationManager);
        }
        try {
            return this.createChannel(context, notificationManager, jsonPayload);
        }
        catch (JSONException e) {
            Logging.error((String)"Could not create notification channel due to JSON payload error!", (Throwable)e);
            return DEFAULT_CHANNEL_ID;
        }
    }

    @RequiresApi(api=26)
    private final String createChannel(Context context, NotificationManager notificationManager, JSONObject payload) throws JSONException {
        long[] vibrationPattern;
        String language;
        JSONObject langList;
        JSONObject jSONObject;
        Object objChannelPayload = payload.opt("chnl");
        JSONObject channelPayload = null;
        if (objChannelPayload instanceof String) {
            jSONObject = new JSONObject((String)objChannelPayload);
        } else {
            Intrinsics.checkNotNull((Object)objChannelPayload, (String)"null cannot be cast to non-null type org.json.JSONObject");
            jSONObject = (JSONObject)objChannelPayload;
        }
        channelPayload = jSONObject;
        String channel_id = channelPayload.optString("id", DEFAULT_CHANNEL_ID);
        if (Intrinsics.areEqual((Object)channel_id, (Object)"miscellaneous")) {
            channel_id = DEFAULT_CHANNEL_ID;
        }
        JSONObject payloadWithText = channelPayload;
        if (channelPayload.has("langs") && (langList = channelPayload.getJSONObject("langs")).has(language = this._languageContext.getLanguage())) {
            payloadWithText = langList.optJSONObject(language);
        }
        JSONObject jSONObject2 = payloadWithText;
        Intrinsics.checkNotNull((Object)jSONObject2);
        String channel_name = jSONObject2.optString("nm", "Miscellaneous");
        int importance = this.priorityToImportance(payload.optInt("pri", 6));
        NotificationChannel channel = new NotificationChannel(channel_id, (CharSequence)channel_name, importance);
        channel.setDescription(payloadWithText.optString("dscr", null));
        if (channelPayload.has("grp_id")) {
            String group_id = channelPayload.optString("grp_id");
            String string = payloadWithText.optString("grp_nm");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"payloadWithText.optString(\"grp_nm\")");
            CharSequence group_name = string;
            notificationManager.createNotificationChannelGroup(new NotificationChannelGroup(group_id, group_name));
            channel.setGroup(group_id);
        }
        if (payload.has("ledc")) {
            String ledc = payload.optString("ledc");
            Matcher matcher = this.hexPattern.matcher(ledc);
            BigInteger ledColor = null;
            if (!matcher.matches()) {
                Logging.warn$default((String)"OneSignal LED Color Settings: ARGB Hex value incorrect format (E.g: FF9900FF)", null, (int)2, null);
                ledc = "FFFFFFFF";
            }
            try {
                ledColor = new BigInteger(ledc, 16);
                channel.setLightColor(ledColor.intValue());
            }
            catch (Throwable t) {
                Logging.error((String)"Couldn't convert ARGB Hex value to BigInteger:", (Throwable)t);
            }
        }
        channel.enableLights(payload.optInt("led", 1) == 1);
        if (payload.has("vib_pt") && (vibrationPattern = NotificationHelper.INSTANCE.parseVibrationPattern(payload)) != null) {
            channel.setVibrationPattern(vibrationPattern);
        }
        channel.enableVibration(payload.optInt("vib", 1) == 1);
        if (payload.has("sound")) {
            String sound = payload.optString("sound", null);
            Uri uri = NotificationHelper.INSTANCE.getSoundUri(context, sound);
            if (uri != null) {
                channel.setSound(uri, null);
            } else if (Intrinsics.areEqual((Object)"null", (Object)sound) || Intrinsics.areEqual((Object)"nil", (Object)sound)) {
                channel.setSound(null, null);
            }
        }
        channel.setLockscreenVisibility(payload.optInt("vis", 0));
        channel.setShowBadge(payload.optInt("bdg", 1) == 1);
        channel.setBypassDnd(payload.optInt("bdnd", 0) == 1);
        Logging.verbose$default((String)("Creating notification channel with channel:\n" + channel), null, (int)2, null);
        try {
            notificationManager.createNotificationChannel(channel);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        String string = channel_id;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"channel_id");
        return string;
    }

    @RequiresApi(api=26)
    private final String createDefaultChannel(NotificationManager notificationManager) {
        NotificationChannel channel = new NotificationChannel(DEFAULT_CHANNEL_ID, (CharSequence)"Miscellaneous", 3);
        channel.enableLights(true);
        channel.enableVibration(true);
        notificationManager.createNotificationChannel(channel);
        return DEFAULT_CHANNEL_ID;
    }

    @RequiresApi(api=26)
    private final String createRestoreChannel(NotificationManager notificationManager) {
        NotificationChannel channel = new NotificationChannel(RESTORE_CHANNEL_ID, (CharSequence)"Restored", 2);
        notificationManager.createNotificationChannel(channel);
        return RESTORE_CHANNEL_ID;
    }

    @Override
    public void processChannelList(@Nullable JSONArray list) {
        if (Build.VERSION.SDK_INT < 26) {
            return;
        }
        if (list == null || list.length() == 0) {
            return;
        }
        NotificationManager notificationManager = NotificationHelper.INSTANCE.getNotificationManager(this._applicationService.getAppContext());
        Set syncedChannelSet = new HashSet();
        int jsonArraySize = list.length();
        for (int i = 0; i < jsonArraySize; ++i) {
            try {
                Context context = this._applicationService.getAppContext();
                JSONObject jSONObject = list.getJSONObject(i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"list.getJSONObject(i)");
                syncedChannelSet.add(this.createChannel(context, notificationManager, jSONObject));
                continue;
            }
            catch (JSONException e) {
                Logging.error((String)"Could not create notification channel due to JSON payload error!", (Throwable)e);
            }
        }
        if (syncedChannelSet.isEmpty()) {
            return;
        }
        List existingChannels = new ArrayList();
        try {
            List list2 = notificationManager.getNotificationChannels();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"notificationManager.notificationChannels");
            existingChannels = list2;
        }
        catch (NullPointerException e) {
            Logging.error$default((String)("Error when trying to delete notification channel: " + e.getMessage()), null, (int)2, null);
        }
        for (NotificationChannel existingChannel : existingChannels) {
            String id = existingChannel.getId();
            Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
            if (!StringsKt.startsWith$default((String)id, (String)CHANNEL_PREFIX, (boolean)false, (int)2, null) || syncedChannelSet.contains(id)) continue;
            notificationManager.deleteNotificationChannel(id);
        }
    }

    private final int priorityToImportance(int priority) {
        if (priority > 9) {
            return 5;
        }
        if (priority > 7) {
            return 4;
        }
        if (priority > 5) {
            return 3;
        }
        if (priority > 3) {
            return 2;
        }
        return priority > 1 ? 1 : 0;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/onesignal/notifications/internal/channels/impl/NotificationChannelManager$Companion;", "", "()V", "CHANNEL_PREFIX", "", "DEFAULT_CHANNEL_ID", "RESTORE_CHANNEL_ID", "notifications_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

