/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.receivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.onesignal.OneSignal;
import com.onesignal.notifications.internal.bundle.INotificationBundleProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0004H\u0002J\b\u0010\n\u001a\u00020\u0004H\u0002\u00a8\u0006\f"}, d2={"Lcom/onesignal/notifications/receivers/FCMBroadcastReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "setAbort", "setSuccessfulResultCode", "Companion", "notifications_release"})
public final class FCMBroadcastReceiver
extends BroadcastReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String FCM_RECEIVE_ACTION = "com.google.android.c2dm.intent.RECEIVE";
    @NotNull
    private static final String FCM_TYPE = "gcm";
    @NotNull
    private static final String MESSAGE_TYPE_EXTRA_KEY = "message_type";

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        INotificationBundleProcessor.ProcessedBundleResult processedResult;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Bundle bundle = intent.getExtras();
        if (bundle == null || Intrinsics.areEqual((Object)"google.com/iid", (Object)bundle.getString("from"))) {
            return;
        }
        OneSignal.initWithContext((Context)context);
        OneSignal this_$iv = OneSignal.INSTANCE;
        boolean $i$f$getService = false;
        INotificationBundleProcessor bundleProcessor = (INotificationBundleProcessor)this_$iv.getServices().getService(INotificationBundleProcessor.class);
        if (!FCMBroadcastReceiver.Companion.isFCMMessage(intent)) {
            this.setSuccessfulResultCode();
            return;
        }
        INotificationBundleProcessor.ProcessedBundleResult processedBundleResult = processedResult = bundleProcessor.processBundleFromReceiver(context, bundle);
        Intrinsics.checkNotNull((Object)processedBundleResult);
        if (processedBundleResult.isWorkManagerProcessing()) {
            this.setAbort();
            return;
        }
        this.setSuccessfulResultCode();
    }

    private final void setSuccessfulResultCode() {
        if (this.isOrderedBroadcast()) {
            this.setResultCode(-1);
        }
    }

    private final void setAbort() {
        if (this.isOrderedBroadcast()) {
            this.abortBroadcast();
            this.setResultCode(-1);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/onesignal/notifications/receivers/FCMBroadcastReceiver$Companion;", "", "()V", "FCM_RECEIVE_ACTION", "", "FCM_TYPE", "MESSAGE_TYPE_EXTRA_KEY", "isFCMMessage", "", "intent", "Landroid/content/Intent;", "notifications_release"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isFCMMessage(Intent intent) {
            if (Intrinsics.areEqual((Object)FCMBroadcastReceiver.FCM_RECEIVE_ACTION, (Object)intent.getAction())) {
                String messageType = intent.getStringExtra(FCMBroadcastReceiver.MESSAGE_TYPE_EXTRA_KEY);
                return messageType == null || Intrinsics.areEqual((Object)FCMBroadcastReceiver.FCM_TYPE, (Object)messageType);
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

