/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.notifications.internal;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.onesignal.common.events.EventProducer;
import com.onesignal.common.threading.ThreadUtilsKt;
import com.onesignal.core.internal.application.IApplicationLifecycleHandler;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.notifications.INotificationClickHandler;
import com.onesignal.notifications.INotificationWillShowInForegroundHandler;
import com.onesignal.notifications.INotificationsManager;
import com.onesignal.notifications.IPermissionChangedHandler;
import com.onesignal.notifications.internal.INotificationActivityOpener;
import com.onesignal.notifications.internal.NotificationsManager;
import com.onesignal.notifications.internal.common.GenerateNotificationOpenIntent;
import com.onesignal.notifications.internal.common.GenerateNotificationOpenIntentFromPushPayload;
import com.onesignal.notifications.internal.common.NotificationHelper;
import com.onesignal.notifications.internal.data.INotificationRepository;
import com.onesignal.notifications.internal.lifecycle.INotificationLifecycleService;
import com.onesignal.notifications.internal.permissions.INotificationPermissionChangedHandler;
import com.onesignal.notifications.internal.permissions.INotificationPermissionController;
import com.onesignal.notifications.internal.restoration.INotificationRestoreWorkManager;
import com.onesignal.notifications.internal.summary.INotificationSummaryManager;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B5\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0011\u0010\u001e\u001a\u00020\u001cH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u001cH\u0016J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u0016H\u0016J\b\u0010#\u001a\u00020\u001cH\u0016J!\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020\u001cH\u0002J\u0019\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J\u0019\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u000201H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0019\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u0016H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106J\u0012\u00107\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u000108H\u0016J\u0012\u00109\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010:H\u0016J\u0010\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006="}, d2={"Lcom/onesignal/notifications/internal/NotificationsManager;", "Lcom/onesignal/notifications/INotificationsManager;", "Lcom/onesignal/notifications/internal/INotificationActivityOpener;", "Lcom/onesignal/notifications/internal/permissions/INotificationPermissionChangedHandler;", "Lcom/onesignal/core/internal/application/IApplicationLifecycleHandler;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "_notificationPermissionController", "Lcom/onesignal/notifications/internal/permissions/INotificationPermissionController;", "_notificationRestoreWorkManager", "Lcom/onesignal/notifications/internal/restoration/INotificationRestoreWorkManager;", "_notificationLifecycleService", "Lcom/onesignal/notifications/internal/lifecycle/INotificationLifecycleService;", "_notificationDataController", "Lcom/onesignal/notifications/internal/data/INotificationRepository;", "_summaryManager", "Lcom/onesignal/notifications/internal/summary/INotificationSummaryManager;", "(Lcom/onesignal/core/internal/application/IApplicationService;Lcom/onesignal/notifications/internal/permissions/INotificationPermissionController;Lcom/onesignal/notifications/internal/restoration/INotificationRestoreWorkManager;Lcom/onesignal/notifications/internal/lifecycle/INotificationLifecycleService;Lcom/onesignal/notifications/internal/data/INotificationRepository;Lcom/onesignal/notifications/internal/summary/INotificationSummaryManager;)V", "_permissionChangedNotifier", "Lcom/onesignal/common/events/EventProducer;", "Lcom/onesignal/notifications/IPermissionChangedHandler;", "permission", "", "getPermission", "()Z", "setPermission", "(Z)V", "addPermissionChangedHandler", "", "handler", "clearAllNotifications", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onFocus", "onNotificationPermissionChanged", "enabled", "onUnfocused", "openDestinationActivity", "activity", "Landroid/app/Activity;", "pushPayloads", "Lorg/json/JSONArray;", "(Landroid/app/Activity;Lorg/json/JSONArray;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "refreshNotificationState", "removeGroupedNotifications", "group", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeNotification", "id", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removePermissionChangedHandler", "requestPermission", "fallbackToSettings", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setNotificationClickHandler", "Lcom/onesignal/notifications/INotificationClickHandler;", "setNotificationWillShowInForegroundHandler", "Lcom/onesignal/notifications/INotificationWillShowInForegroundHandler;", "setPermissionStatusAndFire", "isEnabled", "notifications_release"})
public final class NotificationsManager
implements INotificationsManager,
INotificationActivityOpener,
INotificationPermissionChangedHandler,
IApplicationLifecycleHandler {
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final INotificationPermissionController _notificationPermissionController;
    @NotNull
    private final INotificationRestoreWorkManager _notificationRestoreWorkManager;
    @NotNull
    private final INotificationLifecycleService _notificationLifecycleService;
    @NotNull
    private final INotificationRepository _notificationDataController;
    @NotNull
    private final INotificationSummaryManager _summaryManager;
    private boolean permission;
    @NotNull
    private final EventProducer<IPermissionChangedHandler> _permissionChangedNotifier;

    public NotificationsManager(@NotNull IApplicationService _applicationService, @NotNull INotificationPermissionController _notificationPermissionController, @NotNull INotificationRestoreWorkManager _notificationRestoreWorkManager, @NotNull INotificationLifecycleService _notificationLifecycleService, @NotNull INotificationRepository _notificationDataController, @NotNull INotificationSummaryManager _summaryManager) {
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        Intrinsics.checkNotNullParameter((Object)_notificationPermissionController, (String)"_notificationPermissionController");
        Intrinsics.checkNotNullParameter((Object)_notificationRestoreWorkManager, (String)"_notificationRestoreWorkManager");
        Intrinsics.checkNotNullParameter((Object)_notificationLifecycleService, (String)"_notificationLifecycleService");
        Intrinsics.checkNotNullParameter((Object)_notificationDataController, (String)"_notificationDataController");
        Intrinsics.checkNotNullParameter((Object)_summaryManager, (String)"_summaryManager");
        this._applicationService = _applicationService;
        this._notificationPermissionController = _notificationPermissionController;
        this._notificationRestoreWorkManager = _notificationRestoreWorkManager;
        this._notificationLifecycleService = _notificationLifecycleService;
        this._notificationDataController = _notificationDataController;
        this._summaryManager = _summaryManager;
        this.permission = NotificationHelper.areNotificationsEnabled$default(NotificationHelper.INSTANCE, this._applicationService.getAppContext(), null, 2, null);
        this._permissionChangedNotifier = new EventProducer();
        this._applicationService.addApplicationLifecycleHandler((IApplicationLifecycleHandler)this);
        this._notificationPermissionController.subscribe(this);
        ThreadUtilsKt.suspendifyOnThread$default((int)0, (Function1)((Function1)new Function1<Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ NotificationsManager this$0;
            {
                this.this$0 = $receiver;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0._notificationDataController.deleteExpiredNotifications((Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public boolean getPermission() {
        return this.permission;
    }

    public void setPermission(boolean bl) {
        this.permission = bl;
    }

    public void onFocus() {
        this.refreshNotificationState();
    }

    public void onUnfocused() {
    }

    @Override
    public void onNotificationPermissionChanged(boolean enabled) {
        this.setPermissionStatusAndFire(enabled);
    }

    private final void refreshNotificationState() {
        this._notificationRestoreWorkManager.beginEnqueueingWork(this._applicationService.getAppContext(), false);
        boolean isEnabled = NotificationHelper.areNotificationsEnabled$default(NotificationHelper.INSTANCE, this._applicationService.getAppContext(), null, 2, null);
        this.setPermissionStatusAndFire(isEnabled);
    }

    @Nullable
    public Object requestPermission(boolean fallbackToSettings, @NotNull Continuation<? super Boolean> $completion) {
        Logging.debug$default((String)"NotificationsManager.requestPermission()", null, (int)2, null);
        return this._notificationPermissionController.prompt(fallbackToSettings, $completion);
    }

    private final void setPermissionStatusAndFire(boolean isEnabled) {
        boolean oldPermissionStatus = this.getPermission();
        this.setPermission(isEnabled);
        if (oldPermissionStatus != isEnabled) {
            this._permissionChangedNotifier.fireOnMain((Function1)new Function1<IPermissionChangedHandler, Unit>(isEnabled){
                final /* synthetic */ boolean $isEnabled;
                {
                    this.$isEnabled = $isEnabled;
                    super(1);
                }

                public final void invoke(@NotNull IPermissionChangedHandler it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.onPermissionChanged(this.$isEnabled);
                }
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object removeNotification(int var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof removeNotification.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ NotificationsManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.removeNotification(0, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Logging.debug$default((String)("NotificationsManager.removeNotification(id: " + id + ')'), null, (int)2, null);
                $continuation.L$0 = this;
                $continuation.I$0 = id;
                $continuation.label = 1;
                v0 = this._notificationDataController.markAsDismissed(id, (Continuation<? super Boolean>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                id = $continuation.I$0;
                this = (NotificationsManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) break;
                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = this._summaryManager.updatePossibleDependentSummaryOnDismiss(id, (Continuation<? super Unit>)$continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl35
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object removeGroupedNotifications(@NotNull String group, @NotNull Continuation<? super Unit> $completion) {
        Logging.debug$default((String)("NotificationsManager.removeGroupedNotifications(group: " + group + ')'), null, (int)2, null);
        Object object = this._notificationDataController.markAsDismissedForGroup(group, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object clearAllNotifications(@NotNull Continuation<? super Unit> $completion) {
        Logging.debug$default((String)"NotificationsManager.clearAll()", null, (int)2, null);
        Object object = this._notificationDataController.markAsDismissedForOutstanding($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public void addPermissionChangedHandler(@NotNull IPermissionChangedHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Logging.debug$default((String)("NotificationsManager.addPushPermissionHandler(handler: " + handler + ')'), null, (int)2, null);
        this._permissionChangedNotifier.subscribe((Object)handler);
    }

    public void removePermissionChangedHandler(@NotNull IPermissionChangedHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Logging.debug$default((String)("NotificationsManager.removePushPermissionHandler(handler: " + handler + ')'), null, (int)2, null);
        this._permissionChangedNotifier.unsubscribe((Object)handler);
    }

    public void setNotificationWillShowInForegroundHandler(@Nullable INotificationWillShowInForegroundHandler handler) {
        Logging.debug$default((String)("NotificationsManager.setNotificationWillShowInForegroundHandler(handler: " + handler + ')'), null, (int)2, null);
        this._notificationLifecycleService.setExternalWillShowInForegroundHandler(handler);
    }

    public void setNotificationClickHandler(@Nullable INotificationClickHandler handler) {
        Logging.debug$default((String)("NotificationsManager.setNotificationOpenedHandler(handler: " + handler + ')'), null, (int)2, null);
        this._notificationLifecycleService.setExternalNotificationOpenedHandler(handler);
    }

    @Override
    @Nullable
    public Object openDestinationActivity(@NotNull Activity activity, @NotNull JSONArray pushPayloads, @NotNull Continuation<? super Unit> $completion) {
        try {
            JSONObject firstPayloadItem = pushPayloads.getJSONObject(0);
            Context context = (Context)activity;
            Intrinsics.checkNotNullExpressionValue((Object)firstPayloadItem, (String)"firstPayloadItem");
            GenerateNotificationOpenIntent intentGenerator = GenerateNotificationOpenIntentFromPushPayload.INSTANCE.create(context, firstPayloadItem);
            Intent intent = intentGenerator.getIntentVisible();
            if (intent != null) {
                Logging.info$default((String)("SDK running startActivity with Intent: " + intent), null, (int)2, null);
                activity.startActivity(intent);
            } else {
                Logging.info$default((String)"SDK not showing an Activity automatically due to it's settings.", null, (int)2, null);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return Unit.INSTANCE;
    }
}

