/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.location.internal.permissions;

import android.app.Activity;
import android.content.Context;
import com.onesignal.common.AndroidUtils;
import com.onesignal.common.events.EventProducer;
import com.onesignal.common.events.IEventNotifier;
import com.onesignal.common.threading.WaiterWithValue;
import com.onesignal.core.internal.application.ApplicationLifecycleHandlerBase;
import com.onesignal.core.internal.application.IApplicationLifecycleHandler;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.core.internal.permissions.AlertDialogPrepromptForAndroidSettings;
import com.onesignal.core.internal.permissions.IRequestPermissionService;
import com.onesignal.core.internal.startup.IStartableService;
import com.onesignal.location.R;
import com.onesignal.location.internal.permissions.ILocationPermissionChangedHandler;
import com.onesignal.location.internal.permissions.LocationPermissionController;
import com.onesignal.location.internal.permissions.NavigateToAndroidSettingsForLocation;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u0000  2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003:\u0001 B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J!\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u000fH\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0004H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lcom/onesignal/location/internal/permissions/LocationPermissionController;", "Lcom/onesignal/core/internal/permissions/IRequestPermissionService$PermissionCallback;", "Lcom/onesignal/core/internal/startup/IStartableService;", "Lcom/onesignal/common/events/IEventNotifier;", "Lcom/onesignal/location/internal/permissions/ILocationPermissionChangedHandler;", "_requestPermission", "Lcom/onesignal/core/internal/permissions/IRequestPermissionService;", "_applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "(Lcom/onesignal/core/internal/permissions/IRequestPermissionService;Lcom/onesignal/core/internal/application/IApplicationService;)V", "currPermission", "", "events", "Lcom/onesignal/common/events/EventProducer;", "hasSubscribers", "", "getHasSubscribers", "()Z", "waiter", "Lcom/onesignal/common/threading/WaiterWithValue;", "onAccept", "", "onReject", "fallbackToSettings", "prompt", "androidPermissionString", "(ZLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "showFallbackAlertDialog", "start", "subscribe", "handler", "unsubscribe", "Companion", "com.onesignal.location"})
public final class LocationPermissionController
implements IRequestPermissionService.PermissionCallback,
IStartableService,
IEventNotifier<ILocationPermissionChangedHandler> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IRequestPermissionService _requestPermission;
    @NotNull
    private final IApplicationService _applicationService;
    @NotNull
    private final WaiterWithValue<Boolean> waiter;
    @NotNull
    private final EventProducer<ILocationPermissionChangedHandler> events;
    @NotNull
    private String currPermission;
    @NotNull
    private static final String PERMISSION_TYPE = "LOCATION";

    public LocationPermissionController(@NotNull IRequestPermissionService _requestPermission, @NotNull IApplicationService _applicationService) {
        Intrinsics.checkNotNullParameter((Object)_requestPermission, (String)"_requestPermission");
        Intrinsics.checkNotNullParameter((Object)_applicationService, (String)"_applicationService");
        this._requestPermission = _requestPermission;
        this._applicationService = _applicationService;
        this.waiter = new WaiterWithValue();
        this.events = new EventProducer();
        this.currPermission = "";
    }

    public void start() {
        this._requestPermission.registerAsCallback(PERMISSION_TYPE, (IRequestPermissionService.PermissionCallback)this);
    }

    @Nullable
    public final Object prompt(boolean fallbackToSettings, @NotNull String androidPermissionString, @NotNull Continuation<? super Boolean> $completion) {
        this.currPermission = androidPermissionString;
        this._requestPermission.startPrompt(fallbackToSettings, PERMISSION_TYPE, androidPermissionString, this.getClass());
        return this.waiter.waitForWake($completion);
    }

    public void onAccept() {
        this.waiter.wake((Object)true);
        this.events.fire((Function1)onAccept.1.INSTANCE);
    }

    public void onReject(boolean fallbackToSettings) {
        boolean fallbackShown;
        boolean bl = fallbackShown = fallbackToSettings ? this.showFallbackAlertDialog() : false;
        if (!fallbackShown) {
            this.waiter.wake((Object)false);
            this.events.fire((Function1)onReject.1.INSTANCE);
        }
    }

    private final boolean showFallbackAlertDialog() {
        Activity activity = this._applicationService.getCurrent();
        if (activity == null) {
            return false;
        }
        Activity activity2 = activity;
        String string2 = activity2.getString(R.string.location_permission_name_for_title);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"activity.getString(R.str\u2026ermission_name_for_title)");
        String string3 = activity2.getString(R.string.location_permission_settings_message);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"activity.getString(R.str\u2026mission_settings_message)");
        AlertDialogPrepromptForAndroidSettings.INSTANCE.show(activity2, string2, string3, new AlertDialogPrepromptForAndroidSettings.Callback(this, activity2){
            final /* synthetic */ LocationPermissionController this$0;
            final /* synthetic */ Activity $activity;
            {
                this.this$0 = $receiver;
                this.$activity = $activity;
            }

            public void onAccept() {
                LocationPermissionController.access$get_applicationService$p(this.this$0).addApplicationLifecycleHandler((IApplicationLifecycleHandler)new ApplicationLifecycleHandlerBase(this.this$0){
                    final /* synthetic */ LocationPermissionController this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void onFocus(boolean firedOnSubscribe) {
                        if (firedOnSubscribe) {
                            return;
                        }
                        super.onFocus(false);
                        LocationPermissionController.access$get_applicationService$p(this.this$0).removeApplicationLifecycleHandler((IApplicationLifecycleHandler)this);
                        boolean hasPermission = AndroidUtils.INSTANCE.hasPermission(LocationPermissionController.access$getCurrPermission$p(this.this$0), true, LocationPermissionController.access$get_applicationService$p(this.this$0));
                        LocationPermissionController.access$getWaiter$p(this.this$0).wake((Object)hasPermission);
                        LocationPermissionController.access$getEvents$p(this.this$0).fire((Function1)new Function1<ILocationPermissionChangedHandler, Unit>(hasPermission){
                            final /* synthetic */ boolean $hasPermission;
                            {
                                this.$hasPermission = $hasPermission;
                                super(1);
                            }

                            public final void invoke(@NotNull ILocationPermissionChangedHandler it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                it.onLocationPermissionChanged(this.$hasPermission);
                            }
                        });
                    }
                });
                NavigateToAndroidSettingsForLocation.INSTANCE.show((Context)this.$activity);
            }

            public void onDecline() {
                LocationPermissionController.access$getWaiter$p(this.this$0).wake((Object)false);
                LocationPermissionController.access$getEvents$p(this.this$0).fire((Function1)showFallbackAlertDialog.onDecline.1.INSTANCE);
            }
        });
        return true;
    }

    public void subscribe(@NotNull ILocationPermissionChangedHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.events.subscribe((Object)handler);
    }

    public void unsubscribe(@NotNull ILocationPermissionChangedHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.events.subscribe((Object)handler);
    }

    public boolean getHasSubscribers() {
        return this.events.getHasSubscribers();
    }

    public static final /* synthetic */ IApplicationService access$get_applicationService$p(LocationPermissionController $this) {
        return $this._applicationService;
    }

    public static final /* synthetic */ String access$getCurrPermission$p(LocationPermissionController $this) {
        return $this.currPermission;
    }

    public static final /* synthetic */ WaiterWithValue access$getWaiter$p(LocationPermissionController $this) {
        return $this.waiter;
    }

    public static final /* synthetic */ EventProducer access$getEvents$p(LocationPermissionController $this) {
        return $this.events;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/onesignal/location/internal/permissions/LocationPermissionController$Companion;", "", "()V", "PERMISSION_TYPE", "", "com.onesignal.location"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

