/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.inAppMessages.internal.triggers.impl;

import com.onesignal.common.events.EventProducer;
import com.onesignal.common.events.IEventNotifier;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.inAppMessages.internal.Trigger;
import com.onesignal.inAppMessages.internal.state.InAppStateService;
import com.onesignal.inAppMessages.internal.triggers.ITriggerHandler;
import com.onesignal.inAppMessages.internal.triggers.impl.DynamicTriggerTimer;
import com.onesignal.session.internal.session.ISessionService;
import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002H\u0016J\u0010\u0010$\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/onesignal/inAppMessages/internal/triggers/impl/DynamicTriggerController;", "Lcom/onesignal/common/events/IEventNotifier;", "Lcom/onesignal/inAppMessages/internal/triggers/ITriggerHandler;", "_state", "Lcom/onesignal/inAppMessages/internal/state/InAppStateService;", "_session", "Lcom/onesignal/session/internal/session/ISessionService;", "_time", "Lcom/onesignal/core/internal/time/ITime;", "(Lcom/onesignal/inAppMessages/internal/state/InAppStateService;Lcom/onesignal/session/internal/session/ISessionService;Lcom/onesignal/core/internal/time/ITime;)V", "events", "Lcom/onesignal/common/events/EventProducer;", "getEvents", "()Lcom/onesignal/common/events/EventProducer;", "hasSubscribers", "", "getHasSubscribers", "()Z", "scheduledMessages", "", "", "dynamicTriggerShouldFire", "trigger", "Lcom/onesignal/inAppMessages/internal/Trigger;", "evaluateTimeIntervalWithOperator", "timeInterval", "", "currentTimeInterval", "operator", "Lcom/onesignal/inAppMessages/internal/Trigger$OSTriggerOperator;", "roughlyEqual", "left", "right", "subscribe", "", "handler", "unsubscribe", "Companion", "com.onesignal.inAppMessages"})
public final class DynamicTriggerController
implements IEventNotifier<ITriggerHandler> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InAppStateService _state;
    @NotNull
    private final ISessionService _session;
    @NotNull
    private final ITime _time;
    @NotNull
    private final EventProducer<ITriggerHandler> events;
    @NotNull
    private final List<String> scheduledMessages;
    private static final double REQUIRED_ACCURACY = 0.3;
    private static final long DEFAULT_LAST_IN_APP_TIME_AGO = 999999L;

    public DynamicTriggerController(@NotNull InAppStateService _state, @NotNull ISessionService _session, @NotNull ITime _time) {
        Intrinsics.checkNotNullParameter((Object)_state, (String)"_state");
        Intrinsics.checkNotNullParameter((Object)_session, (String)"_session");
        Intrinsics.checkNotNullParameter((Object)_time, (String)"_time");
        this._state = _state;
        this._session = _session;
        this._time = _time;
        this.events = new EventProducer();
        this.scheduledMessages = new ArrayList();
    }

    @NotNull
    public final EventProducer<ITriggerHandler> getEvents() {
        return this.events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean dynamicTriggerShouldFire(@NotNull Trigger trigger) {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        if (trigger.getValue() == null) {
            return false;
        }
        List<String> list = this.scheduledMessages;
        synchronized (list) {
            boolean bl = false;
            if (!(trigger.getValue() instanceof Number)) {
                return false;
            }
            long currentTimeInterval = 0L;
            switch (WhenMappings.$EnumSwitchMapping$0[trigger.getKind().ordinal()]) {
                case 1: {
                    currentTimeInterval = this._time.getCurrentTimeMillis() - this._session.getStartTime();
                    break;
                }
                case 2: {
                    if (this._state.getInAppMessageIdShowing() != null) {
                        return false;
                    }
                    Long lastTimeAppDismissed = this._state.getLastTimeInAppDismissed();
                    currentTimeInterval = lastTimeAppDismissed == null ? 999999L : this._time.getCurrentTimeMillis() - lastTimeAppDismissed;
                    break;
                }
            }
            String triggerId = trigger.getTriggerId();
            Number number = (Number)trigger.getValue();
            Intrinsics.checkNotNull((Object)number);
            long requiredTimeInterval = (long)(number.doubleValue() * (double)1000);
            if (this.evaluateTimeIntervalWithOperator(requiredTimeInterval, currentTimeInterval, trigger.getOperatorType())) {
                this.events.fire((Function1)new Function1<ITriggerHandler, Unit>(triggerId){
                    final /* synthetic */ String $triggerId;
                    {
                        this.$triggerId = $triggerId;
                        super(1);
                    }

                    public final void invoke(@NotNull ITriggerHandler it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        it.onTriggerCompleted(this.$triggerId);
                    }
                });
                return true;
            }
            long offset = requiredTimeInterval - currentTimeInterval;
            if (offset <= 0L) {
                return false;
            }
            if (this.scheduledMessages.contains(triggerId)) {
                return false;
            }
            DynamicTriggerTimer.INSTANCE.scheduleTrigger(new TimerTask(this, triggerId){
                final /* synthetic */ DynamicTriggerController this$0;
                final /* synthetic */ String $triggerId;
                {
                    this.this$0 = $receiver;
                    this.$triggerId = $triggerId;
                }

                public void run() {
                    DynamicTriggerController.access$getScheduledMessages$p(this.this$0).remove(this.$triggerId);
                    this.this$0.getEvents().fire((Function1)new Function1<ITriggerHandler, Unit>(this.$triggerId){
                        final /* synthetic */ String $triggerId;
                        {
                            this.$triggerId = $triggerId;
                            super(1);
                        }

                        public final void invoke(@NotNull ITriggerHandler it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            it.onTriggerConditionChanged(this.$triggerId);
                        }
                    });
                }
            }, triggerId, offset);
            boolean bl2 = this.scheduledMessages.add(triggerId);
            return false;
        }
    }

    private final boolean evaluateTimeIntervalWithOperator(double timeInterval, double currentTimeInterval, Trigger.OSTriggerOperator operator) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$1[operator.ordinal()]) {
            case 1: {
                if (currentTimeInterval < timeInterval) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (currentTimeInterval <= timeInterval || this.roughlyEqual(timeInterval, currentTimeInterval)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                if (currentTimeInterval >= timeInterval) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                if (currentTimeInterval >= timeInterval || this.roughlyEqual(timeInterval, currentTimeInterval)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 5: {
                bl = this.roughlyEqual(timeInterval, currentTimeInterval);
                break;
            }
            case 6: {
                if (!this.roughlyEqual(timeInterval, currentTimeInterval)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                Logging.error$default((String)("Attempted to apply an invalid operator on a time-based in-app-message trigger: " + (Object)((Object)operator)), null, (int)2, null);
                bl = false;
            }
        }
        return bl;
    }

    private final boolean roughlyEqual(double left, double right) {
        return Math.abs(left - right) < 0.3;
    }

    public void subscribe(@NotNull ITriggerHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.events.subscribe((Object)handler);
    }

    public void unsubscribe(@NotNull ITriggerHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.events.unsubscribe((Object)handler);
    }

    public boolean getHasSubscribers() {
        return this.events.getHasSubscribers();
    }

    public static final /* synthetic */ List access$getScheduledMessages$p(DynamicTriggerController $this) {
        return $this.scheduledMessages;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/onesignal/inAppMessages/internal/triggers/impl/DynamicTriggerController$Companion;", "", "()V", "DEFAULT_LAST_IN_APP_TIME_AGO", "", "REQUIRED_ACCURACY", "", "com.onesignal.inAppMessages"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Trigger.OSTriggerKind.values().length];
            try {
                nArray[Trigger.OSTriggerKind.SESSION_TIME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Trigger.OSTriggerKind.TIME_SINCE_LAST_IN_APP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Trigger.OSTriggerOperator.values().length];
            try {
                nArray[Trigger.OSTriggerOperator.LESS_THAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Trigger.OSTriggerOperator.LESS_THAN_OR_EQUAL_TO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Trigger.OSTriggerOperator.GREATER_THAN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Trigger.OSTriggerOperator.GREATER_THAN_OR_EQUAL_TO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Trigger.OSTriggerOperator.EQUAL_TO.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Trigger.OSTriggerOperator.NOT_EQUAL_TO.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

