/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.inAppMessages.internal.hydrators;

import com.onesignal.common.modeling.MapModel;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.inAppMessages.internal.InAppMessage;
import com.onesignal.inAppMessages.internal.InAppMessageContent;
import com.onesignal.user.internal.properties.PropertiesModel;
import com.onesignal.user.internal.properties.PropertiesModelStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/onesignal/inAppMessages/internal/hydrators/InAppHydrator;", "", "_time", "Lcom/onesignal/core/internal/time/ITime;", "_propertiesModelStore", "Lcom/onesignal/user/internal/properties/PropertiesModelStore;", "(Lcom/onesignal/core/internal/time/ITime;Lcom/onesignal/user/internal/properties/PropertiesModelStore;)V", "hydrateIAMMessageContent", "Lcom/onesignal/inAppMessages/internal/InAppMessageContent;", "jsonObject", "Lorg/json/JSONObject;", "hydrateIAMMessages", "", "Lcom/onesignal/inAppMessages/internal/InAppMessage;", "jsonArray", "Lorg/json/JSONArray;", "taggedHTMLString", "", "untaggedString", "Companion", "com.onesignal.inAppMessages"})
public final class InAppHydrator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ITime _time;
    @NotNull
    private final PropertiesModelStore _propertiesModelStore;
    @NotNull
    private static final String LIQUID_TAG_SCRIPT = "\n\n<script>\n    setPlayerTags(%s);\n</script>";

    public InAppHydrator(@NotNull ITime _time, @NotNull PropertiesModelStore _propertiesModelStore) {
        Intrinsics.checkNotNullParameter((Object)_time, (String)"_time");
        Intrinsics.checkNotNullParameter((Object)_propertiesModelStore, (String)"_propertiesModelStore");
        this._time = _time;
        this._propertiesModelStore = _propertiesModelStore;
    }

    @NotNull
    public final List<InAppMessage> hydrateIAMMessages(@NotNull JSONArray jsonArray) {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        ArrayList<InAppMessage> newMessages = new ArrayList<InAppMessage>();
        int n = jsonArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject messageJson;
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray.getJSONObject(i), (String)"getJSONObject(...)");
            InAppMessage message = new InAppMessage(messageJson, this._time);
            if (message.getMessageId() == null) continue;
            newMessages.add(message);
        }
        return newMessages;
    }

    @Nullable
    public final InAppMessageContent hydrateIAMMessageContent(@NotNull JSONObject jsonObject) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        try {
            InAppMessageContent content = new InAppMessageContent(jsonObject);
            if (content.getContentHtml() == null) {
                Logging.debug$default((String)"displayMessage:OnSuccess: No HTML retrieved from loadMessageContent", null, (int)2, null);
                return null;
            }
            String string2 = content.getContentHtml();
            Intrinsics.checkNotNull((Object)string2);
            content.setContentHtml(this.taggedHTMLString(string2));
            return content;
        }
        catch (JSONException e) {
            Logging.error((String)("Error attempting to hydrate InAppMessageContent: " + jsonObject), (Throwable)e);
            return null;
        }
    }

    private final String taggedHTMLString(String untaggedString) {
        String tagsString;
        MapModel mapModel = ((PropertiesModel)this._propertiesModelStore.getModel()).getTags();
        Intrinsics.checkNotNull((Object)mapModel, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
        JSONObject tagsAsJson = new JSONObject((Map)mapModel);
        String string2 = tagsAsJson.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String tagsDict = tagsString = string2;
        String tagScript = LIQUID_TAG_SCRIPT;
        StringBuilder stringBuilder = new StringBuilder().append(untaggedString);
        Object[] objectArray = new Object[]{tagsDict};
        String string3 = String.format(tagScript, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return stringBuilder.append(string3).toString();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/onesignal/inAppMessages/internal/hydrators/InAppHydrator$Companion;", "", "()V", "LIQUID_TAG_SCRIPT", "", "com.onesignal.inAppMessages"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

