/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.inAppMessages.internal;

import com.onesignal.common.DateUtils;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.inAppMessages.IInAppMessage;
import com.onesignal.inAppMessages.internal.InAppMessageRedisplayStats;
import com.onesignal.inAppMessages.internal.Trigger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 N2\u00020\u0001:\u0001NB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B5\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000eB\u0017\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0011B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0012J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\bJ\u0006\u0010:\u001a\u000208J\u0013\u0010;\u001a\u00020\u00032\b\u0010<\u001a\u0004\u0018\u00010=H\u0096\u0002J\b\u0010>\u001a\u00020?H\u0016J\u000e\u0010@\u001a\u00020\u00032\u0006\u00109\u001a\u00020\bJ\u0012\u0010A\u001a\u0004\u0018\u00010 2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J6\u0010B\u001a(\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0C0Cj\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020/0Cj\b\u0012\u0004\u0012\u00020/`D`D2\u0006\u0010E\u001a\u00020FH\u0002JT\u0010G\u001aF\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0H0Hj*\u0012\u0004\u0012\u00020\b\u0012 \u0012\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0Hj\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b`I`I2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010J\u001a\u0002082\u0006\u00109\u001a\u00020\bJ\u0006\u0010K\u001a\u00020\u0003J\u0006\u0010L\u001a\u00020\u0010J\b\u0010M\u001a\u00020\bH\u0016R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010!\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010#\"\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b'\u0010#R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010#R\u001a\u0010(\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010#\"\u0004\b)\u0010&R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R6\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0.2\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0.0.@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102RN\u00104\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b03032\u001e\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0303@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u00a8\u0006O"}, d2={"Lcom/onesignal/inAppMessages/internal/InAppMessage;", "Lcom/onesignal/inAppMessages/IInAppMessage;", "isPreview", "", "time", "Lcom/onesignal/core/internal/time/ITime;", "(ZLcom/onesignal/core/internal/time/ITime;)V", "messageId", "", "clickIds", "", "displayedInSession", "redisplayStats", "Lcom/onesignal/inAppMessages/internal/InAppMessageRedisplayStats;", "(Ljava/lang/String;Ljava/util/Set;ZLcom/onesignal/inAppMessages/internal/InAppMessageRedisplayStats;Lcom/onesignal/core/internal/time/ITime;)V", "json", "Lorg/json/JSONObject;", "(Lorg/json/JSONObject;Lcom/onesignal/core/internal/time/ITime;)V", "(Ljava/lang/String;Lcom/onesignal/core/internal/time/ITime;)V", "actionTaken", "<set-?>", "", "clickedClickIds", "getClickedClickIds", "()Ljava/util/Set;", "displayDuration", "", "getDisplayDuration", "()D", "setDisplayDuration", "(D)V", "endTime", "Ljava/util/Date;", "hasLiquid", "getHasLiquid", "()Z", "isDisplayedInSession", "setDisplayedInSession", "(Z)V", "isFinished", "isTriggerChanged", "setTriggerChanged", "getMessageId", "()Ljava/lang/String;", "getRedisplayStats", "()Lcom/onesignal/inAppMessages/internal/InAppMessageRedisplayStats;", "", "Lcom/onesignal/inAppMessages/internal/Trigger;", "triggers", "getTriggers", "()Ljava/util/List;", "", "variants", "getVariants", "()Ljava/util/Map;", "addClickId", "", "clickId", "clearClickIds", "equals", "o", "", "hashCode", "", "isClickAvailable", "parseEndTimeJson", "parseTriggerJson", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "triggersJson", "Lorg/json/JSONArray;", "parseVariants", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "removeClickId", "takeActionAsUnique", "toJSONObject", "toString", "Companion", "com.onesignal.inAppMessages"})
@SourceDebugExtension(value={"SMAP\nInAppMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InAppMessage.kt\ncom/onesignal/inAppMessages/internal/InAppMessage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,265:1\n1#2:266\n*E\n"})
public final class InAppMessage
implements IInAppMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String messageId;
    @NotNull
    private Map<String, ? extends Map<String, String>> variants;
    @NotNull
    private List<? extends List<Trigger>> triggers;
    @NotNull
    private Set<String> clickedClickIds;
    @NotNull
    private InAppMessageRedisplayStats redisplayStats;
    private double displayDuration;
    private boolean isDisplayedInSession;
    private boolean isTriggerChanged;
    private boolean actionTaken;
    @Nullable
    private Date endTime;
    private boolean isPreview;
    private boolean hasLiquid;
    @NotNull
    private static final String ID = "id";
    @NotNull
    private static final String IAM_ID = "messageId";
    @NotNull
    private static final String IAM_VARIANTS = "variants";
    @NotNull
    private static final String IAM_TRIGGERS = "triggers";
    @NotNull
    private static final String IAM_REDISPLAY_STATS = "redisplay";
    @NotNull
    private static final String DISPLAY_DURATION = "displayDuration";
    @NotNull
    private static final String END_TIME = "end_time";
    @NotNull
    private static final String HAS_LIQUID = "has_liquid";

    public InAppMessage(@NotNull String messageId, @NotNull ITime time) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)IAM_ID);
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.messageId = messageId;
        this.variants = MapsKt.emptyMap();
        this.triggers = CollectionsKt.emptyList();
        this.clickedClickIds = new LinkedHashSet();
        this.redisplayStats = new InAppMessageRedisplayStats(time);
    }

    @NotNull
    public String getMessageId() {
        return this.messageId;
    }

    @NotNull
    public final Map<String, Map<String, String>> getVariants() {
        return this.variants;
    }

    @NotNull
    public final List<List<Trigger>> getTriggers() {
        return this.triggers;
    }

    @NotNull
    public final Set<String> getClickedClickIds() {
        return this.clickedClickIds;
    }

    @NotNull
    public final InAppMessageRedisplayStats getRedisplayStats() {
        return this.redisplayStats;
    }

    public final double getDisplayDuration() {
        return this.displayDuration;
    }

    public final void setDisplayDuration(double d) {
        this.displayDuration = d;
    }

    public final boolean isDisplayedInSession() {
        return this.isDisplayedInSession;
    }

    public final void setDisplayedInSession(boolean bl) {
        this.isDisplayedInSession = bl;
    }

    public final boolean isTriggerChanged() {
        return this.isTriggerChanged;
    }

    public final void setTriggerChanged(boolean bl) {
        this.isTriggerChanged = bl;
    }

    public final boolean isPreview() {
        return this.isPreview;
    }

    public final boolean getHasLiquid() {
        return this.hasLiquid;
    }

    public InAppMessage(boolean isPreview, @NotNull ITime time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this("", time);
        this.isPreview = isPreview;
    }

    public InAppMessage(@NotNull String messageId, @NotNull Set<String> clickIds, boolean displayedInSession, @NotNull InAppMessageRedisplayStats redisplayStats, @NotNull ITime time) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)IAM_ID);
        Intrinsics.checkNotNullParameter(clickIds, (String)"clickIds");
        Intrinsics.checkNotNullParameter((Object)redisplayStats, (String)"redisplayStats");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this(messageId, time);
        this.clickedClickIds = CollectionsKt.toMutableSet((Iterable)clickIds);
        this.isDisplayedInSession = displayedInSession;
        this.redisplayStats = redisplayStats;
    }

    public InAppMessage(@NotNull JSONObject json2, @NotNull ITime time) {
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        String string = json2.getString(ID);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        this(string, time);
        JSONObject jSONObject = json2.getJSONObject(IAM_VARIANTS);
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"getJSONObject(...)");
        this.variants = this.parseVariants(jSONObject);
        JSONArray jSONArray = json2.getJSONArray(IAM_TRIGGERS);
        Intrinsics.checkNotNullExpressionValue((Object)jSONArray, (String)"getJSONArray(...)");
        this.triggers = this.parseTriggerJson(jSONArray);
        this.endTime = this.parseEndTimeJson(json2);
        if (json2.has(HAS_LIQUID)) {
            this.hasLiquid = json2.getBoolean(HAS_LIQUID);
        }
        if (json2.has(IAM_REDISPLAY_STATS)) {
            JSONObject jSONObject2 = json2.getJSONObject(IAM_REDISPLAY_STATS);
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject2, (String)"getJSONObject(...)");
            this.redisplayStats = new InAppMessageRedisplayStats(jSONObject2, time);
        }
    }

    private final Date parseEndTimeJson(JSONObject json2) {
        String string;
        String endTimeString = null;
        try {
            string = json2.getString(END_TIME);
            Intrinsics.checkNotNull((Object)string);
        }
        catch (JSONException e) {
            return null;
        }
        endTimeString = string;
        if (Intrinsics.areEqual((Object)endTimeString, (Object)"null")) {
            return null;
        }
        try {
            SimpleDateFormat format = DateUtils.INSTANCE.iso8601Format();
            return format.parse(endTimeString);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private final HashMap<String, HashMap<String, String>> parseVariants(JSONObject json2) throws JSONException {
        HashMap<String, HashMap<String, String>> variantTypes = new HashMap<String, HashMap<String, String>>();
        Iterator keyIterator = json2.keys();
        while (keyIterator.hasNext()) {
            String variantType = (String)keyIterator.next();
            JSONObject variant = json2.getJSONObject(variantType);
            HashMap variantMap = new HashMap();
            Iterator variantIterator = variant.keys();
            while (variantIterator.hasNext()) {
                String string;
                String languageType = (String)variantIterator.next();
                Map map = variantMap;
                Intrinsics.checkNotNull((Object)languageType);
                String string2 = languageType;
                Intrinsics.checkNotNullExpressionValue((Object)variant.getString(languageType), (String)"getString(...)");
                map.put(string2, string);
            }
            Map map = variantTypes;
            Intrinsics.checkNotNull((Object)variantType);
            map.put(variantType, variantMap);
        }
        return variantTypes;
    }

    private final ArrayList<ArrayList<Trigger>> parseTriggerJson(JSONArray triggersJson) throws JSONException {
        ArrayList<ArrayList<Trigger>> parsedTriggers = new ArrayList<ArrayList<Trigger>>();
        int n = triggersJson.length();
        for (int i = 0; i < n; ++i) {
            JSONArray ands = triggersJson.getJSONArray(i);
            ArrayList<Trigger> converted = new ArrayList<Trigger>();
            int n2 = ands.length();
            for (int j = 0; j < n2; ++j) {
                JSONObject jSONObject = ands.getJSONObject(j);
                Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"getJSONObject(...)");
                Trigger trigger = new Trigger(jSONObject);
                converted.add(trigger);
            }
            parsedTriggers.add(converted);
        }
        return parsedTriggers;
    }

    @NotNull
    public final JSONObject toJSONObject() {
        JSONObject json2 = new JSONObject();
        try {
            json2.put(IAM_ID, (Object)this.getMessageId());
            JSONObject variants = new JSONObject();
            for (String string : this.variants.keySet()) {
                Map<String, String> map;
                Intrinsics.checkNotNull(this.variants.get(string));
                JSONObject converted = new JSONObject();
                for (String variantKey : map.keySet()) {
                    converted.put(variantKey, (Object)map.get(variantKey));
                }
                variants.put(string, (Object)converted);
            }
            json2.put(IAM_VARIANTS, (Object)variants);
            json2.put(DISPLAY_DURATION, this.displayDuration);
            json2.put(IAM_REDISPLAY_STATS, (Object)this.redisplayStats.toJSONObject());
            JSONArray orConditions = new JSONArray();
            for (List<Trigger> list : this.triggers) {
                JSONArray andConditions = new JSONArray();
                for (Trigger trigger : list) {
                    andConditions.put((Object)trigger.toJSONObject());
                }
                orConditions.put((Object)andConditions);
            }
            json2.put(IAM_TRIGGERS, (Object)orConditions);
            if (this.endTime != null) {
                SimpleDateFormat simpleDateFormat = DateUtils.INSTANCE.iso8601Format();
                String string = simpleDateFormat.format(this.endTime);
                json2.put(END_TIME, (Object)string);
            }
            json2.put(HAS_LIQUID, this.hasLiquid);
        }
        catch (JSONException exception) {
            exception.printStackTrace();
        }
        return json2;
    }

    public final boolean takeActionAsUnique() {
        boolean bl;
        if (this.actionTaken) {
            bl = false;
        } else {
            boolean bl2;
            boolean it = bl2 = true;
            boolean bl3 = false;
            this.actionTaken = it;
            bl = bl2;
        }
        return bl;
    }

    public final boolean isClickAvailable(@NotNull String clickId) {
        Intrinsics.checkNotNullParameter((Object)clickId, (String)"clickId");
        return !this.clickedClickIds.contains(clickId);
    }

    public final void clearClickIds() {
        this.clickedClickIds.clear();
    }

    public final void addClickId(@NotNull String clickId) {
        Intrinsics.checkNotNullParameter((Object)clickId, (String)"clickId");
        this.clickedClickIds.add(clickId);
    }

    public final void removeClickId(@NotNull String clickId) {
        Intrinsics.checkNotNullParameter((Object)clickId, (String)"clickId");
        this.clickedClickIds.remove(clickId);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OSInAppMessage{messageId='").append(this.getMessageId()).append("', variants=").append(this.variants).append(", triggers=").append(this.triggers).append(", clickedClickIds=").append(this.clickedClickIds).append(", redisplayStats=").append(this.redisplayStats).append(", displayDuration=").append(this.displayDuration).append(", displayedInSession=").append(this.isDisplayedInSession).append(", triggerChanged=").append(this.isTriggerChanged).append(", actionTaken=").append(this.actionTaken).append(", isPreview=").append(this.isPreview).append(", endTime=").append(this.endTime).append(", hasLiquid=");
        stringBuilder.append(this.hasLiquid).append('}');
        return stringBuilder.toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !Intrinsics.areEqual(this.getClass(), o.getClass())) {
            return false;
        }
        InAppMessage that = (InAppMessage)o;
        return Intrinsics.areEqual((Object)this.getMessageId(), (Object)that.getMessageId());
    }

    public int hashCode() {
        return this.getMessageId().hashCode();
    }

    public final boolean isFinished() {
        if (this.endTime == null) {
            return false;
        }
        Date now = new Date();
        Date date = this.endTime;
        Intrinsics.checkNotNull((Object)date);
        return date.before(now);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/onesignal/inAppMessages/internal/InAppMessage$Companion;", "", "()V", "DISPLAY_DURATION", "", "END_TIME", "HAS_LIQUID", "IAM_ID", "IAM_REDISPLAY_STATS", "IAM_TRIGGERS", "IAM_VARIANTS", "ID", "com.onesignal.inAppMessages"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

