/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.inAppMessages.internal.common;

import android.content.ComponentName;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import androidx.browser.customtabs.CustomTabsClient;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.browser.customtabs.CustomTabsServiceConnection;
import androidx.browser.customtabs.CustomTabsSession;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J%\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lcom/onesignal/inAppMessages/internal/common/OneSignalChromeTab;", "", "()V", "hasChromeTabLibrary", "", "open", "url", "", "openActivity", "context", "Landroid/content/Context;", "open$com_onesignal_inAppMessages", "OneSignalCustomTabsServiceConnection", "com.onesignal.inAppMessages"})
public final class OneSignalChromeTab {
    @NotNull
    public static final OneSignalChromeTab INSTANCE = new OneSignalChromeTab();

    private OneSignalChromeTab() {
    }

    private final boolean hasChromeTabLibrary() {
        boolean bl;
        try {
            bl = true;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    public final boolean open$com_onesignal_inAppMessages(@NotNull String url, boolean openActivity, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.hasChromeTabLibrary()) {
            return false;
        }
        CustomTabsServiceConnection connection = new OneSignalCustomTabsServiceConnection(url, openActivity, context);
        return CustomTabsClient.bindCustomTabsService((Context)context, (String)"com.android.chrome", (CustomTabsServiceConnection)connection);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/onesignal/inAppMessages/internal/common/OneSignalChromeTab$OneSignalCustomTabsServiceConnection;", "Landroidx/browser/customtabs/CustomTabsServiceConnection;", "url", "", "openActivity", "", "context", "Landroid/content/Context;", "(Ljava/lang/String;ZLandroid/content/Context;)V", "onCustomTabsServiceConnected", "", "componentName", "Landroid/content/ComponentName;", "customTabsClient", "Landroidx/browser/customtabs/CustomTabsClient;", "onServiceDisconnected", "name", "com.onesignal.inAppMessages"})
    private static final class OneSignalCustomTabsServiceConnection
    extends CustomTabsServiceConnection {
        @NotNull
        private final String url;
        private final boolean openActivity;
        @NotNull
        private final Context context;

        public OneSignalCustomTabsServiceConnection(@NotNull String url, boolean openActivity, @NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.url = url;
            this.openActivity = openActivity;
            this.context = context;
        }

        public void onCustomTabsServiceConnected(@NotNull ComponentName componentName, @NotNull CustomTabsClient customTabsClient) {
            Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
            Intrinsics.checkNotNullParameter((Object)customTabsClient, (String)"customTabsClient");
            customTabsClient.warmup(0L);
            CustomTabsSession customTabsSession = customTabsClient.newSession(null);
            if (customTabsSession == null) {
                return;
            }
            CustomTabsSession session = customTabsSession;
            Uri uri = Uri.parse((String)this.url);
            session.mayLaunchUrl(uri, null, null);
            if (this.openActivity) {
                CustomTabsIntent.Builder mBuilder = new CustomTabsIntent.Builder(session);
                CustomTabsIntent customTabsIntent = mBuilder.build();
                Intrinsics.checkNotNullExpressionValue((Object)customTabsIntent, (String)"mBuilder.build()");
                CustomTabsIntent customTabsIntent2 = customTabsIntent;
                customTabsIntent2.intent.setData(uri);
                customTabsIntent2.intent.addFlags(0x10000000);
                if (Build.VERSION.SDK_INT >= 16) {
                    this.context.startActivity(customTabsIntent2.intent, customTabsIntent2.startAnimationBundle);
                } else {
                    this.context.startActivity(customTabsIntent2.intent);
                }
            }
        }

        public void onServiceDisconnected(@NotNull ComponentName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        }
    }
}

