/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.common;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.view.DisplayCutout;
import android.view.View;
import android.view.WindowInsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0003J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0012"}, d2={"Lcom/onesignal/common/ViewUtils;", "", "()V", "dpToPx", "", "dp", "getCutoutAndStatusBarInsets", "", "activity", "Landroid/app/Activity;", "getDisplaySizeY", "getFullbleedWindowWidth", "getWindowHeight", "getWindowHeightAPI23Plus", "getWindowHeightLollipop", "getWindowVisibleDisplayFrame", "Landroid/graphics/Rect;", "getWindowWidth", "com.onesignal.core"})
public final class ViewUtils {
    @NotNull
    public static final ViewUtils INSTANCE = new ViewUtils();

    private ViewUtils() {
    }

    public final int dpToPx(int dp) {
        return (int)((float)dp * Resources.getSystem().getDisplayMetrics().density);
    }

    public final int getWindowHeight(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        return Build.VERSION.SDK_INT >= 23 ? this.getWindowHeightAPI23Plus(activity) : this.getWindowHeightLollipop(activity);
    }

    private final int getDisplaySizeY(Activity activity) {
        Point point = new Point();
        activity.getWindowManager().getDefaultDisplay().getSize(point);
        return point.y;
    }

    @TargetApi(value=23)
    private final int getWindowHeightAPI23Plus(Activity activity) {
        View view = activity.getWindow().getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getDecorView(...)");
        View decorView = view;
        WindowInsets windowInsets = decorView.getRootWindowInsets();
        if (windowInsets == null) {
            return decorView.getHeight();
        }
        WindowInsets windowInsets2 = windowInsets;
        return decorView.getHeight() - windowInsets2.getStableInsetBottom() - windowInsets2.getStableInsetTop();
    }

    private final int getWindowHeightLollipop(Activity activity) {
        return activity.getResources().getConfiguration().orientation == 2 ? this.getWindowVisibleDisplayFrame(activity).height() : this.getDisplaySizeY(activity);
    }

    private final Rect getWindowVisibleDisplayFrame(Activity activity) {
        Rect rect = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
        return rect;
    }

    @NotNull
    public final int[] getCutoutAndStatusBarInsets(@NotNull Activity activity) {
        DisplayCutout cutout;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Rect frame = this.getWindowVisibleDisplayFrame(activity);
        View contentView = activity.getWindow().findViewById(0x1020002);
        float rightInset = 0.0f;
        float leftInset = 0.0f;
        float topInset = (float)(frame.top - contentView.getTop()) / Resources.getSystem().getDisplayMetrics().density;
        float bottomInset = (float)(contentView.getBottom() - frame.bottom) / Resources.getSystem().getDisplayMetrics().density;
        if (Build.VERSION.SDK_INT == 29 && (cutout = activity.getWindowManager().getDefaultDisplay().getCutout()) != null) {
            rightInset = (float)cutout.getSafeInsetRight() / Resources.getSystem().getDisplayMetrics().density;
            leftInset = (float)cutout.getSafeInsetLeft() / Resources.getSystem().getDisplayMetrics().density;
        }
        int[] nArray = new int[]{MathKt.roundToInt((float)topInset), MathKt.roundToInt((float)bottomInset), MathKt.roundToInt((float)rightInset), MathKt.roundToInt((float)leftInset)};
        return nArray;
    }

    public final int getFullbleedWindowWidth(@NotNull Activity activity) {
        int n;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 23) {
            View view = activity.getWindow().getDecorView();
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getDecorView(...)");
            View decorView = view;
            n = decorView.getWidth();
        } else {
            n = this.getWindowWidth(activity);
        }
        return n;
    }

    public final int getWindowWidth(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        return this.getWindowVisibleDisplayFrame(activity).width();
    }
}

