/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.common.threading;

import com.onesignal.common.AndroidUtils;
import com.onesignal.debug.internal.logging.Logging;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\nH\u0002J\b\u0010\r\u001a\u00020\u0003H\u0002J\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/onesignal/common/threading/LatchAwaiter;", "", "componentName", "", "(Ljava/lang/String;)V", "latch", "Ljava/util/concurrent/CountDownLatch;", "await", "", "timeoutMs", "", "createTimeoutMessage", "getDefaultTimeout", "logAllThreads", "release", "", "Companion", "com.onesignal.core"})
public final class LatchAwaiter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String componentName;
    @NotNull
    private final CountDownLatch latch;
    public static final long DEFAULT_TIMEOUT_MS = 30000L;
    public static final long ANDROID_ANR_TIMEOUT_MS = 4800L;

    public LatchAwaiter(@NotNull String componentName) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        this.componentName = componentName;
        this.latch = new CountDownLatch(1);
    }

    public /* synthetic */ LatchAwaiter(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "Component";
        }
        this(string);
    }

    public final void release() {
        this.latch.countDown();
    }

    public final boolean await(long timeoutMs) {
        boolean bl;
        try {
            bl = this.latch.await(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Logging.warn("Interrupted while waiting for " + this.componentName, e);
            this.logAllThreads();
            bl = false;
        }
        boolean completed = bl;
        if (!completed) {
            String message = this.createTimeoutMessage(timeoutMs);
            Logging.warn$default(message, null, 2, null);
        }
        return completed;
    }

    public static /* synthetic */ boolean await$default(LatchAwaiter latchAwaiter, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = latchAwaiter.getDefaultTimeout();
        }
        return latchAwaiter.await(l);
    }

    private final long getDefaultTimeout() {
        return AndroidUtils.INSTANCE.isRunningOnMainThread() ? 4800L : 30000L;
    }

    private final String createTimeoutMessage(long timeoutMs) {
        return AndroidUtils.INSTANCE.isRunningOnMainThread() ? "Timeout waiting for " + this.componentName + " after " + timeoutMs + "ms on the main thread. This can cause ANRs. Consider calling from a background thread." : "Timeout waiting for " + this.componentName + " after " + timeoutMs + "ms.";
    }

    private final String logAllThreads() {
        Map<Thread, StackTraceElement[]> allThreads = Thread.getAllStackTraces();
        StringBuilder sb = new StringBuilder();
        Intrinsics.checkNotNullExpressionValue(allThreads, (String)"allThreads");
        for (Map.Entry<Thread, StackTraceElement[]> entry : allThreads.entrySet()) {
            Thread thread = entry.getKey();
            StackTraceElement[] stack = entry.getValue();
            sb.append("ThreadDump Thread: " + thread.getName() + " [" + (Object)((Object)thread.getState()) + "]\n");
            Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
            for (StackTraceElement element : stack) {
                sb.append("\tat " + element + '\n');
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public LatchAwaiter() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/onesignal/common/threading/LatchAwaiter$Companion;", "", "()V", "ANDROID_ANR_TIMEOUT_MS", "", "DEFAULT_TIMEOUT_MS", "com.onesignal.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

