/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import androidx.work.Constraints;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.ActivityLifecycleListener;
import com.onesignal.OSFocusHandler;
import com.onesignal.OSTimeoutHandler;
import com.onesignal.OneSignal;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\b\u0010\u0010\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\bH\u0002J\u0006\u0010\u0012\u001a\u00020\bJ\u001e\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u0016\u001a\u00020\bJ\u0006\u0010\u0017\u001a\u00020\bR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/onesignal/OSFocusHandler;", "", "()V", "stopRunnable", "Ljava/lang/Runnable;", "buildConstraints", "Landroidx/work/Constraints;", "cancelOnLostFocusWorker", "", "tag", "", "context", "Landroid/content/Context;", "hasBackgrounded", "", "hasCompleted", "resetBackgroundState", "resetStopState", "startOnFocusWork", "startOnLostFocusWorker", "delay", "", "startOnStartFocusWork", "startOnStopFocusWork", "Companion", "OnLostFocusWorker", "onesignal_release"})
public final class OSFocusHandler {
    private Runnable stopRunnable;
    private static final long stopDelay = 1500L;
    private static boolean stopped;
    private static boolean backgrounded;
    private static boolean completed;
    @NotNull
    public static final Companion Companion;

    public final boolean hasBackgrounded() {
        return backgrounded;
    }

    public final boolean hasCompleted() {
        return completed;
    }

    public final void startOnFocusWork() {
        this.resetBackgroundState();
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "OSFocusHandler running onAppFocus");
        OneSignal.onAppFocus();
    }

    public final void startOnStartFocusWork() {
        if (stopped) {
            stopped = false;
            this.stopRunnable = null;
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "OSFocusHandler running onAppStartFocusLogic");
            OneSignal.onAppStartFocusLogic();
        } else {
            this.resetStopState();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void startOnStopFocusWork() {
        void it;
        startOnStopFocusWork.1 var1_1 = startOnStopFocusWork.1.INSTANCE;
        boolean bl = false;
        boolean bl2 = false;
        Runnable runnable = var1_1;
        OSFocusHandler oSFocusHandler = this;
        boolean bl3 = false;
        OSTimeoutHandler.getTimeoutHandler().startTimeout(1500L, (Runnable)it);
        Unit unit = Unit.INSTANCE;
        oSFocusHandler.stopRunnable = var1_1;
    }

    public final void startOnLostFocusWorker(@NotNull String tag, long delay, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Constraints constraints = this.buildConstraints();
        WorkRequest workRequest = ((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(OnLostFocusWorker.class).setConstraints(constraints)).setInitialDelay(delay, TimeUnit.MILLISECONDS)).addTag(tag)).build();
        Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"OneTimeWorkRequest.Build\u2026tag)\n            .build()");
        OneTimeWorkRequest workRequest2 = (OneTimeWorkRequest)workRequest;
        WorkManager.getInstance((Context)context).enqueueUniqueWork(tag, ExistingWorkPolicy.KEEP, workRequest2);
    }

    public final void cancelOnLostFocusWorker(@NotNull String tag, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        WorkManager.getInstance((Context)context).cancelAllWorkByTag(tag);
    }

    private final void resetStopState() {
        block0: {
            stopped = false;
            Runnable runnable = this.stopRunnable;
            if (runnable == null) break block0;
            Runnable runnable2 = runnable;
            boolean bl = false;
            boolean bl2 = false;
            Runnable it = runnable2;
            boolean bl3 = false;
            OSTimeoutHandler.getTimeoutHandler().destroyTimeout(it);
        }
    }

    private final void resetBackgroundState() {
        this.resetStopState();
        backgrounded = false;
    }

    private final Constraints buildConstraints() {
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
        Intrinsics.checkNotNullExpressionValue((Object)constraints, (String)"Constraints.Builder()\n  \u2026TED)\n            .build()");
        return constraints;
    }

    static {
        Companion = new Companion(null);
    }

    public static final /* synthetic */ boolean access$getStopped$cp() {
        return stopped;
    }

    public static final /* synthetic */ void access$setStopped$cp(boolean bl) {
        stopped = bl;
    }

    public static final /* synthetic */ boolean access$getBackgrounded$cp() {
        return backgrounded;
    }

    public static final /* synthetic */ boolean access$getCompleted$cp() {
        return completed;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/onesignal/OSFocusHandler$OnLostFocusWorker;", "Landroidx/work/Worker;", "context", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "onesignal_release"})
    public static final class OnLostFocusWorker
    extends Worker {
        @NotNull
        public ListenableWorker.Result doWork() {
            Companion.onLostFocusDoWork();
            ListenableWorker.Result result = ListenableWorker.Result.success();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"Result.success()");
            return result;
        }

        public OnLostFocusWorker(@NotNull Context context, @NotNull WorkerParameters workerParams) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)workerParams, (String)"workerParams");
            super(context, workerParams);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/onesignal/OSFocusHandler$Companion;", "", "()V", "backgrounded", "", "completed", "stopDelay", "", "stopped", "onLostFocusDoWork", "", "onesignal_release"})
    public static final class Companion {
        public final void onLostFocusDoWork() {
            ActivityLifecycleHandler activityLifecycleHandler = ActivityLifecycleListener.getActivityLifecycleHandler();
            if (activityLifecycleHandler == null || activityLifecycleHandler.getCurActivity() == null) {
                OneSignal.setInForeground(false);
            }
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "OSFocusHandler running onAppLostFocus");
            backgrounded = true;
            OneSignal.onAppLostFocus();
            completed = true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

