/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.RequiresApi;
import com.onesignal.AndroidSupportV4Compat;
import com.onesignal.FocusTimeController;
import com.onesignal.LocationController;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.SyncJobService;
import com.onesignal.SyncService;
import java.util.concurrent.ArrayBlockingQueue;

class OneSignalSyncServiceUtils {
    private static final int SYNC_TASK_ID = 2071862118;
    private static final long SYNC_AFTER_BG_DELAY_MS = 30000L;
    private static Long nextScheduledSyncTimeMs = 0L;
    private static boolean needsJobReschedule = false;
    private static Thread syncBgThread;

    OneSignalSyncServiceUtils() {
    }

    static void scheduleLocationUpdateTask(Context context, long delayMs) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "scheduleLocationUpdateTask:delayMs: " + delayMs);
        OneSignalSyncServiceUtils.scheduleSyncTask(context, delayMs);
    }

    static void scheduleSyncTask(Context context) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "scheduleSyncTask:SYNC_AFTER_BG_DELAY_MS: 30000");
        OneSignalSyncServiceUtils.scheduleSyncTask(context, 30000L);
    }

    static synchronized void cancelSyncTask(Context context) {
        nextScheduledSyncTimeMs = 0L;
        boolean didSchedule = LocationController.scheduleUpdate(context);
        if (didSchedule) {
            return;
        }
        if (OneSignalSyncServiceUtils.useJob()) {
            JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
            jobScheduler.cancel(2071862118);
        } else {
            AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
            alarmManager.cancel(OneSignalSyncServiceUtils.syncServicePendingIntent(context));
        }
    }

    private static PendingIntent syncServicePendingIntent(Context context) {
        return PendingIntent.getService((Context)context, (int)2071862118, (Intent)new Intent(context, SyncService.class), (int)0x8000000);
    }

    private static boolean useJob() {
        return Build.VERSION.SDK_INT >= 21;
    }

    private static synchronized void scheduleSyncTask(Context context, long delayMs) {
        if (nextScheduledSyncTimeMs != 0L && System.currentTimeMillis() + delayMs > nextScheduledSyncTimeMs) {
            return;
        }
        if (delayMs < 5000L) {
            delayMs = 5000L;
        }
        if (OneSignalSyncServiceUtils.useJob()) {
            OneSignalSyncServiceUtils.scheduleSyncServiceAsJob(context, delayMs);
        } else {
            OneSignalSyncServiceUtils.scheduleSyncServiceAsAlarm(context, delayMs);
        }
        nextScheduledSyncTimeMs = System.currentTimeMillis() + delayMs;
    }

    private static boolean hasBootPermission(Context context) {
        return AndroidSupportV4Compat.ContextCompat.checkSelfPermission(context, "android.permission.RECEIVE_BOOT_COMPLETED") == 0;
    }

    @RequiresApi(api=21)
    private static boolean isJobIdRunning(Context context) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        for (JobInfo jobInfo : jobScheduler.getAllPendingJobs()) {
            if (jobInfo.getId() != 2071862118 || syncBgThread == null || !syncBgThread.isAlive()) continue;
            return true;
        }
        return false;
    }

    @RequiresApi(value=21)
    private static void scheduleSyncServiceAsJob(Context context, long delayMs) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "scheduleSyncServiceAsJob:atTime: " + delayMs);
        if (OneSignalSyncServiceUtils.isJobIdRunning(context)) {
            OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "scheduleSyncServiceAsJob Scheduler already running!");
            needsJobReschedule = true;
            return;
        }
        JobInfo.Builder jobBuilder = new JobInfo.Builder(2071862118, new ComponentName(context, SyncJobService.class));
        jobBuilder.setMinimumLatency(delayMs).setRequiredNetworkType(1);
        if (OneSignalSyncServiceUtils.hasBootPermission(context)) {
            jobBuilder.setPersisted(true);
        }
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        try {
            int result = jobScheduler.schedule(jobBuilder.build());
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "scheduleSyncServiceAsJob:result: " + result);
        }
        catch (NullPointerException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "scheduleSyncServiceAsJob called JobScheduler.jobScheduler which triggered an internal null Android error. Skipping job.", e);
        }
    }

    private static void scheduleSyncServiceAsAlarm(Context context, long delayMs) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "scheduleServiceSyncTask:atTime: " + delayMs);
        PendingIntent pendingIntent = OneSignalSyncServiceUtils.syncServicePendingIntent(context);
        AlarmManager alarm = (AlarmManager)context.getSystemService("alarm");
        long triggerAtMs = System.currentTimeMillis() + delayMs;
        alarm.set(0, triggerAtMs + delayMs, pendingIntent);
    }

    static void doBackgroundSync(Context context, SyncRunnable runnable) {
        OneSignal.setAppContext(context);
        syncBgThread = new Thread((Runnable)runnable, "OS_SYNCSRV_BG_SYNC");
        syncBgThread.start();
    }

    static boolean stopSyncBgThread() {
        if (syncBgThread == null) {
            return false;
        }
        if (!syncBgThread.isAlive()) {
            return false;
        }
        syncBgThread.interrupt();
        return true;
    }

    static class LegacySyncRunnable
    extends SyncRunnable {
        Service callerService;

        LegacySyncRunnable(Service caller) {
            this.callerService = caller;
        }

        @Override
        protected void stopSync() {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "LegacySyncRunnable:Stopped");
            this.callerService.stopSelf();
        }
    }

    @RequiresApi(api=21)
    static class LollipopSyncRunnable
    extends SyncRunnable {
        private JobService jobService;
        private JobParameters jobParameters;

        LollipopSyncRunnable(JobService caller, JobParameters jobParameters) {
            this.jobService = caller;
            this.jobParameters = jobParameters;
        }

        @Override
        protected void stopSync() {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "LollipopSyncRunnable:JobFinished needsJobReschedule: " + needsJobReschedule);
            boolean reschedule = needsJobReschedule;
            needsJobReschedule = false;
            this.jobService.jobFinished(this.jobParameters, reschedule);
        }
    }

    static abstract class SyncRunnable
    implements Runnable {
        SyncRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Class<OneSignalSyncServiceUtils> clazz = OneSignalSyncServiceUtils.class;
            synchronized (OneSignalSyncServiceUtils.class) {
                nextScheduledSyncTimeMs = 0L;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (OneSignal.getUserId() == null) {
                    this.stopSync();
                    return;
                }
                OneSignal.appId = OneSignal.getSavedAppId();
                OneSignalStateSynchronizer.initUserState();
                try {
                    final ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
                    LocationController.LocationHandler locationHandler = new LocationController.LocationHandler(){

                        @Override
                        public LocationController.PermissionType getType() {
                            return LocationController.PermissionType.SYNC_SERVICE;
                        }

                        @Override
                        public void onComplete(LocationController.LocationPoint point) {
                            Object object = point != null ? point : new Object();
                            queue.offer(object);
                        }
                    };
                    LocationController.getLocation(OneSignal.appContext, false, false, locationHandler);
                    Object point = queue.take();
                    if (point instanceof LocationController.LocationPoint) {
                        OneSignalStateSynchronizer.updateLocation((LocationController.LocationPoint)point);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                OneSignalStateSynchronizer.syncUserState(true);
                FocusTimeController.getInstance().doBlockingBackgroundSyncOfUnsentTime();
                this.stopSync();
                return;
            }
        }

        protected abstract void stopSync();
    }
}

