/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.OneSignal;
import com.onesignal.UserState;
import com.onesignal.UserStateEmail;
import com.onesignal.UserStateSynchronizer;
import org.json.JSONException;
import org.json.JSONObject;

class UserStateEmailSynchronizer
extends UserStateSynchronizer {
    UserStateEmailSynchronizer() {
    }

    @Override
    protected UserState newUserState(String inPersistKey, boolean load) {
        return new UserStateEmail(inPersistKey, load);
    }

    @Override
    boolean getSubscribed() {
        return false;
    }

    @Override
    UserStateSynchronizer.GetTagsResult getTags(boolean fromServer) {
        return null;
    }

    @Override
    void setSubscription(boolean enable) {
    }

    @Override
    public boolean getUserSubscribePreference() {
        return false;
    }

    @Override
    public void setPermission(boolean enable) {
    }

    @Override
    void updateState(JSONObject state) {
    }

    void refresh() {
        this.scheduleSyncToServer();
    }

    @Override
    protected void scheduleSyncToServer() {
        boolean neverEmail;
        boolean bl = neverEmail = this.getId() == null && this.getRegistrationId() == null;
        if (neverEmail || OneSignal.getUserId() == null) {
            return;
        }
        this.getNetworkHandlerThread(0).runNewJobDelayed();
    }

    void setEmail(String email, String emailAuthHash) {
        boolean noChange;
        JSONObject syncValues = this.getUserStateForModification().syncValues;
        boolean bl = email.equals(syncValues.optString("identifier")) && syncValues.optString("email_auth_hash").equals(emailAuthHash == null ? "" : emailAuthHash) ? true : (noChange = false);
        if (noChange) {
            OneSignal.fireEmailUpdateSuccess();
            return;
        }
        String existingEmail = syncValues.optString("identifier", null);
        if (existingEmail == null) {
            this.setNewSession();
        }
        try {
            JSONObject emailJSON = new JSONObject();
            emailJSON.put("identifier", (Object)email);
            if (emailAuthHash != null) {
                emailJSON.put("email_auth_hash", (Object)emailAuthHash);
            }
            if (emailAuthHash == null && existingEmail != null && !existingEmail.equals(email)) {
                OneSignal.saveEmailId("");
                this.resetCurrentState();
                this.setNewSession();
            }
            this.generateJsonDiff(syncValues, emailJSON, syncValues, null);
            this.scheduleSyncToServer();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getId() {
        return OneSignal.getEmailId();
    }

    @Override
    void updateIdDependents(String id2) {
        OneSignal.updateEmailIdDependents(id2);
    }

    @Override
    protected void addOnSessionOrCreateExtras(JSONObject jsonBody) {
        try {
            jsonBody.put("device_type", 11);
            jsonBody.putOpt("device_player_id", (Object)OneSignal.getUserId());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    void logoutEmail() {
        OneSignal.saveEmailId("");
        this.resetCurrentState();
        this.getToSyncUserState().syncValues.remove("identifier");
        this.toSyncUserState.syncValues.remove("email_auth_hash");
        this.toSyncUserState.syncValues.remove("device_player_id");
        this.toSyncUserState.persistState();
        OneSignal.getPermissionSubscriptionState().emailSubscriptionStatus.clearEmailAndId();
    }

    @Override
    protected void fireEventsForUpdateFailure(JSONObject jsonFields) {
        if (jsonFields.has("identifier")) {
            OneSignal.fireEmailUpdateFailure();
        }
    }

    @Override
    protected void onSuccessfulSync(JSONObject jsonFields) {
        if (jsonFields.has("identifier")) {
            OneSignal.fireEmailUpdateSuccess();
        }
    }
}

