/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.annotation.TargetApi;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.PersistableBundle;
import android.support.v4.content.WakefulBroadcastReceiver;
import com.onesignal.BundleCompat;
import com.onesignal.BundleCompatBundle;
import com.onesignal.BundleCompatFactory;
import com.onesignal.GcmIntentJobService;
import com.onesignal.GcmIntentService;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.OneSignal;
import java.util.Random;

public class GcmBroadcastReceiver
extends WakefulBroadcastReceiver {
    private static final String GCM_RECEIVE_ACTION = "com.google.android.c2dm.intent.RECEIVE";
    private static final String GCM_TYPE = "gcm";
    private static final String MESSAGE_TYPE_EXTRA_KEY = "message_type";

    private static boolean isGcmMessage(Intent intent) {
        if (GCM_RECEIVE_ACTION.equals(intent.getAction())) {
            String messageType = intent.getStringExtra(MESSAGE_TYPE_EXTRA_KEY);
            return messageType == null || GCM_TYPE.equals(messageType);
        }
        return false;
    }

    public void onReceive(Context context, Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null || "google.com/iid".equals(bundle.getString("from"))) {
            return;
        }
        OneSignal.setAppContext(context);
        NotificationBundleProcessor.ProcessedBundleResult processedResult = GcmBroadcastReceiver.processOrderBroadcast(context, intent, bundle);
        if (processedResult == null) {
            this.setSuccessfulResultCode();
            return;
        }
        if (processedResult.isDup || processedResult.hasExtenderService) {
            this.setAbort();
            return;
        }
        if (processedResult.isOneSignalPayload && OneSignal.getFilterOtherGCMReceivers(context)) {
            this.setAbort();
            return;
        }
        this.setSuccessfulResultCode();
    }

    private void setSuccessfulResultCode() {
        if (this.isOrderedBroadcast()) {
            this.setResultCode(-1);
        }
    }

    private void setAbort() {
        if (this.isOrderedBroadcast()) {
            this.abortBroadcast();
            this.setResultCode(-1);
        }
    }

    private static NotificationBundleProcessor.ProcessedBundleResult processOrderBroadcast(Context context, Intent intent, Bundle bundle) {
        if (!GcmBroadcastReceiver.isGcmMessage(intent)) {
            return null;
        }
        NotificationBundleProcessor.ProcessedBundleResult processedResult = NotificationBundleProcessor.processBundleFromReceiver(context, bundle);
        if (processedResult.processed()) {
            return processedResult;
        }
        GcmBroadcastReceiver.startGCMService(context, bundle);
        return processedResult;
    }

    private static void startGCMService(Context context, Bundle bundle) {
        boolean isHighPriority;
        if (!NotificationBundleProcessor.hasRemoteResource(bundle)) {
            BundleCompat taskExtras = GcmBroadcastReceiver.setCompatBundleForServer(bundle, BundleCompatFactory.getInstance());
            NotificationBundleProcessor.ProcessFromGCMIntentService(context, taskExtras, null);
            return;
        }
        boolean bl = isHighPriority = Integer.parseInt(bundle.getString("pri", "0")) > 9;
        if (!isHighPriority && Build.VERSION.SDK_INT >= 26) {
            GcmBroadcastReceiver.startGCMServiceWithJobScheduler(context, bundle);
        } else {
            try {
                GcmBroadcastReceiver.startGCMServiceWithWakefulService(context, bundle);
            }
            catch (IllegalStateException e) {
                if (Build.VERSION.SDK_INT >= 21) {
                    GcmBroadcastReceiver.startGCMServiceWithJobScheduler(context, bundle);
                }
                throw e;
            }
        }
    }

    @TargetApi(value=21)
    private static void startGCMServiceWithJobScheduler(Context context, Bundle bundle) {
        BundleCompat taskExtras = GcmBroadcastReceiver.setCompatBundleForServer(bundle, BundleCompatFactory.getInstance());
        ComponentName componentName = new ComponentName(context.getPackageName(), GcmIntentJobService.class.getName());
        Random random = new Random();
        JobInfo jobInfo = new JobInfo.Builder(random.nextInt(), componentName).setOverrideDeadline(0L).setExtras((PersistableBundle)taskExtras.getBundle()).build();
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        jobScheduler.schedule(jobInfo);
    }

    private static void startGCMServiceWithWakefulService(Context context, Bundle bundle) {
        ComponentName componentName = new ComponentName(context.getPackageName(), GcmIntentService.class.getName());
        BundleCompat taskExtras = GcmBroadcastReceiver.setCompatBundleForServer(bundle, new BundleCompatBundle());
        Intent intentForService = new Intent().replaceExtras((Bundle)taskExtras.getBundle()).setComponent(componentName);
        GcmBroadcastReceiver.startWakefulService((Context)context, (Intent)intentForService);
    }

    private static BundleCompat setCompatBundleForServer(Bundle bundle, BundleCompat taskExtras) {
        taskExtras.putString("json_payload", NotificationBundleProcessor.bundleAsJSONObject(bundle).toString());
        taskExtras.putLong("timestamp", System.currentTimeMillis() / 1000L);
        return taskExtras;
    }
}

