/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.os.Bundle;
import com.onesignal.BackgroundBroadcaster;
import com.onesignal.GenerateNotification;
import com.onesignal.OneSignal;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NotificationBundleProcessor {
    private static final String DEFAULT_ACTION = "__DEFAULT__";

    public static void Process(Context context, Bundle bundle, Class<?> notificationOpenedActivityClass) {
        if (OneSignal.isValidAndNotDuplicated(context, bundle)) {
            boolean isActive = OneSignal.initDone && OneSignal.isForeground();
            NotificationBundleProcessor.prepareBundle(bundle);
            BackgroundBroadcaster.Invoke(context, bundle, isActive);
            if (!bundle.containsKey("alert") || bundle.getString("alert") == null || bundle.getString("alert").equals("")) {
                return;
            }
            if (isActive) {
                final Bundle finalBundle = bundle;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        OneSignal.handleNotificationOpened(finalBundle);
                    }
                }).start();
            } else {
                GenerateNotification.fromBundle(context, bundle, notificationOpenedActivityClass);
            }
        }
    }

    private static void prepareBundle(Bundle gcmBundle) {
        if (gcmBundle.containsKey("o")) {
            try {
                JSONObject customJSON = new JSONObject(gcmBundle.getString("custom"));
                JSONObject additionalDataJSON = customJSON.has("a") ? customJSON.getJSONObject("a") : new JSONObject();
                JSONArray buttons = new JSONArray(gcmBundle.getString("o"));
                gcmBundle.remove("o");
                for (int i = 0; i < buttons.length(); ++i) {
                    String buttonId;
                    JSONObject button = buttons.getJSONObject(i);
                    String buttonText = button.getString("n");
                    button.remove("n");
                    if (button.has("i")) {
                        buttonId = button.getString("i");
                        button.remove("i");
                    } else {
                        buttonId = buttonText;
                    }
                    button.put("id", (Object)buttonId);
                    button.put("text", (Object)buttonText);
                    if (!button.has("p")) continue;
                    button.put("icon", (Object)button.getString("p"));
                    button.remove("p");
                }
                additionalDataJSON.put("actionButtons", (Object)buttons);
                additionalDataJSON.put("actionSelected", (Object)DEFAULT_ACTION);
                if (!customJSON.has("a")) {
                    customJSON.put("a", (Object)additionalDataJSON);
                }
                gcmBundle.putString("custom", customJSON.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}

