/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.rule.dependency;

import com.netflix.nebula.interop.GradleKt;
import com.netflix.nebula.lint.rule.GradleDependency;
import com.netflix.nebula.lint.rule.ModelAwareGradleLintRule;
import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.gradle.api.invocation.Gradle;

public class DeprecatedDependencyConfigurationRule
extends ModelAwareGradleLintRule {
    private String description;
    private final Map CONFIGURATION_REPLACEMENTS;
    private final String MINIMUM_GRADLE_VERSION;
    private final String PROJECT_METHOD_NAME;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public DeprecatedDependencyConfigurationRule() {
        MetaClass metaClass;
        String string;
        String string2;
        Map map;
        String string3;
        this.description = string3 = "Replace deprecated configurations in dependencies";
        this.CONFIGURATION_REPLACEMENTS = map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"compile", "implementation", "testCompile", "testImplementation", "runtime", "runtimeOnly"});
        this.MINIMUM_GRADLE_VERSION = string2 = "4.7";
        this.PROJECT_METHOD_NAME = string = "project";
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public void visitAnyGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        this.handleDependencyVisit(call, conf, dep);
    }

    @Override
    public void visitGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        this.handleDependencyVisit(call, conf, dep);
    }

    @Override
    public void visitSubprojectGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        this.handleDependencyVisit(call, conf, dep);
    }

    @Override
    public void visitAllprojectsGradleDependency(MethodCallExpression call, String conf, GradleDependency dep) {
        this.handleDependencyVisit(call, conf, dep);
    }

    @Override
    public void visitDependencies(MethodCallExpression call) {
        if (!GradleKt.versionLessThan((Gradle)this.getProject().getGradle(), (String)this.MINIMUM_GRADLE_VERSION)) {
            this.handleProjectDependencies(call);
        }
    }

    private void handleProjectDependencies(MethodCallExpression call) {
        public final class _handleProjectDependencies_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _handleProjectDependencies_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("getProperty", "expression", 0, it) instanceof MethodCallExpression;
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _handleProjectDependencies_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite statements = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "flatten", 0, ScriptBytecodeAdapter.getPropertySpreadSafe(DeprecatedDependencyConfigurationRule.class, (Object)ScriptBytecodeAdapter.getPropertySpreadSafe(DeprecatedDependencyConfigurationRule.class, (Object)IndyInterface.bootstrap("getProperty", "expressions", 0, IndyInterface.bootstrap("getProperty", "arguments", 0, call)), (String)"code"), (String)"statements")), new _handleProjectDependencies_closure1(this, this)));
        public final class _handleProjectDependencies_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _handleProjectDependencies_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object statement) {
                CallSite configuration = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "value", 0, IndyInterface.bootstrap("getProperty", "method", 0, IndyInterface.bootstrap("getProperty", "expression", 0, statement))));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, IndyInterface.bootstrap("getProperty", "CONFIGURATION_REPLACEMENTS", 8, this), configuration)) != false) {
                    CallSite statementMethodCallExpression = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "expression", 0, statement));
                    public final class _closure3
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _closure3(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Object it) {
                            return it instanceof MethodCallExpression && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "methodAsString", 0, IndyInterface.bootstrap("cast", "()", 0, it)), (Object)IndyInterface.bootstrap("getProperty", "PROJECT_METHOD_NAME", 8, this));
                        }

                        @Generated
                        public Object doCall() {
                            return this.doCall(null);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _closure3.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }

                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                            return MethodHandles.lookup();
                        }
                    }
                    CallSite projectDependencies = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, IndyInterface.bootstrap("invoke", "flatten", 0, IndyInterface.bootstrap("getProperty", "expressions", 0, IndyInterface.bootstrap("getProperty", "arguments", 0, statementMethodCallExpression))), new _closure3((Object)this, this.getThisObject())));
                    if (IndyInterface.bootstrap("cast", "()", 0, projectDependencies) == false) {
                        return null;
                    }
                    CallSite project = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractProject", 2, this, IndyInterface.bootstrap("invoke", "first", 0, IndyInterface.bootstrap("getProperty", "expressions", 0, IndyInterface.bootstrap("getProperty", "arguments", 0, IndyInterface.bootstrap("invoke", "first", 0, projectDependencies))))));
                    if (IndyInterface.bootstrap("cast", "()", 0, project) == false) {
                        return null;
                    }
                    CallSite configurationReplacement = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "CONFIGURATION_REPLACEMENTS", 8, this), configuration));
                    return IndyInterface.bootstrap("invoke", "addBuildLintViolation", 2, this, new GStringImpl(new Object[]{configuration, configurationReplacement}, new String[]{"Configuration ", " has been deprecated and should be replaced with ", ""}), statementMethodCallExpression);
                }
                return null;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _handleProjectDependencies_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, statements, new _handleProjectDependencies_closure2(this, this));
    }

    private String extractProject(Expression expression) {
        if (expression instanceof ConstantExpression) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "value", 0, expression));
        }
        return IndyInterface.bootstrap("cast", "()", 0, null);
    }

    private void handleDependencyVisit(MethodCallExpression call, String conf, GradleDependency dep) {
        if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "containsKey", 0, this.CONFIGURATION_REPLACEMENTS, conf)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "versionLessThan", 0, GradleKt.class, IndyInterface.bootstrap("getProperty", "gradle", 0, IndyInterface.bootstrap("getProperty", "project", 12, this)), this.MINIMUM_GRADLE_VERSION)) == false) {
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 0, IndyInterface.bootstrap("getProperty", "expressions", 0, IndyInterface.bootstrap("getProperty", "arguments", 0, call))), (Object)1)) {
                IndyInterface.bootstrap("invoke", "replaceSingleLineDependencyConfiguration", 2, this, call, conf, dep);
            } else {
                IndyInterface.bootstrap("invoke", "replaceMultiLineDependencyConfiguration", 2, this, call, conf);
            }
        }
    }

    private void replaceSingleLineDependencyConfiguration(MethodCallExpression call, String conf, GradleDependency dep) {
        CallSite configurationReplacement = IndyInterface.bootstrap("cast", "()", 0, this.CONFIGURATION_REPLACEMENTS.get(conf));
        this.addBuildLintViolation((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{conf, configurationReplacement}, new String[]{"Configuration ", " has been deprecated and should be replaced with ", ""}))), (ASTNode)call);
    }

    private void replaceMultiLineDependencyConfiguration(MethodCallExpression call, String conf) {
        CallSite configurationReplacement = IndyInterface.bootstrap("cast", "()", 0, this.CONFIGURATION_REPLACEMENTS.get(conf));
        this.addBuildLintViolation((String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{conf, configurationReplacement}, new String[]{"Configuration ", " has been deprecated and should be replaced with ", ""}))), (ASTNode)call);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DeprecatedDependencyConfigurationRule.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String string) {
        this.description = string;
    }

    public /* synthetic */ MetaClass super$4$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ void super$3$visitGradleDependency(MethodCallExpression methodCallExpression, String string, GradleDependency gradleDependency) {
        super.visitGradleDependency(methodCallExpression, string, gradleDependency);
    }

    public /* synthetic */ void super$3$visitSubprojectGradleDependency(MethodCallExpression methodCallExpression, String string, GradleDependency gradleDependency) {
        super.visitSubprojectGradleDependency(methodCallExpression, string, gradleDependency);
    }

    public /* synthetic */ void super$3$visitAllprojectsGradleDependency(MethodCallExpression methodCallExpression, String string, GradleDependency gradleDependency) {
        super.visitAllprojectsGradleDependency(methodCallExpression, string, gradleDependency);
    }

    public /* synthetic */ void super$3$visitAnyGradleDependency(MethodCallExpression methodCallExpression, String string, GradleDependency gradleDependency) {
        super.visitAnyGradleDependency(methodCallExpression, string, gradleDependency);
    }

    public /* synthetic */ void super$3$visitDependencies(MethodCallExpression methodCallExpression) {
        super.visitDependencies(methodCallExpression);
    }
}

