/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.org.codenarc.rule.formatting;

import com.netflix.nebula.lint.org.codenarc.rule.AbstractAstVisitor;
import com.netflix.nebula.lint.org.codenarc.rule.Violation;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.regex.Matcher;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class SpaceInsideParenthesesAstVisitor
extends AbstractAstVisitor
implements GroovyObject {
    private static final String MESSAGE_SPACE_AFTER_OPENING_PARENTHESIS = "The opening parenthesis is followed by whitespace";
    private static final String MESSAGE_SPACE_BEFORE_CLOSING_PARENTHESIS = "The closing parenthesis is preceded by whitespace";
    private static final String SINGLE_QUOTE;
    private static final String DOUBLE_QUOTE;
    private static final String FORWARD_SLASH;
    private static final String END_OF_COMMENT = "*/";
    private static final String EMPTY_STRING = "";
    private boolean withinMultilineGString;
    private boolean withinMultilineString;
    private boolean withinMultilineComment;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public SpaceInsideParenthesesAstVisitor() {
        MetaClass metaClass;
        boolean bl;
        boolean bl2;
        boolean bl3;
        this.withinMultilineGString = bl3 = false;
        this.withinMultilineString = bl2 = false;
        this.withinMultilineComment = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    protected void visitClassComplete(ClassNode node) {
        if (ScriptBytecodeAdapter.compareLessThan((Object)IndyInterface.bootstrap("getProperty", "lineNumber", 0, node), (Object)0)) {
            return;
        }
        int firstLine = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("getProperty", "lineNumber", 0, node));
        int lastLine = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("getProperty", "lastLineNumber", 0, node));
        public final class _visitClassComplete_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _visitClassComplete_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object lineNumber) {
                CallSite line = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getLines", 0, IndyInterface.bootstrap("getProperty", "sourceCode", 8, this)), IndyInterface.bootstrap("invoke", "minus", 0, lineNumber, true)));
                return IndyInterface.bootstrap("invoke", "processSourceLine", 2, this, line, lineNumber);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _visitClassComplete_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, ScriptBytecodeAdapter.createRange((Object)firstLine, (Object)lastLine, (boolean)false, (boolean)false), new _visitClassComplete_closure1(this, this));
        ScriptBytecodeAdapter.invokeMethodOnSuperN(SpaceInsideParenthesesAstVisitor.class, (GroovyObject)this, (String)"visitClassComplete", (Object[])new Object[]{node});
    }

    private void processSourceLine(String line, int lineNumber) {
        CallSite text = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "stripComments", 2, this, IndyInterface.bootstrap("invoke", "trim", 0, line)));
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isEmpty", 0, text)) != false) {
            return;
        }
        CallSite countTripleDoubleQuote = IndyInterface.bootstrap("invoke", "count", 0, text, "\"\"\"");
        if (DefaultTypeTransformation.booleanUnbox((Object)countTripleDoubleQuote) || this.withinMultilineGString) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isOdd", 2, this, countTripleDoubleQuote)) != false) {
                boolean bl;
                this.withinMultilineGString = bl = !this.withinMultilineGString;
            }
            return;
        }
        CallSite countTripleSingleQuote = IndyInterface.bootstrap("invoke", "count", 0, text, "'''");
        if (DefaultTypeTransformation.booleanUnbox((Object)countTripleSingleQuote) || this.withinMultilineString) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isOdd", 2, this, countTripleSingleQuote)) != false) {
                boolean bl;
                this.withinMultilineString = bl = !this.withinMultilineString;
            }
            return;
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasSpaceAfterOpeningParenthesis", 2, this, text)) != false) {
            IndyInterface.bootstrap("invoke", "addViolation", 2, this, IndyInterface.bootstrap("init", "<init>", 0, Violation.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"rule", IndyInterface.bootstrap("getProperty", "rule", 12, this), "lineNumber", lineNumber, "sourceLine", text, "message", MESSAGE_SPACE_AFTER_OPENING_PARENTHESIS})));
        }
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasSpaceBeforeClosingParenthesis", 2, this, text)) != false) {
            IndyInterface.bootstrap("invoke", "addViolation", 2, this, IndyInterface.bootstrap("init", "<init>", 0, Violation.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"rule", IndyInterface.bootstrap("getProperty", "rule", 12, this), "lineNumber", lineNumber, "sourceLine", text, "message", MESSAGE_SPACE_BEFORE_CLOSING_PARENTHESIS})));
        }
    }

    private boolean isOdd(int number) {
        return ScriptBytecodeAdapter.compareNotEqual((Object)IndyInterface.bootstrap("invoke", "mod", 0, number, 2), (Object)0);
    }

    private String stripComments(String fullText) {
        CallSite containsEndOfComment = IndyInterface.bootstrap("invoke", "contains", 0, fullText, END_OF_COMMENT);
        if (this.withinMultilineComment && DefaultTypeTransformation.booleanUnbox((Object)containsEndOfComment)) {
            boolean bl;
            this.withinMultilineComment = bl = false;
            return EMPTY_STRING;
        }
        if (this.withinMultilineComment) {
            return EMPTY_STRING;
        }
        Object text = fullText;
        int startCommentIndex = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "startOfCommentIndex", 2, this, text));
        if (startCommentIndex != -1) {
            boolean bl;
            this.withinMultilineComment = bl = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, text, "/*")) && IndyInterface.bootstrap("cast", "()", 0, containsEndOfComment) == false;
            text = IndyInterface.bootstrap("invoke", "substring", 0, text, false, startCommentIndex);
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "contains", 0, text, END_OF_COMMENT)) != false ? EMPTY_STRING : text);
    }

    private boolean hasSpaceAfterOpeningParenthesis(String text) {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "matchesAndNotWithinString", 2, this, text, "\\(\\s+\\S"));
    }

    private boolean hasSpaceBeforeClosingParenthesis(String text) {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "matchesAndNotWithinString", 2, this, text, "\\S\\s+\\)"));
    }

    private boolean matchesAndNotWithinString(String text, String regex) {
        Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)text, (Object)regex);
        if (IndyInterface.bootstrap("cast", "()", 0, matcher) == false) {
            return false;
        }
        CallSite preceding = IndyInterface.bootstrap("invoke", "substring", 0, text, false, IndyInterface.bootstrap("invoke", "start", 0, matcher));
        CallSite following = IndyInterface.bootstrap("invoke", "substring", 0, text, IndyInterface.bootstrap("invoke", "end", 0, matcher));
        Boolean surroundedBySingleQuotes = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, preceding, SINGLE_QUOTE)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, following, SINGLE_QUOTE));
        Boolean surroundedByDoubleQuotes = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, preceding, DOUBLE_QUOTE)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, following, DOUBLE_QUOTE));
        Boolean surroundedByForwardSlashes = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, preceding, FORWARD_SLASH)) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "contains", 0, following, FORWARD_SLASH));
        return IndyInterface.bootstrap("cast", "()", 0, surroundedBySingleQuotes) == false && IndyInterface.bootstrap("cast", "()", 0, surroundedByDoubleQuotes) == false && IndyInterface.bootstrap("cast", "()", 0, surroundedByForwardSlashes) == false;
    }

    private int startOfCommentIndex(String text) {
        int index = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "indexOf", 0, text, "//"));
        if (index != -1) {
            return index;
        }
        return DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "indexOf", 0, text, "/*"));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SpaceInsideParenthesesAstVisitor.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        String string;
        String string2;
        String string3;
        FORWARD_SLASH = string3 = "/";
        DOUBLE_QUOTE = string2 = "\"";
        SINGLE_QUOTE = string = "'";
    }

    public /* synthetic */ void super$4$visitClassComplete(ClassNode classNode) {
        super.visitClassComplete(classNode);
    }
}

