/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.org.codenarc.rule.formatting;

import com.netflix.nebula.lint.org.codenarc.rule.AbstractAstVisitorRule;
import com.netflix.nebula.lint.org.codenarc.rule.Violation;
import com.netflix.nebula.lint.org.codenarc.source.SourceCode;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class LineLengthRule
extends AbstractAstVisitorRule
implements GroovyObject {
    private String name;
    private int priority;
    private int length;
    private boolean ignoreImportStatements;
    private boolean ignorePackageStatements;
    private String ignoreLineRegex;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public LineLengthRule() {
        MetaClass metaClass;
        boolean bl;
        boolean bl2;
        int n;
        int n2;
        String string;
        this.name = string = "LineLength";
        this.priority = n2 = 2;
        this.length = n = 120;
        this.ignoreImportStatements = bl2 = true;
        this.ignorePackageStatements = bl = true;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public void applyTo(SourceCode sourceCode, List<Violation> violations) {
        int lineNumber = 0;
        Object line = null;
        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "iterator", 0, IndyInterface.bootstrap("invoke", "getLines", 0, sourceCode)));
        if (callSite != null) {
            while (callSite.hasNext()) {
                line = callSite.next();
                int n = lineNumber;
                lineNumber = DefaultTypeTransformation.intUnbox((Object)IndyInterface.bootstrap("invoke", "next", 0, n));
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "sourceViolatesLineLengthRule", 2, this, line)) == false) continue;
                IndyInterface.bootstrap("invoke", "leftShift", 0, violations, IndyInterface.bootstrap("invoke", "createViolation", 2, this, lineNumber, line, new GStringImpl(new Object[]{this.length, IndyInterface.bootstrap("invoke", "length", 0, line)}, new String[]{"The line exceeds ", " characters. The line is ", " characters."})));
            }
        }
    }

    private boolean sourceViolatesLineLengthRule(String line) {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "lineExceedsMaxLength", 2, this, line)) && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "lineMatchesIgnoreLineRegex", 2, this, line)) == false && (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "flagIfImport", 2, this, line)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "flagIfPackage", 2, this, line)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "flagIfRegularLine", 2, this, line)));
    }

    private boolean flagIfImport(String line) {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "sourceLineIsImport", 2, this, line)) && !this.ignoreImportStatements;
    }

    private boolean flagIfPackage(String line) {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "sourceLineIsPackage", 2, this, line)) && !this.ignorePackageStatements;
    }

    private boolean flagIfRegularLine(String line) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "sourceLineIsImport", 2, this, line)) == false && IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "sourceLineIsPackage", 2, this, line)) == false;
    }

    private boolean sourceLineIsImport(String line) {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "startsWith", 0, IndyInterface.bootstrap("invoke", "trim", 0, line), "import "));
    }

    private boolean sourceLineIsPackage(String line) {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "startsWith", 0, IndyInterface.bootstrap("invoke", "trim", 0, line), "package "));
    }

    private boolean lineExceedsMaxLength(String line) {
        return ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "length", 0, line), (Object)this.length);
    }

    private boolean lineMatchesIgnoreLineRegex(String line) {
        return ScriptBytecodeAdapter.matchRegex((Object)line, (Object)this.ignoreLineRegex);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != LineLengthRule.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Override
    @Generated
    public void setName(String string) {
        this.name = string;
    }

    @Override
    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Override
    @Generated
    public void setPriority(int n) {
        this.priority = n;
    }

    @Generated
    public int getLength() {
        return this.length;
    }

    @Generated
    public void setLength(int n) {
        this.length = n;
    }

    @Generated
    public boolean getIgnoreImportStatements() {
        return this.ignoreImportStatements;
    }

    @Generated
    public boolean isIgnoreImportStatements() {
        return this.ignoreImportStatements;
    }

    @Generated
    public void setIgnoreImportStatements(boolean bl) {
        this.ignoreImportStatements = bl;
    }

    @Generated
    public boolean getIgnorePackageStatements() {
        return this.ignorePackageStatements;
    }

    @Generated
    public boolean isIgnorePackageStatements() {
        return this.ignorePackageStatements;
    }

    @Generated
    public void setIgnorePackageStatements(boolean bl) {
        this.ignorePackageStatements = bl;
    }

    @Generated
    public String getIgnoreLineRegex() {
        return this.ignoreLineRegex;
    }

    @Generated
    public void setIgnoreLineRegex(String string) {
        this.ignoreLineRegex = string;
    }

    public /* synthetic */ void super$3$applyTo(SourceCode sourceCode, List list) {
        super.applyTo(sourceCode, list);
    }
}

