/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.org.codenarc;

import com.netflix.nebula.lint.org.codenarc.CodeNarcRunner;
import com.netflix.nebula.lint.org.codenarc.analyzer.FilesSourceAnalyzer;
import com.netflix.nebula.lint.org.codenarc.analyzer.FilesystemSourceAnalyzer;
import com.netflix.nebula.lint.org.codenarc.analyzer.SourceAnalyzer;
import com.netflix.nebula.lint.org.codenarc.plugin.baseline.BaselineResultsPlugin;
import com.netflix.nebula.lint.org.codenarc.report.HtmlReportWriter;
import com.netflix.nebula.lint.org.codenarc.report.JsonReportWriter;
import com.netflix.nebula.lint.org.codenarc.report.ReportWriterFactory;
import com.netflix.nebula.lint.org.codenarc.results.Results;
import com.netflix.nebula.lint.org.codenarc.util.CodeNarcVersion;
import com.netflix.nebula.lint.org.codenarc.util.io.DefaultResourceFactory;
import com.netflix.nebula.lint.org.codenarc.util.io.ResourceFactory;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.net.URLDecoder;
import java.util.List;
import java.util.regex.Matcher;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;

public class CodeNarc
implements GroovyObject {
    protected static final String HELP = "CodeNarc - static analysis for Groovy,\nUsage: java org.codenarc.CodeNarc [OPTIONS]\n  where OPTIONS are zero or more command-line options of the form \"-NAME[=VALUE]\":\n    -basedir=<DIR>\n        The base (root) directory for the source code to be analyzed.\n        Defaults to the current directory (\".\").\n    -includes=<PATTERNS>\n        The comma-separated list of Ant-style file patterns specifying files that must\n        be included. Defaults to \"**/*.groovy\".\n    -excludes=<PATTERNS>\n        The comma-separated list of Ant-style file patterns specifying files that must\n        be excluded. No files are excluded when omitted.\n    -sourcefiles=<FILENAMES>\n        The comma-separated list of files we want to analyze. If set, -includes and -exclude arguments are ignored.\n    -rulesetfiles=<FILENAMES>\n        The path to the Groovy or XML RuleSet definition files, relative to the classpath.\n        This can be a single file path, or multiple paths separated by commas. Each path may be optionally prefixed by\n        any of the valid java.net.URL prefixes, such as \"file:\" (to load from a relative or absolute filesystem path),\n        or \"http:\". If it is a URL, its path may be optionally URL-encoded. That can be useful if the path contains\n        any problematic characters, such as comma (',') or hash ('#'). For instance:\n            file:src/test/resources/RuleSet-,#.txt\n        can be encoded as:\n            file:src%2Ftest%2Fresources%2FRuleSet-%2C%23.txt\n        See URLEncoder#encode(java.lang.String, java.lang.String). Defaults to \"rulesets/basic.xml\"\n    -ruleset=JSON_STRING\n        String containing a ruleSet in JSON format (if set, rulesetfiles argument will be ignored)\n        The JSON string must be URL-encoded in UTF-8 before being sent as argument to CodeNarc\n    -excludeBaseline=<FILENAME>\n        The filename of the optional baseline. If not set, no baseline will be used.\n    -maxPriority1Violations=<MAX>\n        The maximum number of priority 1 violations allowed (int).\n    -maxPriority2Violations=<MAX>\n        The maximum number of priority 2 violations allowed (int).\n    -maxPriority3Violations=<MAX>\n        The maximum number of priority 3 violations allowed (int).\n    -failOnError=true/false\n        Whether to terminate and fail the task if any errors occur parsing source files (true), or just log the errors (false). It defaults to false.\n    -title=<REPORT TITLE>\n        The title for this analysis; used in the output report(s), if supported by the report type. Optional.\n    -report=<REPORT-TYPE[:FILENAME|:stdout]>\n        The definition of the report to produce. The option value is of the form\n        TYPE[:FILENAME], where TYPE is \"html\", \"text\", \"xml\", or \"console\" and FILENAME is the filename (with\n        optional path) of the output report filename. If the TYPE is followed by :stdout (e.g. \"html:stdout\", \"json:stdout\"),\n        then the report is written to standard out. If the report filename is  omitted, the default filename\n        is used for the specified report type (\"CodeNarcReport.html\" for \"html\", \"CodeNarcXmlReport.xml\" for\n        \"xml\", \"CodeNarcReport.txt\" for \"text\", \"CodeNarcJsonReport.json\" for \"json\" and\n        \"CodeNarcGitlabCodeQualityReport.json\" for \"gitlab\"). If no report option is specified, default to a\n        single \"html\" report with the default filename.\n    -plugins=<PLUGIN CLASS NAMES>\n        The optional list of CodeNarcPlugin class names to register, separated by commas.\n    -help\n        Display the command-line help. If present, this must be the only command-line parameter.\n  Example command-line invocations:\n    java org.codenarc.CodeNarc\n    java org.codenarc.CodeNarc -rulesetfiles=\"rulesets/basic.xml\" title=\"My Project\"\n    java org.codenarc.CodeNarc -rulesetfiles=\"rulesets/basic.xml\" -report=baseline:codenarc-baseline.xml\n    java org.codenarc.CodeNarc -rulesetfiles=\"rulesets/basic.xml\" -excludeBaseline=file:codenarc-baseline.xml\n    java org.codenarc.CodeNarc -report=xml:MyXmlReport.xml -report=html\n    java org.codenarc.CodeNarc -report=json:stdout\n    java org.codenarc.CodeNarc -help'";
    protected static Closure systemExit;
    protected String ruleSetFiles;
    protected String ruleset;
    protected String baseDir;
    protected String includes;
    protected String excludes;
    protected String sourceFiles;
    protected String title;
    protected String plugins;
    protected String propertiesFilename;
    protected List reports;
    private String excludeBaseline;
    private boolean failOnError;
    private final ResourceFactory resourceFactory;
    protected Closure createCodeNarcRunner;
    protected int maxPriority1Violations;
    protected int maxPriority2Violations;
    protected int maxPriority3Violations;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public CodeNarc() {
        MetaClass metaClass;
        boolean bl;
        List list;
        this.reports = list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.failOnError = bl = false;
        CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, DefaultResourceFactory.class);
        this.resourceFactory = IndyInterface.bootstrap("cast", "()", 0, callSite);
        _closure1 _closure110 = new _closure1(this, this);
        this.createCodeNarcRunner = _closure110;
        CallSite callSite2 = IndyInterface.bootstrap("getProperty", "MAX_VALUE", 0, Integer.class);
        this.maxPriority1Violations = DefaultTypeTransformation.intUnbox((Object)callSite2);
        CallSite callSite3 = IndyInterface.bootstrap("getProperty", "MAX_VALUE", 0, Integer.class);
        this.maxPriority2Violations = DefaultTypeTransformation.intUnbox((Object)callSite3);
        CallSite callSite4 = IndyInterface.bootstrap("getProperty", "MAX_VALUE", 0, Integer.class);
        this.maxPriority3Violations = DefaultTypeTransformation.intUnbox((Object)callSite4);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static void main(String ... args) {
        CallSite codeNarc = IndyInterface.bootstrap("init", "<init>", 0, CodeNarc.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)args, (Object)((String[])IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{"-help"}), String[].class)))) {
            IndyInterface.bootstrap("invoke", "println", 0, CodeNarc.class, HELP);
            return;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)args, (Object)((String[])IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{"-version"}), String[].class)))) {
            CallSite version = IndyInterface.bootstrap("invoke", "getVersion", 0, CodeNarcVersion.class);
            IndyInterface.bootstrap("invoke", "println", 0, CodeNarc.class, new GStringImpl(new Object[]{version}, new String[]{"CodeNarc version ", ""}));
            return;
        }
        try {
            IndyInterface.bootstrap("invoke", "execute", 0, codeNarc, args);
        }
        catch (Throwable t) {
            IndyInterface.bootstrap("invoke", "println", 0, CodeNarc.class, new GStringImpl(new Object[]{t}, new String[]{"ERROR: ", ""}));
            IndyInterface.bootstrap("invoke", "printStackTrace", 0, t);
            IndyInterface.bootstrap("invoke", "println", 0, CodeNarc.class, HELP);
            ScriptBytecodeAdapter.invokeClosure((Object)systemExit, (Object[])new Object[]{1});
        }
    }

    protected void execute(String ... args) {
        IndyInterface.bootstrap("invoke", "parseArgs", 2, this, args);
        IndyInterface.bootstrap("invoke", "setDefaultsIfNecessary", 2, this);
        CallSite sourceAnalyzer = IndyInterface.bootstrap("invoke", "createSourceAnalyzer", 2, this);
        public final class _execute_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _execute_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object reportWriter) {
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "hasProperty", 0, reportWriter, "title")) != false) {
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "title", 8, this);
                    ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)reportWriter, (String)"title");
                    return callSite;
                }
                return null;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _execute_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, this.reports, new _execute_closure2(this, this));
        Object codeNarcRunner = ScriptBytecodeAdapter.invokeClosure((Object)this.createCodeNarcRunner, (Object[])new Object[0]);
        String string = this.ruleSetFiles;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)codeNarcRunner, (String)"ruleSetFiles");
        String string2 = this.ruleset;
        ScriptBytecodeAdapter.setProperty((Object)string2, null, (Object)codeNarcRunner, (String)"ruleSetString");
        List list = this.reports;
        ScriptBytecodeAdapter.setProperty((Object)list, null, (Object)codeNarcRunner, (String)"reportWriters");
        CallSite callSite = sourceAnalyzer;
        ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)codeNarcRunner, (String)"sourceAnalyzer");
        String string3 = this.propertiesFilename;
        ScriptBytecodeAdapter.setProperty((Object)string3, null, (Object)codeNarcRunner, (String)"propertiesFilename");
        if (IndyInterface.bootstrap("cast", "()", 0, this.plugins) != false) {
            IndyInterface.bootstrap("invoke", "registerPluginsForClassNames", 0, codeNarcRunner, this.plugins);
        }
        CallSite results = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "execute", 0, codeNarcRunner));
        IndyInterface.bootstrap("invoke", "checkMaxViolations", 2, this, results, true, this.maxPriority1Violations);
        IndyInterface.bootstrap("invoke", "checkMaxViolations", 2, this, results, 2, this.maxPriority2Violations);
        IndyInterface.bootstrap("invoke", "checkMaxViolations", 2, this, results, 3, this.maxPriority3Violations);
    }

    protected void setDefaultsIfNecessary() {
        String string;
        String string2;
        String string3;
        if (IndyInterface.bootstrap("cast", "()", 0, this.sourceFiles) == false) {
            String string4;
            String string5 = this.includes;
            this.includes = string4 = IndyInterface.bootstrap("cast", "()", 0, string5) != false ? string5 : "**/*.groovy";
        }
        this.baseDir = string3 = IndyInterface.bootstrap("cast", "()", 0, string2 = this.baseDir) != false ? string2 : ".";
        String string6 = this.ruleSetFiles;
        this.ruleSetFiles = string = IndyInterface.bootstrap("cast", "()", 0, string6) != false ? string6 : "rulesets/basic.xml";
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "empty", 0, this.reports)) != false) {
            IndyInterface.bootstrap("invoke", "leftShift", 0, this.reports, IndyInterface.bootstrap("init", "<init>", 0, HtmlReportWriter.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"title", this.title})));
        }
    }

    protected void checkMaxViolations(Results results, int priority, int max) {
        CallSite numViolations = IndyInterface.bootstrap("invoke", "getNumberOfViolationsWithPriority", 0, results, priority, true);
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)numViolations, (Object)max)) {
            IndyInterface.bootstrap("invoke", "println", 2, this, new GStringImpl(new Object[]{priority, max}, new String[]{"ERROR: Number of p", " violations greater than maximum of ", ""}));
            ScriptBytecodeAdapter.invokeClosure((Object)systemExit, (Object[])new Object[]{1});
        }
    }

    protected SourceAnalyzer createSourceAnalyzer() {
        if (IndyInterface.bootstrap("cast", "()", 0, this.sourceFiles) != false) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, FilesSourceAnalyzer.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"baseDirectory", this.baseDir, "sourceFiles", IndyInterface.bootstrap("invoke", "split", 0, this.sourceFiles, ","), "failOnError", this.failOnError})));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, FilesystemSourceAnalyzer.class, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"baseDirectory", this.baseDir, "includes", this.includes, "excludes", this.excludes, "failOnError", this.failOnError})));
    }

    protected void parseArgs(String ... args) {
        public final class _parseArgs_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _parseArgs_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object arg) {
                String pattern = "\\-(.*)\\=(.*)";
                Matcher matcher = ScriptBytecodeAdapter.findRegex((Object)arg, (Object)pattern);
                if (IndyInterface.bootstrap("cast", "()", 0, matcher) == false) {
                    StringBuilder stringBuilder = new StringBuilder("matcher. Values: ");
                    stringBuilder.append((Object)"matcher = ");
                    stringBuilder.append(InvokerHelper.toString((Object)matcher));
                    throw InvokerHelper.createAssertError((Object)stringBuilder, (Object)new GStringImpl(new Object[]{arg}, new String[]{"Invalid argument format: [", "]"}));
                }
                CallSite name = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAt", 0, matcher, false), true);
                CallSite value = IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("invoke", "getAt", 0, matcher, false), 2);
                CallSite callSite = name;
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"rulesetfiles")) {
                    CallSite callSite2 = value;
                    ScriptBytecodeAdapter.setProperty((Object)callSite2, null, (Object)((Object)this), (String)"ruleSetFiles");
                    return callSite2;
                }
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"ruleset")) {
                    CallSite callSite3 = IndyInterface.bootstrap("invoke", "decode", 0, URLDecoder.class, value, "UTF-8");
                    ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)((Object)this), (String)"ruleset");
                    return callSite3;
                }
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"excludeBaseline")) {
                    CallSite callSite4 = value;
                    ScriptBytecodeAdapter.setProperty((Object)callSite4, null, (Object)((Object)this), (String)"excludeBaseline");
                    return callSite4;
                }
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"basedir")) {
                    CallSite callSite5 = value;
                    ScriptBytecodeAdapter.setProperty((Object)callSite5, null, (Object)((Object)this), (String)"baseDir");
                    return callSite5;
                }
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"includes")) {
                    CallSite callSite6 = value;
                    ScriptBytecodeAdapter.setProperty((Object)callSite6, null, (Object)((Object)this), (String)"includes");
                    return callSite6;
                }
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"excludes")) {
                    CallSite callSite7 = value;
                    ScriptBytecodeAdapter.setProperty((Object)callSite7, null, (Object)((Object)this), (String)"excludes");
                    return callSite7;
                }
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"sourcefiles")) {
                    CallSite callSite8 = value;
                    ScriptBytecodeAdapter.setProperty((Object)callSite8, null, (Object)((Object)this), (String)"sourceFiles");
                    return callSite8;
                }
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"title")) {
                    CallSite callSite9 = value;
                    ScriptBytecodeAdapter.setProperty((Object)callSite9, null, (Object)((Object)this), (String)"title");
                    return callSite9;
                }
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"report")) {
                    return IndyInterface.bootstrap("invoke", "parseReport", 2, this, value);
                }
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"maxPriority1Violations")) {
                    int n = (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, value, Integer.class));
                    ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)((Object)this), (String)"maxPriority1Violations");
                    return n;
                }
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"maxPriority2Violations")) {
                    int n = (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, value, Integer.class));
                    ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)((Object)this), (String)"maxPriority2Violations");
                    return n;
                }
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"maxPriority3Violations")) {
                    int n = (Integer)((Object)IndyInterface.bootstrap("invoke", "asType", 0, value, Integer.class));
                    ScriptBytecodeAdapter.setProperty((Object)n, null, (Object)((Object)this), (String)"maxPriority3Violations");
                    return n;
                }
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"plugins")) {
                    CallSite callSite10 = value;
                    ScriptBytecodeAdapter.setProperty((Object)callSite10, null, (Object)((Object)this), (String)"plugins");
                    return callSite10;
                }
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"properties")) {
                    CallSite callSite11 = value;
                    ScriptBytecodeAdapter.setProperty((Object)callSite11, null, (Object)((Object)this), (String)"propertiesFilename");
                    return callSite11;
                }
                if (ScriptBytecodeAdapter.isCase((Object)callSite, (Object)"failOnError")) {
                    CallSite callSite12 = IndyInterface.bootstrap("invoke", "parseBoolean", 0, Boolean.class, value);
                    ScriptBytecodeAdapter.setProperty((Object)callSite12, null, (Object)((Object)this), (String)"failOnError");
                    return callSite12;
                }
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, new GStringImpl(new Object[]{arg}, new String[]{"Invalid option: [", "]"})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _parseArgs_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 0, args, new _parseArgs_closure3(this, this));
    }

    private void parseReport(String argValue) {
        CallSite parts = IndyInterface.bootstrap("invoke", "split", 0, argValue, ":", 2);
        CallSite type = IndyInterface.bootstrap("invoke", "getAt", 0, parts, false);
        CallSite reportWriter = IndyInterface.bootstrap("invoke", "getReportWriter", 0, IndyInterface.bootstrap("init", "<init>", 0, ReportWriterFactory.class), type);
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)IndyInterface.bootstrap("invoke", "size", 0, parts), (Object)1) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "getAt", 0, parts, true))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, parts, true), (Object)"stdout")) {
                boolean bl = true;
                ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)reportWriter, (String)"writeToStandardOut");
                if (reportWriter instanceof JsonReportWriter) {
                    boolean bl2 = true;
                    ScriptBytecodeAdapter.setProperty((Object)bl2, null, (Object)reportWriter, (String)"writeAsSingleLine");
                }
            } else {
                CallSite callSite = IndyInterface.bootstrap("invoke", "getAt", 0, parts, true);
                ScriptBytecodeAdapter.setProperty((Object)callSite, null, (Object)reportWriter, (String)"outputFile");
            }
        }
        IndyInterface.bootstrap("invoke", "leftShift", 0, this.reports, reportWriter);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != CodeNarc.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        public final class __clinit__closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public __clinit__closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object exitCode) {
                return IndyInterface.bootstrap("invoke", "exit", 0, System.class, exitCode);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != __clinit__closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        __clinit__closure4 __clinit__closure42 = new __clinit__closure4(CodeNarc.class, CodeNarc.class);
        systemExit = __clinit__closure42;
    }

    @Generated
    public String getExcludeBaseline() {
        return this.excludeBaseline;
    }

    @Generated
    public void setExcludeBaseline(String string) {
        this.excludeBaseline = string;
    }

    @Generated
    public boolean getFailOnError() {
        return this.failOnError;
    }

    @Generated
    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Generated
    public void setFailOnError(boolean bl) {
        this.failOnError = bl;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public Object doCall(Object it) {
            CallSite codeNarcRunner = IndyInterface.bootstrap("init", "<init>", 0, CodeNarcRunner.class);
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "excludeBaseline", 8, this)) != false) {
                IndyInterface.bootstrap("invoke", "println", 2, this, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "excludeBaseline", 8, this)}, new String[]{"Loading baseline violations from [", "]"}));
                CallSite resource = IndyInterface.bootstrap("invoke", "getResource", 0, IndyInterface.bootstrap("getProperty", "resourceFactory", 8, this), IndyInterface.bootstrap("getProperty", "excludeBaseline", 8, this));
                CallSite baselinePlugin = IndyInterface.bootstrap("init", "<init>", 0, BaselineResultsPlugin.class, resource);
                IndyInterface.bootstrap("invoke", "registerPlugin", 0, codeNarcRunner, baselinePlugin);
            }
            return codeNarcRunner;
        }

        @Generated
        public Object doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MethodHandles.Lookup $getLookup() {
            return MethodHandles.lookup();
        }
    }
}

