/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.transport;

import com.netflix.nebula.lint.jgit.transport.AdvertiseRefsHook;
import com.netflix.nebula.lint.jgit.transport.BaseReceivePack;
import com.netflix.nebula.lint.jgit.transport.ServiceMayNotContinueException;
import com.netflix.nebula.lint.jgit.transport.UploadPack;
import java.util.List;

public class AdvertiseRefsHookChain
implements AdvertiseRefsHook {
    private final AdvertiseRefsHook[] hooks;
    private final int count;

    public static AdvertiseRefsHook newChain(List<? extends AdvertiseRefsHook> hooks) {
        AdvertiseRefsHook[] newHooks = new AdvertiseRefsHook[hooks.size()];
        int i = 0;
        for (AdvertiseRefsHook advertiseRefsHook : hooks) {
            if (advertiseRefsHook == AdvertiseRefsHook.DEFAULT) continue;
            newHooks[i++] = advertiseRefsHook;
        }
        if (i == 0) {
            return AdvertiseRefsHook.DEFAULT;
        }
        if (i == 1) {
            return newHooks[0];
        }
        return new AdvertiseRefsHookChain(newHooks, i);
    }

    @Override
    public void advertiseRefs(BaseReceivePack rp) throws ServiceMayNotContinueException {
        int i = 0;
        while (i < this.count) {
            this.hooks[i].advertiseRefs(rp);
            ++i;
        }
    }

    @Override
    public void advertiseRefs(UploadPack rp) throws ServiceMayNotContinueException {
        int i = 0;
        while (i < this.count) {
            this.hooks[i].advertiseRefs(rp);
            ++i;
        }
    }

    private AdvertiseRefsHookChain(AdvertiseRefsHook[] hooks, int count) {
        this.hooks = hooks;
        this.count = count;
    }
}

