/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.revwalk.filter;

import com.netflix.nebula.lint.jgit.internal.JGitText;
import com.netflix.nebula.lint.jgit.revwalk.RevCommit;
import com.netflix.nebula.lint.jgit.revwalk.filter.PatternMatchRevFilter;
import com.netflix.nebula.lint.jgit.revwalk.filter.RevFilter;
import com.netflix.nebula.lint.jgit.revwalk.filter.SubStringRevFilter;
import com.netflix.nebula.lint.jgit.util.RawCharSequence;
import com.netflix.nebula.lint.jgit.util.RawParseUtils;

public class AuthorRevFilter {
    public static RevFilter create(String pattern) {
        if (pattern.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        if (SubStringRevFilter.safe(pattern)) {
            return new SubStringSearch(pattern);
        }
        return new PatternSearch(pattern);
    }

    private AuthorRevFilter() {
    }

    static RawCharSequence textFor(RevCommit cmit) {
        byte[] raw = cmit.getRawBuffer();
        int b = RawParseUtils.author(raw, 0);
        if (b < 0) {
            return RawCharSequence.EMPTY;
        }
        int e = RawParseUtils.nextLF(raw, b, '>');
        return new RawCharSequence(raw, b, e);
    }

    private static class PatternSearch
    extends PatternMatchRevFilter {
        PatternSearch(String patternText) {
            super(patternText, true, true, 2);
        }

        @Override
        protected CharSequence text(RevCommit cmit) {
            return AuthorRevFilter.textFor(cmit);
        }

        @Override
        public RevFilter clone() {
            return new PatternSearch(this.pattern());
        }
    }

    private static class SubStringSearch
    extends SubStringRevFilter {
        SubStringSearch(String patternText) {
            super(patternText);
        }

        @Override
        protected RawCharSequence text(RevCommit cmit) {
            return AuthorRevFilter.textFor(cmit);
        }
    }
}

