/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jgit.internal.storage.dfs;

import com.netflix.nebula.lint.jgit.internal.storage.dfs.DfsPackFile;
import com.netflix.nebula.lint.jgit.internal.storage.pack.StoredObjectRepresentation;
import com.netflix.nebula.lint.jgit.lib.ObjectId;

class DfsObjectRepresentation
extends StoredObjectRepresentation {
    final DfsPackFile pack;
    int format;
    long offset;
    long length;
    ObjectId baseId;

    DfsObjectRepresentation(DfsPackFile pack) {
        this.pack = pack;
    }

    @Override
    public int getFormat() {
        return this.format;
    }

    @Override
    public int getWeight() {
        return (int)Math.min(this.length, Integer.MAX_VALUE);
    }

    @Override
    public ObjectId getDeltaBase() {
        return this.baseId;
    }

    @Override
    public boolean wasDeltaAttempted() {
        switch (this.pack.getPackDescription().getPackSource()) {
            case GC: 
            case GC_REST: 
            case GC_TXN: {
                return true;
            }
        }
        return false;
    }
}

