/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.eval;

import com.netflix.nebula.lint.jdt.internal.compiler.ast.Assignment;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.BinaryExpression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.CompoundAssignment;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.IntLiteral;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.SingleNameReference;
import com.netflix.nebula.lint.jdt.internal.compiler.codegen.CodeStream;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowContext;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.impl.CompilerOptions;
import com.netflix.nebula.lint.jdt.internal.compiler.impl.Constant;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ClassScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.FieldBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.InvocationSite;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.LocalVariableBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.MethodBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ParameterizedFieldBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ProblemBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ProblemFieldBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ProblemReasons;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ReferenceBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.Scope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding;
import com.netflix.nebula.lint.jdt.internal.eval.CodeSnippetScope;
import com.netflix.nebula.lint.jdt.internal.eval.EvaluationConstants;
import com.netflix.nebula.lint.jdt.internal.eval.EvaluationContext;

public class CodeSnippetSingleNameReference
extends SingleNameReference
implements EvaluationConstants,
InvocationSite,
ProblemReasons {
    EvaluationContext evaluationContext;
    FieldBinding delegateThis;

    public CodeSnippetSingleNameReference(char[] source, long pos, EvaluationContext evaluationContext) {
        super(source, pos);
        this.evaluationContext = evaluationContext;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, boolean valueRequired) {
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding = (FieldBinding)this.binding;
                if (!fieldBinding.isBlankFinal() || !currentScope.allowBlankFinalFieldAssignment(fieldBinding) || flowInfo.isDefinitelyAssigned(fieldBinding)) break;
                currentScope.problemReporter().uninitializedBlankFinalField(fieldBinding, this);
                break;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.binding;
                if (!flowInfo.isDefinitelyAssigned(localBinding)) {
                    currentScope.problemReporter().uninitializedLocalVariable(localBinding, this);
                }
                if ((flowInfo.tagBits & 1) == 0) {
                    localBinding.useFlag = 1;
                    break;
                }
                if (localBinding.useFlag != 0) break;
                localBinding.useFlag = 2;
            }
        }
        return flowInfo;
    }

    public TypeBinding checkFieldAccess(BlockScope scope) {
        if (this.delegateThis == null) {
            return super.checkFieldAccess(scope);
        }
        FieldBinding fieldBinding = (FieldBinding)this.binding;
        this.bits &= 0xFFFFFFF8;
        this.bits |= 1;
        if (!fieldBinding.isStatic() && this.evaluationContext.isStatic) {
            scope.problemReporter().staticFieldAccessToNonStaticVariable(this, fieldBinding);
            this.constant = Constant.NotAConstant;
            return null;
        }
        this.constant = fieldBinding.constant();
        if (this.isFieldUseDeprecated(fieldBinding, scope, (this.bits & 0x2000) != 0)) {
            scope.problemReporter().deprecatedField(fieldBinding, this);
        }
        return fieldBinding.type;
    }

    public void generateAssignment(BlockScope currentScope, CodeStream codeStream, Assignment assignment, boolean valueRequired) {
        if (assignment.expression.isCompactableOperation()) {
            SingleNameReference variableReference;
            BinaryExpression operation = (BinaryExpression)assignment.expression;
            int operator = (operation.bits & 0xFC0) >> 6;
            if (operation.left instanceof SingleNameReference) {
                variableReference = (SingleNameReference)operation.left;
                if (variableReference.binding == this.binding) {
                    variableReference.generateCompoundAssignment(currentScope, codeStream, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], operation.right, operator, operation.implicitConversion, valueRequired);
                    if (valueRequired) {
                        codeStream.generateImplicitConversion(assignment.implicitConversion);
                    }
                    return;
                }
            }
            if (operation.right instanceof SingleNameReference && (operator == 14 || operator == 15)) {
                variableReference = (SingleNameReference)operation.right;
                if (variableReference.binding == this.binding && operation.left.constant != Constant.NotAConstant && (operation.left.implicitConversion & 0xFF) >> 4 != 11 && (operation.right.implicitConversion & 0xFF) >> 4 != 11) {
                    variableReference.generateCompoundAssignment(currentScope, codeStream, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], operation.left, operator, operation.implicitConversion, valueRequired);
                    if (valueRequired) {
                        codeStream.generateImplicitConversion(assignment.implicitConversion);
                    }
                    return;
                }
            }
        }
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding = (FieldBinding)this.codegenBinding;
                if (fieldBinding.canBeSeenBy(this.getReceiverType(currentScope), this, currentScope)) {
                    if (!fieldBinding.isStatic()) {
                        if ((this.bits & 0x1FE0) != 0) {
                            ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                            Object[] emulationPath = currentScope.getEmulationPath(targetType, true, false);
                            codeStream.generateOuterAccess(emulationPath, this, targetType, currentScope);
                        } else {
                            this.generateReceiver(codeStream);
                        }
                    }
                    assignment.expression.generateCode(currentScope, codeStream, true);
                    this.fieldStore(codeStream, fieldBinding, null, valueRequired);
                    if (valueRequired) {
                        codeStream.generateImplicitConversion(assignment.implicitConversion);
                    }
                } else {
                    codeStream.generateEmulationForField(fieldBinding);
                    if (!fieldBinding.isStatic()) {
                        if ((this.bits & 0x1FE0) != 0) {
                            currentScope.problemReporter().needImplementation();
                        } else {
                            this.generateReceiver(codeStream);
                        }
                    } else {
                        codeStream.aconst_null();
                    }
                    assignment.expression.generateCode(currentScope, codeStream, true);
                    if (valueRequired) {
                        if (fieldBinding.type == TypeBinding.LONG || fieldBinding.type == TypeBinding.DOUBLE) {
                            codeStream.dup2_x2();
                        } else {
                            codeStream.dup_x2();
                        }
                    }
                    codeStream.generateEmulatedWriteAccessForField(fieldBinding);
                    if (valueRequired) {
                        codeStream.generateImplicitConversion(assignment.implicitConversion);
                    }
                }
                return;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.codegenBinding;
                if (localBinding.resolvedPosition == -1) {
                    if (assignment.expression.constant != Constant.NotAConstant) {
                        if (valueRequired) {
                            codeStream.generateConstant(assignment.expression.constant, assignment.implicitConversion);
                        }
                    } else {
                        assignment.expression.generateCode(currentScope, codeStream, true);
                        if (valueRequired) {
                            codeStream.generateImplicitConversion(assignment.implicitConversion);
                        } else if (localBinding.type == TypeBinding.LONG || localBinding.type == TypeBinding.DOUBLE) {
                            codeStream.pop2();
                        } else {
                            codeStream.pop();
                        }
                    }
                    return;
                }
                assignment.expression.generateCode(currentScope, codeStream, true);
                codeStream.store(localBinding, valueRequired);
                if ((this.bits & 8) != 0) {
                    localBinding.recordInitializationStartPC(codeStream.position);
                }
                if (!valueRequired) break;
                codeStream.generateImplicitConversion(assignment.implicitConversion);
            }
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (this.constant != Constant.NotAConstant) {
            if (valueRequired) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
        } else {
            switch (this.bits & 7) {
                case 1: {
                    if (!valueRequired) break;
                    FieldBinding fieldBinding = (FieldBinding)this.codegenBinding;
                    Constant fieldConstant = fieldBinding.constant();
                    if (fieldConstant == Constant.NotAConstant) {
                        if (fieldBinding.canBeSeenBy(this.getReceiverType(currentScope), this, currentScope)) {
                            boolean isStatic = fieldBinding.isStatic();
                            if (!isStatic) {
                                if ((this.bits & 0x1FE0) != 0) {
                                    ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                                    Object[] emulationPath = currentScope.getEmulationPath(targetType, true, false);
                                    codeStream.generateOuterAccess(emulationPath, this, targetType, currentScope);
                                } else {
                                    this.generateReceiver(codeStream);
                                }
                            }
                            if (isStatic) {
                                codeStream.getstatic(fieldBinding);
                            } else {
                                codeStream.getfield(fieldBinding);
                            }
                        } else {
                            if (!fieldBinding.isStatic()) {
                                if ((this.bits & 0x1FE0) != 0) {
                                    currentScope.problemReporter().needImplementation();
                                } else {
                                    this.generateReceiver(codeStream);
                                }
                            } else {
                                codeStream.aconst_null();
                            }
                            codeStream.generateEmulatedReadAccessForField(fieldBinding);
                        }
                        if (this.genericCast != null) {
                            codeStream.checkcast(this.genericCast);
                        }
                        codeStream.generateImplicitConversion(this.implicitConversion);
                        break;
                    }
                    codeStream.generateConstant(fieldConstant, this.implicitConversion);
                    break;
                }
                case 2: {
                    LocalVariableBinding localBinding = (LocalVariableBinding)this.codegenBinding;
                    if (!valueRequired) break;
                    if ((this.bits & 0x1FE0) != 0) {
                        Object[] path = currentScope.getEmulationPath(localBinding);
                        codeStream.generateOuterAccess(path, this, localBinding, currentScope);
                    } else {
                        codeStream.load(localBinding);
                    }
                    codeStream.generateImplicitConversion(this.implicitConversion);
                }
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateCompoundAssignment(BlockScope currentScope, CodeStream codeStream, MethodBinding writeAccessor, Expression expression, int operator, int assignmentImplicitConversion, boolean valueRequired) {
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding = (FieldBinding)this.codegenBinding;
                if (fieldBinding.isStatic()) {
                    if (fieldBinding.canBeSeenBy(this.getReceiverType(currentScope), this, currentScope)) {
                        codeStream.getstatic(fieldBinding);
                        break;
                    }
                    codeStream.generateEmulationForField(fieldBinding);
                    codeStream.aconst_null();
                    codeStream.aconst_null();
                    codeStream.generateEmulatedReadAccessForField(fieldBinding);
                    break;
                }
                if (fieldBinding.canBeSeenBy(this.getReceiverType(currentScope), this, currentScope)) {
                    if ((this.bits & 0x1FE0) != 0) {
                        ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                        Object[] emulationPath = currentScope.getEmulationPath(targetType, true, false);
                        codeStream.generateOuterAccess(emulationPath, this, targetType, currentScope);
                    } else {
                        this.generateReceiver(codeStream);
                    }
                    codeStream.dup();
                    codeStream.getfield(fieldBinding);
                    break;
                }
                if ((this.bits & 0x1FE0) != 0) {
                    currentScope.problemReporter().needImplementation();
                }
                codeStream.generateEmulationForField(fieldBinding);
                this.generateReceiver(codeStream);
                codeStream.dup();
                codeStream.generateEmulatedReadAccessForField(fieldBinding);
                break;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.codegenBinding;
                switch (localBinding.type.id) {
                    case 11: {
                        codeStream.generateStringConcatenationAppend(currentScope, this, expression);
                        if (valueRequired) {
                            codeStream.dup();
                        }
                        codeStream.store(localBinding, false);
                        return;
                    }
                    case 10: {
                        int increment;
                        Constant assignConstant = expression.constant;
                        if (assignConstant == Constant.NotAConstant || assignConstant.typeID() == 9 || assignConstant.typeID() == 8 || (increment = assignConstant.intValue()) != (short)increment) break;
                        switch (operator) {
                            case 14: {
                                codeStream.iinc(localBinding.resolvedPosition, increment);
                                if (valueRequired) {
                                    codeStream.load(localBinding);
                                }
                                return;
                            }
                            case 13: {
                                codeStream.iinc(localBinding.resolvedPosition, -increment);
                                if (valueRequired) {
                                    codeStream.load(localBinding);
                                }
                                return;
                            }
                        }
                    }
                }
                codeStream.load(localBinding);
            }
        }
        int operationTypeID = (this.implicitConversion & 0xFF) >> 4;
        switch (operationTypeID) {
            case 0: 
            case 1: 
            case 11: {
                codeStream.generateStringConcatenationAppend(currentScope, null, expression);
                break;
            }
            default: {
                codeStream.generateImplicitConversion(this.implicitConversion);
                if (expression == IntLiteral.One) {
                    codeStream.generateConstant(expression.constant, this.implicitConversion);
                } else {
                    expression.generateCode(currentScope, codeStream, true);
                }
                codeStream.sendOperator(operator, operationTypeID);
                codeStream.generateImplicitConversion(assignmentImplicitConversion);
            }
        }
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding = (FieldBinding)this.codegenBinding;
                if (fieldBinding.canBeSeenBy(this.getReceiverType(currentScope), this, currentScope)) {
                    this.fieldStore(codeStream, fieldBinding, writeAccessor, valueRequired);
                } else {
                    if (valueRequired) {
                        if (fieldBinding.type == TypeBinding.LONG || fieldBinding.type == TypeBinding.DOUBLE) {
                            codeStream.dup2_x2();
                        } else {
                            codeStream.dup_x2();
                        }
                    }
                    codeStream.generateEmulatedWriteAccessForField(fieldBinding);
                }
                return;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.codegenBinding;
                if (valueRequired) {
                    if (localBinding.type == TypeBinding.LONG || localBinding.type == TypeBinding.DOUBLE) {
                        codeStream.dup2();
                    } else {
                        codeStream.dup();
                    }
                }
                codeStream.store(localBinding, false);
            }
        }
    }

    public void generatePostIncrement(BlockScope currentScope, CodeStream codeStream, CompoundAssignment postIncrement, boolean valueRequired) {
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding = (FieldBinding)this.codegenBinding;
                if (fieldBinding.canBeSeenBy(this.getReceiverType(currentScope), this, currentScope)) {
                    if (fieldBinding.isStatic()) {
                        codeStream.getstatic(fieldBinding);
                    } else {
                        if ((this.bits & 0x1FE0) != 0) {
                            ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                            Object[] emulationPath = currentScope.getEmulationPath(targetType, true, false);
                            codeStream.generateOuterAccess(emulationPath, this, targetType, currentScope);
                        } else {
                            this.generateReceiver(codeStream);
                        }
                        codeStream.dup();
                        codeStream.getfield(fieldBinding);
                    }
                    if (valueRequired) {
                        if (fieldBinding.isStatic()) {
                            if (fieldBinding.type == TypeBinding.LONG || fieldBinding.type == TypeBinding.DOUBLE) {
                                codeStream.dup2();
                            } else {
                                codeStream.dup();
                            }
                        } else if (fieldBinding.type == TypeBinding.LONG || fieldBinding.type == TypeBinding.DOUBLE) {
                            codeStream.dup2_x1();
                        } else {
                            codeStream.dup_x1();
                        }
                    }
                    codeStream.generateConstant(postIncrement.expression.constant, this.implicitConversion);
                    codeStream.sendOperator(postIncrement.operator, fieldBinding.type.id);
                    codeStream.generateImplicitConversion(postIncrement.preAssignImplicitConversion);
                    this.fieldStore(codeStream, fieldBinding, null, false);
                } else {
                    if (fieldBinding.isStatic()) {
                        codeStream.aconst_null();
                    } else if ((this.bits & 0x1FE0) != 0) {
                        currentScope.problemReporter().needImplementation();
                    } else {
                        this.generateReceiver(codeStream);
                    }
                    codeStream.generateEmulatedReadAccessForField(fieldBinding);
                    if (valueRequired) {
                        if (fieldBinding.type == TypeBinding.LONG || fieldBinding.type == TypeBinding.DOUBLE) {
                            codeStream.dup2();
                        } else {
                            codeStream.dup();
                        }
                    }
                    codeStream.generateEmulationForField(fieldBinding);
                    if (fieldBinding.type == TypeBinding.LONG || fieldBinding.type == TypeBinding.DOUBLE) {
                        codeStream.dup_x2();
                        codeStream.pop();
                        if (fieldBinding.isStatic()) {
                            codeStream.aconst_null();
                        } else {
                            this.generateReceiver(codeStream);
                        }
                        codeStream.dup_x2();
                        codeStream.pop();
                    } else {
                        codeStream.dup_x1();
                        codeStream.pop();
                        if (fieldBinding.isStatic()) {
                            codeStream.aconst_null();
                        } else {
                            this.generateReceiver(codeStream);
                        }
                        codeStream.dup_x1();
                        codeStream.pop();
                    }
                    codeStream.generateConstant(postIncrement.expression.constant, this.implicitConversion);
                    codeStream.sendOperator(postIncrement.operator, fieldBinding.type.id);
                    codeStream.generateImplicitConversion(postIncrement.preAssignImplicitConversion);
                    codeStream.generateEmulatedWriteAccessForField(fieldBinding);
                }
                return;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.codegenBinding;
                if (localBinding.type == TypeBinding.INT) {
                    if (valueRequired) {
                        codeStream.load(localBinding);
                    }
                    if (postIncrement.operator == 14) {
                        codeStream.iinc(localBinding.resolvedPosition, 1);
                        break;
                    }
                    codeStream.iinc(localBinding.resolvedPosition, -1);
                    break;
                }
                codeStream.load(localBinding);
                if (valueRequired) {
                    if (localBinding.type == TypeBinding.LONG || localBinding.type == TypeBinding.DOUBLE) {
                        codeStream.dup2();
                    } else {
                        codeStream.dup();
                    }
                }
                codeStream.generateConstant(postIncrement.expression.constant, this.implicitConversion);
                codeStream.sendOperator(postIncrement.operator, localBinding.type.id);
                codeStream.generateImplicitConversion(postIncrement.preAssignImplicitConversion);
                codeStream.store(localBinding, false);
            }
        }
    }

    public void generateReceiver(CodeStream codeStream) {
        codeStream.aload_0();
        if (this.delegateThis != null) {
            codeStream.getfield(this.delegateThis);
        }
    }

    public TypeBinding getReceiverType(BlockScope currentScope) {
        Scope scope = currentScope.parent;
        while (true) {
            switch (scope.kind) {
                case 3: {
                    return ((ClassScope)scope).referenceContext.binding;
                }
            }
            scope = scope.parent;
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo, boolean isReadAccess) {
        if (this.delegateThis == null) {
            super.manageSyntheticAccessIfNecessary(currentScope, flowInfo, isReadAccess);
            return;
        }
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        if (this.constant != Constant.NotAConstant) {
            return;
        }
        if (this.binding instanceof ParameterizedFieldBinding) {
            ParameterizedFieldBinding parameterizedField = (ParameterizedFieldBinding)this.binding;
            this.codegenBinding = parameterizedField.originalField;
            FieldBinding fieldCodegenBinding = (FieldBinding)this.codegenBinding;
            if ((fieldCodegenBinding.type.tagBits & 0x20000000L) != 0L) {
                this.genericCast = fieldCodegenBinding.type.genericCast(currentScope.boxing(parameterizedField.type));
            }
        }
        if ((this.bits & 1) != 0) {
            FieldBinding fieldBinding = (FieldBinding)this.binding;
            if (fieldBinding.declaringClass != this.delegateThis.type && fieldBinding.declaringClass != null && fieldBinding.constant() == Constant.NotAConstant) {
                CompilerOptions options = currentScope.compilerOptions();
                if (options.targetJDK >= 0x2E0000L && (options.complianceLevel >= 0x300000L || !fieldBinding.isStatic()) && fieldBinding.declaringClass.id != 1 || !fieldBinding.declaringClass.canBeSeenBy(currentScope)) {
                    this.codegenBinding = currentScope.enclosingSourceType().getUpdatedFieldBinding((FieldBinding)this.codegenBinding, (ReferenceBinding)this.delegateThis.type.erasure());
                }
            }
        }
    }

    public TypeBinding reportError(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        if (this.binding instanceof ProblemFieldBinding && ((ProblemFieldBinding)this.binding).problemId() == 1 && this.evaluationContext.declaringTypeName != null) {
            this.delegateThis = scope.getField(scope.enclosingSourceType(), DELEGATE_THIS, this);
            if (this.delegateThis != null) {
                this.codegenBinding = this.binding = scope.getField(this.delegateThis.type, this.token, this);
                if (!this.binding.isValidBinding()) {
                    return super.reportError(scope);
                }
                return this.checkFieldAccess(scope);
            }
        }
        if (this.binding instanceof ProblemBinding && ((ProblemBinding)this.binding).problemId() == 1 && this.evaluationContext.declaringTypeName != null) {
            this.delegateThis = scope.getField(scope.enclosingSourceType(), DELEGATE_THIS, this);
            if (this.delegateThis != null) {
                FieldBinding fieldBinding = scope.getField(this.delegateThis.type, this.token, this);
                if (!fieldBinding.isValidBinding()) {
                    if (((ProblemFieldBinding)fieldBinding).problemId() == 2) {
                        CodeSnippetScope localScope = new CodeSnippetScope(scope);
                        this.codegenBinding = this.binding = localScope.getFieldForCodeSnippet(this.delegateThis.type, this.token, this);
                        return this.checkFieldAccess(scope);
                    }
                    return super.reportError(scope);
                }
                this.codegenBinding = this.binding = fieldBinding;
                return this.checkFieldAccess(scope);
            }
        }
        return super.reportError(scope);
    }
}

