/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.eval;

import com.netflix.nebula.lint.jdt.internal.compiler.ast.AllocationExpression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.CastExpression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression;
import com.netflix.nebula.lint.jdt.internal.compiler.codegen.CodeStream;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.impl.Constant;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.Binding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.FieldBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.MethodBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ProblemMethodBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ProblemReasons;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ReferenceBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeConstants;
import com.netflix.nebula.lint.jdt.internal.eval.CodeSnippetScope;
import com.netflix.nebula.lint.jdt.internal.eval.EvaluationConstants;
import com.netflix.nebula.lint.jdt.internal.eval.EvaluationContext;

public class CodeSnippetAllocationExpression
extends AllocationExpression
implements ProblemReasons,
EvaluationConstants {
    EvaluationContext evaluationContext;
    FieldBinding delegateThis;

    public CodeSnippetAllocationExpression(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        ReferenceBinding allocatedType = this.codegenBinding.declaringClass;
        if (this.codegenBinding.canBeSeenBy(allocatedType, this, currentScope)) {
            codeStream.new_(allocatedType);
            if (valueRequired) {
                codeStream.dup();
            }
            codeStream.recordPositionsFrom(pc, this.type.sourceStart);
            if (allocatedType.isNestedType()) {
                codeStream.generateSyntheticEnclosingInstanceValues(currentScope, allocatedType, this.enclosingInstance(), this);
            }
            if (this.arguments != null) {
                int i = 0;
                int count = this.arguments.length;
                while (i < count) {
                    this.arguments[i].generateCode(currentScope, codeStream, true);
                    ++i;
                }
            }
            if (allocatedType.isNestedType()) {
                codeStream.generateSyntheticOuterArgumentValues(currentScope, allocatedType, this);
            }
            codeStream.invokespecial(this.codegenBinding);
        } else {
            codeStream.generateEmulationForConstructor(currentScope, this.codegenBinding);
            if (this.arguments != null) {
                int argsLength = this.arguments.length;
                codeStream.generateInlinedValue(argsLength);
                codeStream.newArray(currentScope.createArrayType(currentScope.getType(TypeConstants.JAVA_LANG_OBJECT, 3), 1));
                codeStream.dup();
                int i = 0;
                while (i < argsLength) {
                    codeStream.generateInlinedValue(i);
                    this.arguments[i].generateCode(currentScope, codeStream, true);
                    TypeBinding parameterBinding = this.codegenBinding.parameters[i];
                    if (parameterBinding.isBaseType() && parameterBinding != TypeBinding.NULL) {
                        codeStream.generateBoxingConversion(this.codegenBinding.parameters[i].id);
                    }
                    codeStream.aastore();
                    if (i < argsLength - 1) {
                        codeStream.dup();
                    }
                    ++i;
                }
            } else {
                codeStream.generateInlinedValue(0);
                codeStream.newArray(currentScope.createArrayType(currentScope.getType(TypeConstants.JAVA_LANG_OBJECT, 3), 1));
            }
            codeStream.invokeJavaLangReflectConstructorNewInstance();
            codeStream.checkcast(allocatedType);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            this.codegenBinding = this.binding.original();
        }
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        this.resolvedType = this.type.resolveType(scope, true);
        boolean argsContainCast = false;
        TypeBinding[] argumentTypes = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            boolean argHasError = false;
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                Expression argument = this.arguments[i];
                if (argument instanceof CastExpression) {
                    argument.bits |= 0x20;
                    argsContainCast = true;
                }
                if ((argumentTypes[i] = argument.resolveType(scope)) == null) {
                    argHasError = true;
                }
                ++i;
            }
            if (argHasError) {
                return this.resolvedType;
            }
        }
        if (this.resolvedType == null) {
            return null;
        }
        if (!this.resolvedType.canBeInstantiated()) {
            scope.problemReporter().cannotInstantiate(this.type, this.resolvedType);
            return this.resolvedType;
        }
        ReferenceBinding allocatedType = (ReferenceBinding)this.resolvedType;
        this.binding = scope.getConstructor(allocatedType, argumentTypes, this);
        if (!this.binding.isValidBinding()) {
            if (this.binding instanceof ProblemMethodBinding && ((ProblemMethodBinding)this.binding).problemId() == 2) {
                if (this.evaluationContext.declaringTypeName != null) {
                    this.delegateThis = scope.getField(scope.enclosingSourceType(), DELEGATE_THIS, this);
                    if (this.delegateThis == null) {
                        if (this.binding.declaringClass == null) {
                            this.binding.declaringClass = allocatedType;
                        }
                        scope.problemReporter().invalidConstructor(this, this.binding);
                        return this.resolvedType;
                    }
                } else {
                    if (this.binding.declaringClass == null) {
                        this.binding.declaringClass = allocatedType;
                    }
                    scope.problemReporter().invalidConstructor(this, this.binding);
                    return this.resolvedType;
                }
                CodeSnippetScope localScope = new CodeSnippetScope(scope);
                MethodBinding privateBinding = localScope.getConstructor((ReferenceBinding)this.delegateThis.type, argumentTypes, this);
                if (!privateBinding.isValidBinding()) {
                    if (this.binding.declaringClass == null) {
                        this.binding.declaringClass = allocatedType;
                    }
                    scope.problemReporter().invalidConstructor(this, this.binding);
                    return this.resolvedType;
                }
                this.binding = privateBinding;
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = allocatedType;
                }
                scope.problemReporter().invalidConstructor(this, this.binding);
                return this.resolvedType;
            }
        }
        if (this.isMethodUseDeprecated(this.binding, scope, true)) {
            scope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                TypeBinding parameterType = this.binding.parameters[i];
                TypeBinding argumentType = argumentTypes[i];
                this.arguments[i].computeConversion(scope, parameterType, argumentType);
                if (argumentType.needsUncheckedConversion(parameterType)) {
                    scope.problemReporter().unsafeTypeConversion(this.arguments[i], argumentType, parameterType);
                }
                ++i;
            }
            if (argsContainCast) {
                CastExpression.checkNeedForArgumentCasts(scope, null, allocatedType, this.binding, this.arguments, argumentTypes, this);
            }
        }
        if (allocatedType.isRawType() && this.binding.hasSubstitutedParameters()) {
            scope.problemReporter().unsafeRawInvocation(this, this.binding);
        }
        return allocatedType;
    }
}

