/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core.search;

import com.netflix.nebula.lint.jdt.core.IClassFile;
import com.netflix.nebula.lint.jdt.core.ICompilationUnit;
import com.netflix.nebula.lint.jdt.core.IPackageFragment;
import com.netflix.nebula.lint.jdt.core.IPackageFragmentRoot;
import com.netflix.nebula.lint.jdt.core.IType;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.core.search.IJavaSearchScope;
import com.netflix.nebula.lint.jdt.core.search.TypeNameMatchRequestor;
import com.netflix.nebula.lint.jdt.internal.compiler.env.AccessRestriction;
import com.netflix.nebula.lint.jdt.internal.core.Openable;
import com.netflix.nebula.lint.jdt.internal.core.PackageFragmentRoot;
import com.netflix.nebula.lint.jdt.internal.core.search.IRestrictedAccessTypeRequestor;
import com.netflix.nebula.lint.jdt.internal.core.search.JavaSearchScope;
import com.netflix.nebula.lint.jdt.internal.core.search.JavaSearchTypeNameMatch;
import com.netflix.nebula.lint.jdt.internal.core.util.HandleFactory;
import com.netflix.nebula.lint.jdt.internal.core.util.HashtableOfArrayToObject;
import com.netflix.nebula.lint.jdt.internal.core.util.Util;
import org.eclipse.core.runtime.Path;

public class TypeNameMatchRequestorWrapper
implements IRestrictedAccessTypeRequestor {
    TypeNameMatchRequestor requestor;
    private IJavaSearchScope scope;
    private HandleFactory handleFactory;
    private String lastPkgFragmentRootPath;
    private IPackageFragmentRoot lastPkgFragmentRoot;
    private HashtableOfArrayToObject packageHandles;

    public TypeNameMatchRequestorWrapper(TypeNameMatchRequestor requestor, IJavaSearchScope scope) {
        this.requestor = requestor;
        this.scope = scope;
        if (!(scope instanceof JavaSearchScope)) {
            this.handleFactory = new HandleFactory();
        }
    }

    public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path, AccessRestriction access) {
        try {
            IType type = null;
            if (this.handleFactory != null) {
                Openable openable = this.handleFactory.createOpenable(path, this.scope);
                if (openable == null) {
                    return;
                }
                switch (openable.getElementType()) {
                    case 5: {
                        ICompilationUnit cu = (ICompilationUnit)((Object)openable);
                        if (enclosingTypeNames != null && enclosingTypeNames.length > 0) {
                            type = cu.getType(new String(enclosingTypeNames[0]));
                            int j = 1;
                            int l = enclosingTypeNames.length;
                            while (j < l) {
                                type = type.getType(new String(enclosingTypeNames[j]));
                                ++j;
                            }
                            type = type.getType(new String(simpleTypeName));
                            break;
                        }
                        type = cu.getType(new String(simpleTypeName));
                        break;
                    }
                    case 6: {
                        type = ((IClassFile)((Object)openable)).getType();
                    }
                }
            } else {
                int separatorIndex = path.indexOf("|");
                IType iType = type = separatorIndex == -1 ? this.createTypeFromPath(path, new String(simpleTypeName), enclosingTypeNames) : this.createTypeFromJar(path, separatorIndex);
            }
            if (type != null) {
                this.requestor.acceptTypeNameMatch(new JavaSearchTypeNameMatch(type, modifiers));
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private IType createTypeFromJar(String resourcePath, int separatorIndex) throws JavaModelException {
        Object[] pkgName;
        String classFilePath;
        String[] simpleNames;
        int length;
        if (this.lastPkgFragmentRootPath == null || this.lastPkgFragmentRootPath.length() > resourcePath.length() || !resourcePath.startsWith(this.lastPkgFragmentRootPath)) {
            String jarPath = resourcePath.substring(0, separatorIndex);
            IPackageFragmentRoot root = ((JavaSearchScope)this.scope).packageFragmentRoot(resourcePath);
            if (root == null) {
                return null;
            }
            this.lastPkgFragmentRootPath = jarPath;
            this.lastPkgFragmentRoot = root;
            this.packageHandles = new HashtableOfArrayToObject(5);
        }
        if ((length = (simpleNames = new Path(classFilePath = resourcePath.substring(separatorIndex + 1)).segments()).length - 1) > 0) {
            pkgName = new String[length];
            System.arraycopy(simpleNames, 0, pkgName, 0, length);
        } else {
            pkgName = CharOperation.NO_STRINGS;
        }
        IPackageFragment pkgFragment = (IPackageFragment)this.packageHandles.get(pkgName);
        if (pkgFragment == null) {
            pkgFragment = ((PackageFragmentRoot)this.lastPkgFragmentRoot).getPackageFragment((String[])pkgName);
            this.packageHandles.put(pkgName, pkgFragment);
        }
        return pkgFragment.getClassFile(simpleNames[length]).getType();
    }

    private IType createTypeFromPath(String resourcePath, String simpleTypeName, char[][] enclosingTypeNames) throws JavaModelException {
        String simpleName;
        Object[] pkgName;
        String[] simpleNames;
        int length;
        int rootPathLength = -1;
        if (this.lastPkgFragmentRootPath == null || !resourcePath.startsWith(this.lastPkgFragmentRootPath) || (rootPathLength = this.lastPkgFragmentRootPath.length()) <= 0 || resourcePath.charAt(rootPathLength) != '/') {
            IPackageFragmentRoot root = ((JavaSearchScope)this.scope).packageFragmentRoot(resourcePath);
            if (root == null) {
                return null;
            }
            this.lastPkgFragmentRoot = root;
            this.lastPkgFragmentRootPath = this.lastPkgFragmentRoot.getPath().toString();
            this.packageHandles = new HashtableOfArrayToObject(5);
        }
        if ((length = (simpleNames = new Path(resourcePath = resourcePath.substring(this.lastPkgFragmentRootPath.length() + 1)).segments()).length - 1) > 0) {
            pkgName = new String[length];
            System.arraycopy(simpleNames, 0, pkgName, 0, length);
        } else {
            pkgName = CharOperation.NO_STRINGS;
        }
        IPackageFragment pkgFragment = (IPackageFragment)this.packageHandles.get(pkgName);
        if (pkgFragment == null) {
            pkgFragment = ((PackageFragmentRoot)this.lastPkgFragmentRoot).getPackageFragment((String[])pkgName);
            this.packageHandles.put(pkgName, pkgFragment);
        }
        if (Util.isJavaLikeFileName(simpleName = simpleNames[length])) {
            IType type;
            ICompilationUnit unit = pkgFragment.getCompilationUnit(simpleName);
            int etnLength = enclosingTypeNames == null ? 0 : enclosingTypeNames.length;
            IType iType = type = etnLength == 0 ? unit.getType(simpleTypeName) : unit.getType(new String(enclosingTypeNames[0]));
            if (etnLength > 0) {
                int i = 1;
                while (i < etnLength) {
                    type = type.getType(new String(enclosingTypeNames[i]));
                    ++i;
                }
                type = type.getType(simpleTypeName);
            }
            return type;
        }
        IClassFile classFile = pkgFragment.getClassFile(simpleName);
        return classFile.getType();
    }
}

