/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.IInitializer;
import com.netflix.nebula.lint.jdt.core.IJavaProject;
import com.netflix.nebula.lint.jdt.core.IPackageFragment;
import com.netflix.nebula.lint.jdt.core.IType;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.internal.codeassist.ISearchRequestor;
import com.netflix.nebula.lint.jdt.internal.compiler.env.AccessRestriction;
import com.netflix.nebula.lint.jdt.internal.compiler.env.AccessRuleSet;
import com.netflix.nebula.lint.jdt.internal.compiler.env.ICompilationUnit;
import com.netflix.nebula.lint.jdt.internal.core.BinaryType;
import com.netflix.nebula.lint.jdt.internal.core.ClasspathEntry;
import com.netflix.nebula.lint.jdt.internal.core.JavaElementRequestor;
import com.netflix.nebula.lint.jdt.internal.core.NameLookup;
import com.netflix.nebula.lint.jdt.internal.core.PackageFragmentRoot;

class SearchableEnvironmentRequestor
extends JavaElementRequestor {
    protected ISearchRequestor requestor;
    protected ICompilationUnit unitToSkip;
    protected IJavaProject project;
    protected NameLookup nameLookup;
    protected boolean checkAccessRestrictions;

    public SearchableEnvironmentRequestor(ISearchRequestor requestor) {
        this.requestor = requestor;
        this.unitToSkip = null;
        this.project = null;
        this.nameLookup = null;
        this.checkAccessRestrictions = false;
    }

    public SearchableEnvironmentRequestor(ISearchRequestor requestor, ICompilationUnit unitToSkip, IJavaProject project, NameLookup nameLookup) {
        this.requestor = requestor;
        this.unitToSkip = unitToSkip;
        this.project = project;
        this.nameLookup = nameLookup;
        this.checkAccessRestrictions = !"ignore".equals(project.getOption("com.netflix.nebula.lint.jdt.core.compiler.problem.forbiddenReference", true)) || !"ignore".equals(project.getOption("com.netflix.nebula.lint.jdt.core.compiler.problem.discouragedReference", true));
    }

    public void acceptInitializer(IInitializer initializer) {
    }

    public void acceptPackageFragment(IPackageFragment packageFragment) {
        this.requestor.acceptPackage(packageFragment.getElementName().toCharArray());
    }

    public void acceptType(IType type) {
        try {
            AccessRuleSet accessRuleSet;
            PackageFragmentRoot root;
            ClasspathEntry entry;
            if (this.unitToSkip != null && this.unitToSkip.equals(type.getCompilationUnit())) {
                return;
            }
            char[] packageName = type.getPackageFragment().getElementName().toCharArray();
            boolean isBinary = type instanceof BinaryType;
            AccessRestriction accessRestriction = null;
            if (this.checkAccessRestrictions && (isBinary || !type.getJavaProject().equals(this.project)) && (entry = (ClasspathEntry)this.nameLookup.rootToResolvedEntries.get(root = (PackageFragmentRoot)type.getAncestor(3))) != null && (accessRuleSet = entry.getAccessRuleSet()) != null) {
                char[][] packageChars = CharOperation.splitOn('.', packageName);
                char[] fileWithoutExtension = type.getElementName().toCharArray();
                accessRestriction = accessRuleSet.getViolatedRestriction(CharOperation.concatWith(packageChars, fileWithoutExtension, '/'));
            }
            this.requestor.acceptType(packageName, type.getElementName().toCharArray(), null, type.getFlags(), accessRestriction);
        }
        catch (JavaModelException javaModelException) {}
    }
}

