/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.ICompilationUnit;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.WorkingCopyOwner;
import com.netflix.nebula.lint.jdt.core.compiler.CategorizedProblem;
import com.netflix.nebula.lint.jdt.internal.compiler.CompilationResult;
import com.netflix.nebula.lint.jdt.internal.compiler.Compiler;
import com.netflix.nebula.lint.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import com.netflix.nebula.lint.jdt.internal.compiler.ICompilerRequestor;
import com.netflix.nebula.lint.jdt.internal.compiler.IErrorHandlingPolicy;
import com.netflix.nebula.lint.jdt.internal.compiler.IProblemFactory;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.env.AccessRestriction;
import com.netflix.nebula.lint.jdt.internal.compiler.env.INameEnvironment;
import com.netflix.nebula.lint.jdt.internal.compiler.env.ISourceType;
import com.netflix.nebula.lint.jdt.internal.compiler.impl.CompilerOptions;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.PackageBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.parser.Parser;
import com.netflix.nebula.lint.jdt.internal.compiler.parser.SourceTypeConverter;
import com.netflix.nebula.lint.jdt.internal.core.BasicCompilationUnit;
import com.netflix.nebula.lint.jdt.internal.core.CancelableNameEnvironment;
import com.netflix.nebula.lint.jdt.internal.core.CancelableProblemFactory;
import com.netflix.nebula.lint.jdt.internal.core.JavaProject;
import com.netflix.nebula.lint.jdt.internal.core.NameLookup;
import com.netflix.nebula.lint.jdt.internal.core.PackageFragment;
import com.netflix.nebula.lint.jdt.internal.core.util.CommentRecorderParser;
import com.netflix.nebula.lint.jdt.internal.core.util.Util;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class CompilationUnitProblemFinder
extends Compiler {
    protected CompilationUnitProblemFinder(INameEnvironment environment, IErrorHandlingPolicy policy, CompilerOptions compilerOptions, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        super(environment, policy, compilerOptions, requestor, problemFactory);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        CompilationResult result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 31, this.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            this.lookupEnvironment.buildTypeBindings(unit, accessRestriction);
            this.lookupEnvironment.completeTypeBindings(unit);
        }
    }

    protected static CompilerOptions getCompilerOptions(Map settings, boolean creatingAST, boolean statementsRecovery) {
        CompilerOptions compilerOptions = new CompilerOptions(settings);
        compilerOptions.performMethodsFullRecovery = statementsRecovery;
        compilerOptions.performStatementsRecovery = statementsRecovery;
        compilerOptions.parseLiteralExpressionsAsConstants = !creatingAST;
        compilerOptions.storeAnnotations = creatingAST;
        return compilerOptions;
    }

    protected static IErrorHandlingPolicy getHandlingPolicy() {
        return DefaultErrorHandlingPolicies.proceedWithAllProblems();
    }

    protected static ICompilerRequestor getRequestor() {
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
            }
        };
    }

    public static CompilationUnitDeclaration process(CompilationUnitDeclaration unit, ICompilationUnit unitElement, char[] contents, Parser parser, WorkingCopyOwner workingCopyOwner, HashMap problems, boolean creatingAST, int reconcileFlags, IProgressMonitor monitor) throws JavaModelException {
        JavaProject project = (JavaProject)unitElement.getJavaProject();
        CancelableNameEnvironment environment = null;
        CancelableProblemFactory problemFactory = null;
        CompilationUnitProblemFinder problemFinder = null;
        try {
            CategorizedProblem[] categorizedProblems;
            int length;
            environment = new CancelableNameEnvironment(project, workingCopyOwner, monitor);
            problemFactory = new CancelableProblemFactory(monitor);
            problemFinder = new CompilationUnitProblemFinder((INameEnvironment)environment, CompilationUnitProblemFinder.getHandlingPolicy(), CompilationUnitProblemFinder.getCompilerOptions(project.getOptions(true), creatingAST, (reconcileFlags & 2) != 0), CompilationUnitProblemFinder.getRequestor(), (IProblemFactory)problemFactory);
            if (parser != null) {
                problemFinder.parser = parser;
            }
            PackageFragment packageFragment = (PackageFragment)unitElement.getAncestor(4);
            char[][] expectedPackageName = null;
            if (packageFragment != null) {
                expectedPackageName = Util.toCharArrays(packageFragment.names);
            }
            if (unit == null) {
                unit = problemFinder.resolve(new BasicCompilationUnit(contents, expectedPackageName, unitElement.getPath().toString(), unitElement), true, true, true);
            } else {
                problemFinder.resolve(unit, null, true, true, true);
            }
            CompilationResult unitResult = unit.compilationResult;
            CategorizedProblem[] unitProblems = unitResult.getProblems();
            int n = length = unitProblems == null ? 0 : unitProblems.length;
            if (length > 0) {
                categorizedProblems = new CategorizedProblem[length];
                System.arraycopy(unitProblems, 0, categorizedProblems, 0, length);
                problems.put("com.netflix.nebula.lint.jdt.core.problem", categorizedProblems);
            }
            int n2 = length = (unitProblems = unitResult.getTasks()) == null ? 0 : unitProblems.length;
            if (length > 0) {
                categorizedProblems = new CategorizedProblem[length];
                System.arraycopy(unitProblems, 0, categorizedProblems, 0, length);
                problems.put("com.netflix.nebula.lint.jdt.core.task", categorizedProblems);
            }
            if (NameLookup.VERBOSE) {
                System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInSourcePackage: " + environment.nameLookup.timeSpentInSeekTypesInSourcePackage + "ms");
                System.out.println(Thread.currentThread() + " TIME SPENT in NameLoopkup#seekTypesInBinaryPackage: " + environment.nameLookup.timeSpentInSeekTypesInBinaryPackage + "ms");
            }
            CompilationUnitDeclaration compilationUnitDeclaration = unit;
            return compilationUnitDeclaration;
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            String lineDelimiter = unitElement.findRecommendedLineSeparator();
            StringBuffer message = new StringBuffer("Exception occurred during problem detection:");
            message.append(lineDelimiter);
            message.append("----------------------------------- SOURCE BEGIN -------------------------------------");
            message.append(lineDelimiter);
            message.append(contents);
            message.append(lineDelimiter);
            message.append("----------------------------------- SOURCE END -------------------------------------");
            Util.log(e, message.toString());
            throw new JavaModelException(e, 1005);
        }
        finally {
            if (environment != null) {
                environment.monitor = null;
            }
            if (problemFactory != null) {
                problemFactory.monitor = null;
            }
            if (problemFinder != null && !creatingAST) {
                problemFinder.lookupEnvironment.reset();
            }
        }
    }

    public static CompilationUnitDeclaration process(ICompilationUnit unitElement, char[] contents, WorkingCopyOwner workingCopyOwner, HashMap problems, boolean creatingAST, int reconcileFlags, IProgressMonitor monitor) throws JavaModelException {
        return CompilationUnitProblemFinder.process(null, unitElement, contents, null, workingCopyOwner, problems, creatingAST, reconcileFlags, monitor);
    }

    public void initializeParser() {
        this.parser = new CommentRecorderParser(this.problemReporter, this.options.parseLiteralExpressionsAsConstants);
    }
}

