/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.IClasspathEntry;
import com.netflix.nebula.lint.jdt.core.IJavaModelStatus;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.internal.core.ClasspathEntry;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelManager;
import com.netflix.nebula.lint.jdt.internal.core.JavaProject;
import com.netflix.nebula.lint.jdt.internal.core.builder.JavaBuilder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;

public class ClasspathValidation {
    private JavaProject project;

    public ClasspathValidation(JavaProject project) {
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        IJavaModelStatus status;
        IPath outputLocation;
        IClasspathEntry[] rawClasspath;
        JavaModelManager.PerProjectInfo perProjectInfo;
        try {
            perProjectInfo = this.project.getPerProjectInfo();
        }
        catch (JavaModelException javaModelException) {
            IProject resource = this.project.getProject();
            if (resource.isAccessible()) {
                this.project.flushClasspathProblemMarkers(true, true);
                JavaBuilder.removeProblemsAndTasksFor((IResource)resource);
            }
            return;
        }
        JavaModelManager.PerProjectInfo perProjectInfo2 = perProjectInfo;
        synchronized (perProjectInfo2) {
            rawClasspath = perProjectInfo.rawClasspath;
            outputLocation = perProjectInfo.outputLocation;
            status = perProjectInfo.rawClasspathStatus;
        }
        this.project.flushClasspathProblemMarkers(false, true);
        if (!status.isOK()) {
            this.project.createClasspathProblemMarker(status);
        }
        this.project.flushClasspathProblemMarkers(false, false);
        if (rawClasspath != JavaProject.INVALID_CLASSPATH && outputLocation != null) {
            int i = 0;
            while (i < rawClasspath.length) {
                status = ClasspathEntry.validateClasspathEntry(this.project, rawClasspath[i], false, true);
                if (!(status.isOK() || status.getCode() == 964 && ((ClasspathEntry)rawClasspath[i]).isOptional())) {
                    this.project.createClasspathProblemMarker(status);
                }
                ++i;
            }
            status = ClasspathEntry.validateClasspath(this.project, rawClasspath, outputLocation);
            if (!status.isOK()) {
                this.project.createClasspathProblemMarker(status);
            }
        }
    }
}

