/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.IBuffer;
import com.netflix.nebula.lint.jdt.core.IClassFile;
import com.netflix.nebula.lint.jdt.core.IJavaElement;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.ToolFactory;
import com.netflix.nebula.lint.jdt.core.WorkingCopyOwner;
import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.core.util.IClassFileReader;
import com.netflix.nebula.lint.jdt.internal.core.BinaryType;
import com.netflix.nebula.lint.jdt.internal.core.BufferManager;
import com.netflix.nebula.lint.jdt.internal.core.ClassFile;
import com.netflix.nebula.lint.jdt.internal.core.CompilationUnit;
import com.netflix.nebula.lint.jdt.internal.core.DefaultWorkingCopyOwner;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelStatus;
import com.netflix.nebula.lint.jdt.internal.core.PackageFragment;
import com.netflix.nebula.lint.jdt.internal.core.util.Disassembler;
import com.netflix.nebula.lint.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClassFileWorkingCopy
extends CompilationUnit {
    public IClassFile classFile;

    public ClassFileWorkingCopy(IClassFile classFile, WorkingCopyOwner owner) {
        super((PackageFragment)classFile.getParent(), ((BinaryType)((ClassFile)classFile).getType()).getSourceFileName(null), owner);
        this.classFile = classFile;
    }

    public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(967, this));
    }

    public IBuffer getBuffer() throws JavaModelException {
        if (this.isWorkingCopy()) {
            return super.getBuffer();
        }
        return this.classFile.getBuffer();
    }

    public char[] getContents() {
        try {
            IBuffer buffer = this.getBuffer();
            if (buffer == null) {
                return CharOperation.NO_CHAR;
            }
            char[] characters = buffer.getCharacters();
            if (characters == null) {
                return CharOperation.NO_CHAR;
            }
            return characters;
        }
        catch (JavaModelException javaModelException) {
            return CharOperation.NO_CHAR;
        }
    }

    public IPath getPath() {
        return this.classFile.getPath();
    }

    public IJavaElement getPrimaryElement(boolean checkOwner) {
        if (checkOwner && this.isPrimary()) {
            return this;
        }
        return new ClassFileWorkingCopy(this.classFile, DefaultWorkingCopyOwner.PRIMARY);
    }

    public IResource getResource() {
        return this.classFile.getResource();
    }

    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaModelException {
        IBuffer buffer = this.owner.createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null) {
            IBuffer classFileBuffer = this.classFile.getBuffer();
            if (classFileBuffer != null) {
                buffer.setContents(classFileBuffer.getCharacters());
            } else {
                IClassFileReader reader = ToolFactory.createDefaultClassFileReader(this.classFile, 65535);
                Disassembler disassembler = new Disassembler();
                String contents = disassembler.disassemble(reader, Util.getLineSeparator("", this.getJavaProject()), 16);
                buffer.setContents(contents);
            }
        }
        BufferManager bufManager = this.getBufferManager();
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    protected void toStringName(StringBuffer buffer) {
        buffer.append(this.classFile.getElementName());
    }
}

