/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.core;

import com.netflix.nebula.lint.jdt.core.Flags;
import com.netflix.nebula.lint.jdt.core.IField;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.Signature;
import com.netflix.nebula.lint.jdt.internal.compiler.env.IBinaryField;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.Binding;
import com.netflix.nebula.lint.jdt.internal.core.BinaryMember;
import com.netflix.nebula.lint.jdt.internal.core.BinaryType;
import com.netflix.nebula.lint.jdt.internal.core.ClassFile;
import com.netflix.nebula.lint.jdt.internal.core.JavaElement;
import com.netflix.nebula.lint.jdt.internal.core.JavaModelStatus;
import com.netflix.nebula.lint.jdt.internal.core.JavadocConstants;
import com.netflix.nebula.lint.jdt.internal.core.ResolvedBinaryField;
import org.eclipse.core.runtime.IProgressMonitor;

class BinaryField
extends BinaryMember
implements IField {
    protected BinaryField(JavaElement parent, String name) {
        super(parent, name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BinaryField)) {
            return false;
        }
        return super.equals(o);
    }

    public Object getConstant() throws JavaModelException {
        IBinaryField info = (IBinaryField)this.getElementInfo();
        return BinaryField.convertConstant(info.getConstant());
    }

    public int getFlags() throws JavaModelException {
        IBinaryField info = (IBinaryField)this.getElementInfo();
        return info.getModifiers();
    }

    public int getElementType() {
        return 8;
    }

    protected char getHandleMementoDelimiter() {
        return '^';
    }

    public String getKey(boolean forceOpen) throws JavaModelException {
        return this.getKey(this, forceOpen);
    }

    public String getTypeSignature() throws JavaModelException {
        IBinaryField info = (IBinaryField)this.getElementInfo();
        return new String(ClassFile.translatedName(info.getTypeName()));
    }

    public boolean isEnumConstant() throws JavaModelException {
        return Flags.isEnum(this.getFlags());
    }

    public boolean isResolved() {
        return false;
    }

    public JavaElement resolved(Binding binding) {
        ResolvedBinaryField resolvedHandle = new ResolvedBinaryField(this.parent, this.name, new String(binding.computeUniqueKey()));
        resolvedHandle.occurrenceCount = this.occurrenceCount;
        return resolvedHandle;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            this.toStringName(buffer);
        } else {
            try {
                buffer.append(Signature.toString(this.getTypeSignature()));
                buffer.append(" ");
                this.toStringName(buffer);
            }
            catch (JavaModelException javaModelException) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }

    public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaModelException {
        String contents = ((BinaryType)this.getDeclaringType()).getJavadocContents(monitor);
        if (contents == null) {
            return null;
        }
        int indexAnchor = contents.indexOf("<A NAME=\"" + this.getElementName() + "\"");
        if (indexAnchor == -1) {
            throw new JavaModelException(new JavaModelStatus(1009, this));
        }
        int indexOfEndLink = contents.indexOf("</A>", indexAnchor);
        if (indexOfEndLink == -1) {
            throw new JavaModelException(new JavaModelStatus(1009, this));
        }
        int indexOfNextField = contents.indexOf("<A NAME=\"", indexOfEndLink);
        int indexOfBottom = contents.indexOf("<!-- ========= CONSTRUCTOR DETAIL ======== -->", indexOfEndLink);
        if (indexOfBottom == -1 && (indexOfBottom = contents.indexOf("<!-- ============ METHOD DETAIL ========== -->", indexOfEndLink)) == -1) {
            indexOfBottom = contents.indexOf("<!-- ========= END OF CLASS DATA ========= -->", indexOfEndLink);
        }
        if ((indexOfNextField = Math.min(indexOfNextField, indexOfBottom)) == -1) {
            throw new JavaModelException(new JavaModelStatus(1009, this));
        }
        return contents.substring(indexOfEndLink + JavadocConstants.ANCHOR_SUFFIX_LENGTH, indexOfNextField);
    }
}

