/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.batch;

import com.netflix.nebula.lint.jdt.core.compiler.CharOperation;
import com.netflix.nebula.lint.jdt.internal.compiler.batch.ClasspathLocation;
import com.netflix.nebula.lint.jdt.internal.compiler.classfmt.ClassFileReader;
import com.netflix.nebula.lint.jdt.internal.compiler.classfmt.ClassFormatException;
import com.netflix.nebula.lint.jdt.internal.compiler.env.AccessRuleSet;
import com.netflix.nebula.lint.jdt.internal.compiler.env.NameEnvironmentAnswer;
import com.netflix.nebula.lint.jdt.internal.compiler.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClasspathJar
extends ClasspathLocation {
    protected File file;
    protected ZipFile zipFile;
    protected boolean closeZipFileAtEnd;
    protected Hashtable packageCache;
    protected char[] normalizedPath;

    public ClasspathJar(File file, boolean closeZipFileAtEnd, AccessRuleSet accessRuleSet, String destinationPath) {
        super(accessRuleSet, destinationPath);
        this.file = file;
        this.closeZipFileAtEnd = closeZipFileAtEnd;
    }

    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        return this.findClass(typeName, qualifiedPackageName, qualifiedBinaryFileName, false);
    }

    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String qualifiedBinaryFileName, boolean asBinaryOnly) {
        if (!this.isPackage(qualifiedPackageName)) {
            return null;
        }
        try {
            ClassFileReader reader = ClassFileReader.read(this.zipFile, qualifiedBinaryFileName);
            if (reader != null) {
                return new NameEnvironmentAnswer(reader, this.fetchAccessRestriction(qualifiedBinaryFileName));
            }
        }
        catch (ClassFormatException classFormatException) {
        }
        catch (IOException iOException) {}
        return null;
    }

    public char[][][] findTypeNames(String qualifiedPackageName) {
        if (!this.isPackage(qualifiedPackageName)) {
            return null;
        }
        ArrayList<char[][]> answers = new ArrayList<char[][]>();
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        block0: while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            int last = fileName.lastIndexOf(47);
            while (last > 0) {
                String packageName = fileName.substring(0, last);
                if (!qualifiedPackageName.equals(packageName)) continue block0;
                int indexOfDot = fileName.lastIndexOf(46);
                if (indexOfDot == -1) continue;
                String typeName = fileName.substring(last + 1, indexOfDot);
                char[] packageArray = packageName.toCharArray();
                answers.add(CharOperation.arrayConcat(CharOperation.splitOn('/', packageArray), typeName.toCharArray()));
            }
        }
        int size = answers.size();
        if (size != 0) {
            char[][][] result = new char[size][][];
            answers.toArray((T[])result);
            return null;
        }
        return null;
    }

    public void initialize() throws IOException {
        this.zipFile = new ZipFile(this.file);
    }

    public boolean isPackage(String qualifiedPackageName) {
        if (this.packageCache != null) {
            return this.packageCache.containsKey(qualifiedPackageName);
        }
        this.packageCache = new Hashtable(41);
        this.packageCache.put(Util.EMPTY_STRING, Util.EMPTY_STRING);
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        block0: while (e.hasMoreElements()) {
            String fileName = e.nextElement().getName();
            int last = fileName.lastIndexOf(47);
            while (last > 0) {
                String packageName = fileName.substring(0, last);
                if (this.packageCache.containsKey(packageName)) continue block0;
                this.packageCache.put(packageName, packageName);
                last = packageName.lastIndexOf(47);
            }
        }
        return this.packageCache.containsKey(qualifiedPackageName);
    }

    public void reset() {
        if (this.zipFile != null && this.closeZipFileAtEnd) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {}
            this.zipFile = null;
        }
        this.packageCache = null;
    }

    public String toString() {
        return "Classpath for jar file " + this.file.getPath();
    }

    public char[] normalizedPath() {
        if (this.normalizedPath == null) {
            char[] rawName = this.file.getPath().toCharArray();
            if (File.separatorChar == '\\') {
                CharOperation.replace(rawName, '\\', '/');
            }
            this.normalizedPath = CharOperation.subarray(rawName, 0, CharOperation.lastIndexOf('.', rawName));
        }
        return this.normalizedPath;
    }

    public String getPath() {
        return this.file.getPath();
    }
}

