/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.ast;

import com.netflix.nebula.lint.jdt.internal.compiler.ASTVisitor;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.CaseStatement;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Expression;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Statement;
import com.netflix.nebula.lint.jdt.internal.compiler.codegen.BranchLabel;
import com.netflix.nebula.lint.jdt.internal.compiler.codegen.CaseLabel;
import com.netflix.nebula.lint.jdt.internal.compiler.codegen.CodeStream;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowContext;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.SwitchFlowContext;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.impl.Constant;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.ReferenceBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.SourceTypeBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding;

public class SwitchStatement
extends Statement {
    public Expression expression;
    public Statement[] statements;
    public BlockScope scope;
    public int explicitDeclarations;
    public BranchLabel breakLabel;
    public CaseStatement[] cases;
    public CaseStatement defaultCase;
    public int blockStart;
    public int caseCount;
    int[] constants;
    public static final int CASE = 0;
    public static final int FALLTHROUGH = 1;
    public static final int ESCAPING = 2;
    public SyntheticMethodBinding synthetic;
    int preSwitchInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo);
            this.breakLabel = new BranchLabel();
            SwitchFlowContext switchContext = new SwitchFlowContext(flowContext, this, this.breakLabel);
            FlowInfo caseInits = FlowInfo.DEAD_END;
            this.preSwitchInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
            int caseIndex = 0;
            if (this.statements != null) {
                boolean didAlreadyComplain = false;
                int fallThroughState = 0;
                int i = 0;
                int max = this.statements.length;
                while (i < max) {
                    Statement statement = this.statements[i];
                    if (caseIndex < this.caseCount && statement == this.cases[caseIndex]) {
                        this.scope.enclosingCase = this.cases[caseIndex];
                        ++caseIndex;
                        if (fallThroughState == 1 && (statement.bits & 0x20000000) == 0) {
                            this.scope.problemReporter().possibleFallThroughCase(this.scope.enclosingCase);
                        }
                        caseInits = ((FlowInfo)caseInits).mergedWith(flowInfo.unconditionalInits());
                        didAlreadyComplain = false;
                        fallThroughState = 0;
                    } else if (statement == this.defaultCase) {
                        this.scope.enclosingCase = this.defaultCase;
                        if (fallThroughState == 1 && (statement.bits & 0x20000000) == 0) {
                            this.scope.problemReporter().possibleFallThroughCase(this.scope.enclosingCase);
                        }
                        caseInits = ((FlowInfo)caseInits).mergedWith(flowInfo.unconditionalInits());
                        didAlreadyComplain = false;
                        fallThroughState = 0;
                    } else {
                        fallThroughState = 1;
                    }
                    if (!statement.complainIfUnreachable(caseInits, this.scope, didAlreadyComplain)) {
                        if ((caseInits = statement.analyseCode(this.scope, switchContext, caseInits)) == FlowInfo.DEAD_END) {
                            fallThroughState = 2;
                        }
                    } else {
                        didAlreadyComplain = true;
                    }
                    ++i;
                }
            }
            TypeBinding resolvedTypeBinding = this.expression.resolvedType;
            if (this.caseCount > 0 && resolvedTypeBinding.isEnum()) {
                SourceTypeBinding sourceTypeBinding = this.scope.classScope().referenceContext.binding;
                this.synthetic = sourceTypeBinding.addSyntheticMethodForSwitchEnum(resolvedTypeBinding);
            }
            if (this.defaultCase == null) {
                flowInfo.addPotentialInitializationsFrom(((FlowInfo)caseInits).mergedWith(switchContext.initsOnBreak));
                this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
                FlowInfo flowInfo2 = flowInfo;
                return flowInfo2;
            }
            UnconditionalFlowInfo mergedInfo = ((FlowInfo)caseInits).mergedWith(switchContext.initsOnBreak);
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
            UnconditionalFlowInfo unconditionalFlowInfo = mergedInfo;
            return unconditionalFlowInfo;
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        try {
            TypeBinding resolvedType;
            if ((this.bits & Integer.MIN_VALUE) == 0) {
                return;
            }
            int pc = codeStream.position;
            this.breakLabel.initialize(codeStream);
            CaseLabel[] caseLabels = new CaseLabel[this.caseCount];
            boolean needSwitch = this.caseCount != 0;
            int i = 0;
            while (i < this.caseCount) {
                this.cases[i].targetLabel = caseLabels[i] = new CaseLabel(codeStream);
                caseLabels[i].tagBits |= 2;
                ++i;
            }
            CaseLabel defaultLabel = new CaseLabel(codeStream);
            if (needSwitch) {
                defaultLabel.tagBits |= 2;
            }
            if (this.defaultCase != null) {
                this.defaultCase.targetLabel = defaultLabel;
            }
            if ((resolvedType = this.expression.resolvedType).isEnum()) {
                if (needSwitch) {
                    codeStream.invokestatic(this.synthetic);
                    this.expression.generateCode(currentScope, codeStream, true);
                    codeStream.invokeEnumOrdinal(resolvedType.constantPoolName());
                    codeStream.iaload();
                } else {
                    this.expression.generateCode(currentScope, codeStream, false);
                }
            } else {
                this.expression.generateCode(currentScope, codeStream, needSwitch);
            }
            if (needSwitch) {
                int[] sortedIndexes = new int[this.caseCount];
                int i2 = 0;
                while (i2 < this.caseCount) {
                    sortedIndexes[i2] = i2;
                    ++i2;
                }
                int[] localKeysCopy = new int[this.caseCount];
                System.arraycopy(this.constants, 0, localKeysCopy, 0, this.caseCount);
                CodeStream.sort(localKeysCopy, 0, this.caseCount - 1, sortedIndexes);
                int max = localKeysCopy[this.caseCount - 1];
                int min = localKeysCopy[0];
                if ((long)((double)this.caseCount * 2.5) > (long)max - (long)min) {
                    if (max > 0x7FFF0000 && currentScope.compilerOptions().complianceLevel < 0x300000L) {
                        codeStream.lookupswitch(defaultLabel, this.constants, sortedIndexes, caseLabels);
                    } else {
                        codeStream.tableswitch(defaultLabel, min, max, this.constants, sortedIndexes, caseLabels);
                    }
                } else {
                    codeStream.lookupswitch(defaultLabel, this.constants, sortedIndexes, caseLabels);
                }
                codeStream.updateLastRecordedEndPC(this.scope, codeStream.position);
            }
            int caseIndex = 0;
            if (this.statements != null) {
                int i3 = 0;
                int maxCases = this.statements.length;
                while (i3 < maxCases) {
                    Statement statement = this.statements[i3];
                    if (caseIndex < this.caseCount && statement == this.cases[caseIndex]) {
                        this.scope.enclosingCase = this.cases[caseIndex];
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preSwitchInitStateIndex);
                        }
                        ++caseIndex;
                    } else if (statement == this.defaultCase) {
                        this.scope.enclosingCase = this.defaultCase;
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preSwitchInitStateIndex);
                        }
                    }
                    statement.generateCode(this.scope, codeStream);
                    ++i3;
                }
            }
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            }
            if (this.scope != currentScope) {
                codeStream.exitUserScope(this.scope);
            }
            this.breakLabel.place();
            if (this.defaultCase == null) {
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd, true);
                defaultLabel.place();
            }
            codeStream.recordPositionsFrom(pc, this.sourceStart);
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        SwitchStatement.printIndent(indent, output).append("switch (");
        this.expression.printExpression(0, output).append(") {");
        if (this.statements != null) {
            int i = 0;
            while (i < this.statements.length) {
                output.append('\n');
                if (this.statements[i] instanceof CaseStatement) {
                    this.statements[i].printStatement(indent, output);
                } else {
                    this.statements[i].printStatement(indent + 2, output);
                }
                ++i;
            }
        }
        output.append("\n");
        return SwitchStatement.printIndent(indent, output).append('}');
    }

    /*
     * Unable to fully structure code
     */
    public void resolve(BlockScope upperScope) {
        block25: {
            try {
                block27: {
                    block28: {
                        isEnumSwitch = false;
                        expressionType = this.expression.resolveType(upperScope);
                        if (expressionType == null) break block27;
                        this.expression.computeConversion(upperScope, expressionType, expressionType);
                        if (!expressionType.isBaseType()) break block28;
                        if (!this.expression.isConstantValueOfTypeAssignableToType(expressionType, TypeBinding.INT) && !expressionType.isCompatibleWith(TypeBinding.INT)) ** GOTO lbl-1000
                        break block27;
                    }
                    if (expressionType.isEnum()) {
                        isEnumSwitch = true;
                    } else if (upperScope.isBoxingCompatibleWith(expressionType, TypeBinding.INT)) {
                        this.expression.computeConversion(upperScope, TypeBinding.INT, expressionType);
                    } else lbl-1000:
                    // 2 sources

                    {
                        upperScope.problemReporter().incorrectSwitchType(this.expression, expressionType);
                        expressionType = null;
                    }
                }
                if (this.statements != null) {
                    this.scope = new BlockScope(upperScope);
                    length = this.statements.length;
                    this.cases = new CaseStatement[length];
                    this.constants = new int[length];
                    duplicateCaseStatements = null;
                    duplicateCaseStatementsCounter = 0;
                    counter = 0;
                    i = 0;
                    while (i < length) {
                        statement = this.statements[i];
                        constant = statement.resolveCase(this.scope, expressionType, this);
                        if (constant != Constant.NotAConstant) {
                            key = constant.intValue();
                            j = 0;
                            while (j < counter) {
                                if (this.constants[j] == key) {
                                    currentCaseStatement = (CaseStatement)statement;
                                    if (duplicateCaseStatements == null) {
                                        this.scope.problemReporter().duplicateCase(this.cases[j]);
                                        this.scope.problemReporter().duplicateCase(currentCaseStatement);
                                        duplicateCaseStatements = new CaseStatement[length];
                                        duplicateCaseStatements[duplicateCaseStatementsCounter++] = this.cases[j];
                                        duplicateCaseStatements[duplicateCaseStatementsCounter++] = currentCaseStatement;
                                    } else {
                                        found = false;
                                        k = 2;
                                        while (k < duplicateCaseStatementsCounter) {
                                            if (duplicateCaseStatements[k] == statement) {
                                                found = true;
                                                break;
                                            }
                                            ++k;
                                        }
                                        if (!found) {
                                            this.scope.problemReporter().duplicateCase(currentCaseStatement);
                                            duplicateCaseStatements[duplicateCaseStatementsCounter++] = currentCaseStatement;
                                        }
                                    }
                                }
                                ++j;
                            }
                            this.constants[counter++] = key;
                        }
                        ++i;
                    }
                    if (length != counter) {
                        this.constants = new int[counter];
                        System.arraycopy(this.constants, 0, this.constants, 0, counter);
                    }
                } else if ((this.bits & 8) != 0) {
                    upperScope.problemReporter().undocumentedEmptyBlock(this.blockStart, this.sourceEnd);
                }
                if (!isEnumSwitch || this.defaultCase != null || upperScope.compilerOptions().getSeverity(0x20000000000L) == -1) break block25;
                v0 = constantCount = this.constants == null ? 0 : this.constants.length;
                if (constantCount != this.caseCount || this.caseCount == ((ReferenceBinding)expressionType).enumConstantCount()) break block25;
                enumFields = ((ReferenceBinding)expressionType.erasure()).fields();
                i = 0;
                max = enumFields.length;
                while (i < max) {
                    block26: {
                        enumConstant = enumFields[i];
                        if ((enumConstant.modifiers & 16384) != 0) {
                            j = 0;
                            while (j < this.caseCount) {
                                if (enumConstant.id + 1 != this.constants[j]) {
                                    ++j;
                                    continue;
                                }
                                break block26;
                            }
                            upperScope.problemReporter().missingEnumConstantCase(this, enumConstant);
                        }
                    }
                    ++i;
                }
            }
            finally {
                if (this.scope != null) {
                    this.scope.enclosingCase = null;
                }
            }
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.expression.traverse(visitor, this.scope);
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                int i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, blockScope);
    }

    public void branchChainTo(BranchLabel label) {
        if (this.breakLabel.forwardReferenceCount() > 0) {
            label.becomeDelegateFor(this.breakLabel);
        }
    }
}

