/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler.ast;

import com.netflix.nebula.lint.jdt.internal.compiler.ASTVisitor;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.Block;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.FieldDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.TypeDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.codegen.CodeStream;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowContext;
import com.netflix.nebula.lint.jdt.internal.compiler.flow.FlowInfo;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.FieldBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.MethodScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.SourceTypeBinding;
import com.netflix.nebula.lint.jdt.internal.compiler.parser.Parser;

public class Initializer
extends FieldDeclaration {
    public Block block;
    public int lastVisibleFieldID;
    public int bodyStart;
    public int bodyEnd;

    public Initializer(Block block, int modifiers) {
        this.block = block;
        this.modifiers = modifiers;
        this.declarationSourceStart = this.sourceStart = block.sourceStart;
    }

    public FlowInfo analyseCode(MethodScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.block.analyseCode(currentScope, flowContext, flowInfo);
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        this.block.generateCode(currentScope, codeStream);
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public int getKind() {
        return 2;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public void parseStatements(Parser parser, TypeDeclaration typeDeclaration, CompilationUnitDeclaration unit) {
        parser.parse(this, typeDeclaration, unit);
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        if (this.modifiers != 0) {
            Initializer.printIndent(indent, output);
            Initializer.printModifiers(this.modifiers, output);
            if (this.annotations != null) {
                Initializer.printAnnotations(this.annotations, output);
            }
            output.append("{\n");
            this.block.printBody(indent, output);
            Initializer.printIndent(indent, output).append('}');
            return output;
        }
        return this.block.printStatement(indent, output);
    }

    public void resolve(MethodScope scope) {
        FieldBinding previousField = scope.initializedField;
        int previousFieldID = scope.lastVisibleFieldID;
        try {
            SourceTypeBinding declaringType;
            scope.initializedField = null;
            scope.lastVisibleFieldID = this.lastVisibleFieldID;
            if (this.isStatic() && (declaringType = scope.enclosingSourceType()).isNestedType() && !declaringType.isStatic()) {
                scope.problemReporter().innerTypesCannotDeclareStaticInitializers(declaringType, this);
            }
            this.block.resolve(scope);
        }
        finally {
            scope.initializedField = previousField;
            scope.lastVisibleFieldID = previousFieldID;
        }
    }

    public void traverse(ASTVisitor visitor, MethodScope scope) {
        if (visitor.visit(this, scope)) {
            this.block.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

