/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.compiler;

import com.netflix.nebula.lint.jdt.internal.compiler.ClassFile;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.SourceTypeBinding;
import java.util.Arrays;

public class ClassFilePool {
    public static final int POOL_SIZE = 7;
    ClassFile[] classFiles = new ClassFile[7];

    private ClassFilePool() {
    }

    public static ClassFilePool newInstance() {
        return new ClassFilePool();
    }

    public void release(ClassFile classFile) {
        int i = 0;
        while (i < 7) {
            ClassFile currentClassFile = this.classFiles[i];
            if (currentClassFile == classFile) {
                classFile.isShared = false;
                return;
            }
            ++i;
        }
    }

    public ClassFile acquire(SourceTypeBinding typeBinding) {
        int i = 0;
        while (i < 7) {
            ClassFile classFile = this.classFiles[i];
            if (classFile == null) {
                ClassFile newClassFile;
                this.classFiles[i] = newClassFile = new ClassFile(typeBinding);
                newClassFile.isShared = true;
                return newClassFile;
            }
            if (!classFile.isShared) {
                classFile.reset(typeBinding);
                classFile.isShared = true;
                return classFile;
            }
            ++i;
        }
        return new ClassFile(typeBinding);
    }

    public void reset() {
        Arrays.fill(this.classFiles, null);
    }
}

