/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.internal.codeassist.complete;

import com.netflix.nebula.lint.jdt.internal.codeassist.complete.CompletionNodeFound;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.ASTNode;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.MessageSend;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.NameReference;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.BlockScope;
import com.netflix.nebula.lint.jdt.internal.compiler.lookup.TypeBinding;

public class CompletionOnMessageSendName
extends MessageSend {
    public CompletionOnMessageSendName(char[] selector, int start, int end) {
        this.selector = selector;
        this.sourceStart = start;
        this.sourceEnd = end;
        this.nameSourcePosition = end;
    }

    public TypeBinding resolveType(BlockScope scope) {
        if (this.receiver.isImplicitThis()) {
            throw new CompletionNodeFound();
        }
        this.actualReceiverType = this.receiver.resolveType(scope);
        if (this.actualReceiverType == null || this.actualReceiverType.isBaseType() || this.actualReceiverType.isArrayType()) {
            throw new CompletionNodeFound();
        }
        if (this.typeArguments != null) {
            int length = this.typeArguments.length;
            this.genericTypeArguments = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                this.genericTypeArguments[i] = this.typeArguments[i].resolveType(scope, true);
                ++i;
            }
        }
        if (this.receiver instanceof NameReference) {
            throw new CompletionNodeFound((ASTNode)this, ((NameReference)this.receiver).binding, scope);
        }
        if (this.receiver instanceof MessageSend) {
            throw new CompletionNodeFound((ASTNode)this, ((MessageSend)this.receiver).binding, scope);
        }
        throw new CompletionNodeFound((ASTNode)this, this.actualReceiverType, scope);
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append("<CompleteOnMessageSendName:");
        if (!this.receiver.isImplicitThis()) {
            this.receiver.printExpression(0, output).append('.');
        }
        if (this.typeArguments != null) {
            output.append('<');
            int max = this.typeArguments.length - 1;
            int j = 0;
            while (j < max) {
                this.typeArguments[j].print(0, output);
                output.append(", ");
                ++j;
            }
            this.typeArguments[max].print(0, output);
            output.append('>');
        }
        output.append(this.selector).append('(');
        return output.append(")>");
    }
}

