/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.core.dom;

import com.netflix.nebula.lint.jdt.core.IClassFile;
import com.netflix.nebula.lint.jdt.core.ICompilationUnit;
import com.netflix.nebula.lint.jdt.core.IJavaProject;
import com.netflix.nebula.lint.jdt.core.JavaCore;
import com.netflix.nebula.lint.jdt.core.dom.ASTConverter;
import com.netflix.nebula.lint.jdt.core.dom.ASTNode;
import com.netflix.nebula.lint.jdt.core.dom.ASTParser;
import com.netflix.nebula.lint.jdt.core.dom.AbstractTypeDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.AnnotationTypeDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.AnnotationTypeMemberDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.AnonymousClassDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.ArrayAccess;
import com.netflix.nebula.lint.jdt.core.dom.ArrayCreation;
import com.netflix.nebula.lint.jdt.core.dom.ArrayInitializer;
import com.netflix.nebula.lint.jdt.core.dom.ArrayType;
import com.netflix.nebula.lint.jdt.core.dom.AssertStatement;
import com.netflix.nebula.lint.jdt.core.dom.Assignment;
import com.netflix.nebula.lint.jdt.core.dom.BindingResolver;
import com.netflix.nebula.lint.jdt.core.dom.Block;
import com.netflix.nebula.lint.jdt.core.dom.BlockComment;
import com.netflix.nebula.lint.jdt.core.dom.BooleanLiteral;
import com.netflix.nebula.lint.jdt.core.dom.BreakStatement;
import com.netflix.nebula.lint.jdt.core.dom.CastExpression;
import com.netflix.nebula.lint.jdt.core.dom.CatchClause;
import com.netflix.nebula.lint.jdt.core.dom.CharacterLiteral;
import com.netflix.nebula.lint.jdt.core.dom.ClassInstanceCreation;
import com.netflix.nebula.lint.jdt.core.dom.CompilationUnit;
import com.netflix.nebula.lint.jdt.core.dom.ConditionalExpression;
import com.netflix.nebula.lint.jdt.core.dom.ConstructorInvocation;
import com.netflix.nebula.lint.jdt.core.dom.ContinueStatement;
import com.netflix.nebula.lint.jdt.core.dom.DefaultBindingResolver;
import com.netflix.nebula.lint.jdt.core.dom.DoStatement;
import com.netflix.nebula.lint.jdt.core.dom.EmptyStatement;
import com.netflix.nebula.lint.jdt.core.dom.EnhancedForStatement;
import com.netflix.nebula.lint.jdt.core.dom.EnumConstantDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.EnumDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.Expression;
import com.netflix.nebula.lint.jdt.core.dom.ExpressionStatement;
import com.netflix.nebula.lint.jdt.core.dom.FieldAccess;
import com.netflix.nebula.lint.jdt.core.dom.FieldDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.ForStatement;
import com.netflix.nebula.lint.jdt.core.dom.ITypeBinding;
import com.netflix.nebula.lint.jdt.core.dom.IfStatement;
import com.netflix.nebula.lint.jdt.core.dom.ImportDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.InfixExpression;
import com.netflix.nebula.lint.jdt.core.dom.Initializer;
import com.netflix.nebula.lint.jdt.core.dom.InstanceofExpression;
import com.netflix.nebula.lint.jdt.core.dom.InternalASTRewrite;
import com.netflix.nebula.lint.jdt.core.dom.Javadoc;
import com.netflix.nebula.lint.jdt.core.dom.LabeledStatement;
import com.netflix.nebula.lint.jdt.core.dom.LineComment;
import com.netflix.nebula.lint.jdt.core.dom.MarkerAnnotation;
import com.netflix.nebula.lint.jdt.core.dom.MemberRef;
import com.netflix.nebula.lint.jdt.core.dom.MemberValuePair;
import com.netflix.nebula.lint.jdt.core.dom.MethodDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.MethodInvocation;
import com.netflix.nebula.lint.jdt.core.dom.MethodRef;
import com.netflix.nebula.lint.jdt.core.dom.MethodRefParameter;
import com.netflix.nebula.lint.jdt.core.dom.Modifier;
import com.netflix.nebula.lint.jdt.core.dom.Name;
import com.netflix.nebula.lint.jdt.core.dom.NodeEventHandler;
import com.netflix.nebula.lint.jdt.core.dom.NormalAnnotation;
import com.netflix.nebula.lint.jdt.core.dom.NullLiteral;
import com.netflix.nebula.lint.jdt.core.dom.NumberLiteral;
import com.netflix.nebula.lint.jdt.core.dom.PackageDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.ParameterizedType;
import com.netflix.nebula.lint.jdt.core.dom.ParenthesizedExpression;
import com.netflix.nebula.lint.jdt.core.dom.PostfixExpression;
import com.netflix.nebula.lint.jdt.core.dom.PrefixExpression;
import com.netflix.nebula.lint.jdt.core.dom.PrimitiveType;
import com.netflix.nebula.lint.jdt.core.dom.QualifiedName;
import com.netflix.nebula.lint.jdt.core.dom.QualifiedType;
import com.netflix.nebula.lint.jdt.core.dom.ReturnStatement;
import com.netflix.nebula.lint.jdt.core.dom.SimpleName;
import com.netflix.nebula.lint.jdt.core.dom.SimplePropertyDescriptor;
import com.netflix.nebula.lint.jdt.core.dom.SimpleType;
import com.netflix.nebula.lint.jdt.core.dom.SingleMemberAnnotation;
import com.netflix.nebula.lint.jdt.core.dom.SingleVariableDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.StringLiteral;
import com.netflix.nebula.lint.jdt.core.dom.StructuralPropertyDescriptor;
import com.netflix.nebula.lint.jdt.core.dom.SuperConstructorInvocation;
import com.netflix.nebula.lint.jdt.core.dom.SuperFieldAccess;
import com.netflix.nebula.lint.jdt.core.dom.SuperMethodInvocation;
import com.netflix.nebula.lint.jdt.core.dom.SwitchCase;
import com.netflix.nebula.lint.jdt.core.dom.SwitchStatement;
import com.netflix.nebula.lint.jdt.core.dom.SynchronizedStatement;
import com.netflix.nebula.lint.jdt.core.dom.TagElement;
import com.netflix.nebula.lint.jdt.core.dom.TextElement;
import com.netflix.nebula.lint.jdt.core.dom.ThisExpression;
import com.netflix.nebula.lint.jdt.core.dom.ThrowStatement;
import com.netflix.nebula.lint.jdt.core.dom.TryStatement;
import com.netflix.nebula.lint.jdt.core.dom.Type;
import com.netflix.nebula.lint.jdt.core.dom.TypeDeclaration;
import com.netflix.nebula.lint.jdt.core.dom.TypeDeclarationStatement;
import com.netflix.nebula.lint.jdt.core.dom.TypeLiteral;
import com.netflix.nebula.lint.jdt.core.dom.TypeParameter;
import com.netflix.nebula.lint.jdt.core.dom.VariableDeclarationExpression;
import com.netflix.nebula.lint.jdt.core.dom.VariableDeclarationFragment;
import com.netflix.nebula.lint.jdt.core.dom.VariableDeclarationStatement;
import com.netflix.nebula.lint.jdt.core.dom.WhileStatement;
import com.netflix.nebula.lint.jdt.core.dom.WildcardType;
import com.netflix.nebula.lint.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import com.netflix.nebula.lint.jdt.internal.compiler.parser.Scanner;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public final class AST {
    public static final int JLS2 = 2;
    static final int JLS2_INTERNAL = 2;
    public static final int JLS3 = 3;
    private BindingResolver resolver = new BindingResolver();
    private NodeEventHandler eventHandler = new NodeEventHandler();
    int apiLevel;
    private long modificationCount = 0L;
    private long originalModificationCount = 0L;
    private int disableEvents = 0;
    private final Object internalASTLock = new Object();
    Scanner scanner;
    InternalASTRewrite rewriter;
    private int defaultNodeFlag = 0;
    private static final Class[] AST_CLASS;
    private final Object[] THIS_AST = new Object[]{this};
    static final int RESOLVED_BINDINGS = Integer.MIN_VALUE;
    private int bits;
    static /* synthetic */ Class class$0;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.netflix.nebula.lint.jdt.core.dom.AST");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        AST_CLASS = classArray;
    }

    private AST(int level) {
        if (level != 2 && level != 3) {
            throw new IllegalArgumentException();
        }
        this.apiLevel = level;
        this.scanner = new Scanner(true, true, false, 0x2F0000L, 0x310000L, null, null, true);
    }

    public AST() {
        this(JavaCore.getDefaultOptions());
    }

    public static CompilationUnit convertCompilationUnit(int level, CompilationUnitDeclaration compilationUnitDeclaration, char[] source, Map options, boolean isResolved, com.netflix.nebula.lint.jdt.internal.core.CompilationUnit workingCopy, int reconcileFlags, IProgressMonitor monitor) {
        ASTConverter converter = new ASTConverter(options, isResolved, monitor);
        AST ast = AST.newAST(level);
        int savedDefaultNodeFlag = ast.getDefaultNodeFlag();
        ast.setDefaultNodeFlag(2);
        BindingResolver resolver = null;
        if (isResolved) {
            resolver = new DefaultBindingResolver(compilationUnitDeclaration.scope, workingCopy.owner, new DefaultBindingResolver.BindingTables(), false);
            ast.setFlag(Integer.MIN_VALUE);
        } else {
            resolver = new BindingResolver();
        }
        ast.setFlag(reconcileFlags);
        ast.setBindingResolver(resolver);
        converter.setAST(ast);
        CompilationUnit unit = converter.convert(compilationUnitDeclaration, source);
        unit.setLineEndTable(compilationUnitDeclaration.compilationResult.getLineSeparatorPositions());
        unit.setTypeRoot(workingCopy);
        ast.setDefaultNodeFlag(savedDefaultNodeFlag);
        return unit;
    }

    public AST(Map options) {
        this(2);
        Object sourceLevelOption = options.get("com.netflix.nebula.lint.jdt.core.compiler.source");
        long sourceLevel = 0x2F0000L;
        if ("1.4".equals(sourceLevelOption)) {
            sourceLevel = 0x300000L;
        } else if ("1.5".equals(sourceLevelOption)) {
            sourceLevel = 0x310000L;
        }
        Object complianceLevelOption = options.get("com.netflix.nebula.lint.jdt.core.compiler.compliance");
        long complianceLevel = 0x2F0000L;
        if ("1.4".equals(complianceLevelOption)) {
            complianceLevel = 0x300000L;
        } else if ("1.5".equals(complianceLevelOption)) {
            complianceLevel = 0x310000L;
        }
        this.scanner = new Scanner(true, true, false, sourceLevel, complianceLevel, null, null, true);
    }

    public static AST newAST(int level) {
        if (level != 2 && level != 3) {
            throw new IllegalArgumentException();
        }
        return new AST(level);
    }

    public long modificationCount() {
        return this.modificationCount;
    }

    public int apiLevel() {
        return this.apiLevel;
    }

    void modifying() {
        if (this.disableEvents > 0) {
            return;
        }
        ++this.modificationCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void disableEvents() {
        Object object = this.internalASTLock;
        synchronized (object) {
            ++this.disableEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void reenableEvents() {
        Object object = this.internalASTLock;
        synchronized (object) {
            --this.disableEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preRemoveChildEvent(ASTNode node, ASTNode child, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.preRemoveChildEvent(node, child, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postRemoveChildEvent(ASTNode node, ASTNode child, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.postRemoveChildEvent(node, child, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preReplaceChildEvent(ASTNode node, ASTNode child, ASTNode newChild, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.preReplaceChildEvent(node, child, newChild, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postReplaceChildEvent(ASTNode node, ASTNode child, ASTNode newChild, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.postReplaceChildEvent(node, child, newChild, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preAddChildEvent(ASTNode node, ASTNode child, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.preAddChildEvent(node, child, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postAddChildEvent(ASTNode node, ASTNode child, StructuralPropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.postAddChildEvent(node, child, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preValueChangeEvent(ASTNode node, SimplePropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.preValueChangeEvent(node, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postValueChangeEvent(ASTNode node, SimplePropertyDescriptor property) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.postValueChangeEvent(node, property);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preCloneNodeEvent(ASTNode node) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.preCloneNodeEvent(node);
        }
        finally {
            this.reenableEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postCloneNodeEvent(ASTNode node, ASTNode clone) {
        Object object = this.internalASTLock;
        synchronized (object) {
            if (this.disableEvents > 0) {
                return;
            }
            this.disableEvents();
        }
        try {
            this.eventHandler.postCloneNodeEvent(node, clone);
        }
        finally {
            this.reenableEvents();
        }
    }

    public static CompilationUnit parseCompilationUnit(ICompilationUnit unit, boolean resolveBindings) {
        try {
            ASTParser c = ASTParser.newParser(2);
            c.setSource(unit);
            c.setResolveBindings(resolveBindings);
            ASTNode result = c.createAST(null);
            return (CompilationUnit)result;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException();
        }
    }

    public static CompilationUnit parseCompilationUnit(IClassFile classFile, boolean resolveBindings) {
        if (classFile == null) {
            throw new IllegalArgumentException();
        }
        try {
            ASTParser c = ASTParser.newParser(2);
            c.setSource(classFile);
            c.setResolveBindings(resolveBindings);
            ASTNode result = c.createAST(null);
            return (CompilationUnit)result;
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException();
        }
    }

    public static CompilationUnit parseCompilationUnit(char[] source, String unitName, IJavaProject project) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        ASTParser astParser = ASTParser.newParser(2);
        astParser.setSource(source);
        astParser.setUnitName(unitName);
        astParser.setProject(project);
        astParser.setResolveBindings(project != null);
        ASTNode result = astParser.createAST(null);
        return (CompilationUnit)result;
    }

    public static CompilationUnit parseCompilationUnit(char[] source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        ASTParser c = ASTParser.newParser(2);
        c.setSource(source);
        ASTNode result = c.createAST(null);
        return (CompilationUnit)result;
    }

    BindingResolver getBindingResolver() {
        return this.resolver;
    }

    NodeEventHandler getEventHandler() {
        return this.eventHandler;
    }

    void setEventHandler(NodeEventHandler eventHandler) {
        if (this.eventHandler == null) {
            throw new IllegalArgumentException();
        }
        this.eventHandler = eventHandler;
    }

    int getDefaultNodeFlag() {
        return this.defaultNodeFlag;
    }

    void setDefaultNodeFlag(int flag) {
        this.defaultNodeFlag = flag;
    }

    void setOriginalModificationCount(long count) {
        this.originalModificationCount = count;
    }

    public ITypeBinding resolveWellKnownType(String name) {
        if (name == null) {
            return null;
        }
        return this.getBindingResolver().resolveWellKnownType(name);
    }

    void setBindingResolver(BindingResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        this.resolver = resolver;
    }

    void unsupportedIn2() {
        if (this.apiLevel == 2) {
            throw new UnsupportedOperationException("Operation not supported in JLS2 AST");
        }
    }

    void supportedOnlyIn2() {
        if (this.apiLevel != 2) {
            throw new UnsupportedOperationException("Operation not supported in JLS2 AST");
        }
    }

    public ASTNode createInstance(Class nodeClass) {
        if (nodeClass == null) {
            throw new IllegalArgumentException();
        }
        try {
            Constructor c = nodeClass.getDeclaredConstructor(AST_CLASS);
            Object result = c.newInstance(this.THIS_AST);
            return (ASTNode)result;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException();
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException();
        }
    }

    public ASTNode createInstance(int nodeType) {
        Class nodeClass = ASTNode.nodeClassForType(nodeType);
        return this.createInstance(nodeClass);
    }

    public SimpleName newSimpleName(String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException();
        }
        SimpleName result = new SimpleName(this);
        result.setIdentifier(identifier);
        return result;
    }

    public QualifiedName newQualifiedName(Name qualifier, SimpleName name) {
        QualifiedName result = new QualifiedName(this);
        result.setQualifier(qualifier);
        result.setName(name);
        return result;
    }

    public Name newName(String[] identifiers) {
        int count = identifiers.length;
        if (count == 0) {
            throw new IllegalArgumentException();
        }
        Name result = this.newSimpleName(identifiers[0]);
        int i = 1;
        while (i < count) {
            SimpleName name = this.newSimpleName(identifiers[i]);
            result = this.newQualifiedName(result, name);
            ++i;
        }
        return result;
    }

    Name internalNewName(String[] identifiers) {
        int count = identifiers.length;
        if (count == 0) {
            throw new IllegalArgumentException();
        }
        SimpleName simpleName = new SimpleName(this);
        simpleName.internalSetIdentifier(identifiers[0]);
        Name result = simpleName;
        int i = 1;
        while (i < count) {
            SimpleName name = new SimpleName(this);
            name.internalSetIdentifier(identifiers[i]);
            result = this.newQualifiedName(result, name);
            ++i;
        }
        return result;
    }

    public Name newName(String qualifiedName) {
        StringTokenizer t = new StringTokenizer(qualifiedName, ".", true);
        Name result = null;
        int balance = 0;
        while (t.hasMoreTokens()) {
            String s = t.nextToken();
            if (s.indexOf(46) >= 0) {
                if (s.length() > 1) {
                    throw new IllegalArgumentException();
                }
                if (--balance >= 0) continue;
                throw new IllegalArgumentException();
            }
            ++balance;
            SimpleName name = this.newSimpleName(s);
            result = result == null ? name : this.newQualifiedName(result, name);
        }
        if (balance != 1) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    public SimpleType newSimpleType(Name typeName) {
        SimpleType result = new SimpleType(this);
        result.setName(typeName);
        return result;
    }

    public ArrayType newArrayType(Type componentType) {
        ArrayType result = new ArrayType(this);
        result.setComponentType(componentType);
        return result;
    }

    public ArrayType newArrayType(Type elementType, int dimensions) {
        if (elementType == null || elementType.isArrayType()) {
            throw new IllegalArgumentException();
        }
        if (dimensions < 1 || dimensions > 1000) {
            throw new IllegalArgumentException();
        }
        ArrayType result = new ArrayType(this);
        result.setComponentType(elementType);
        int i = 2;
        while (i <= dimensions) {
            result = this.newArrayType(result);
            ++i;
        }
        return result;
    }

    public PrimitiveType newPrimitiveType(PrimitiveType.Code typeCode) {
        PrimitiveType result = new PrimitiveType(this);
        result.setPrimitiveTypeCode(typeCode);
        return result;
    }

    public ParameterizedType newParameterizedType(Type type) {
        ParameterizedType result = new ParameterizedType(this);
        result.setType(type);
        return result;
    }

    public QualifiedType newQualifiedType(Type qualifier, SimpleName name) {
        QualifiedType result = new QualifiedType(this);
        result.setQualifier(qualifier);
        result.setName(name);
        return result;
    }

    public WildcardType newWildcardType() {
        WildcardType result = new WildcardType(this);
        return result;
    }

    public CompilationUnit newCompilationUnit() {
        return new CompilationUnit(this);
    }

    public PackageDeclaration newPackageDeclaration() {
        PackageDeclaration result = new PackageDeclaration(this);
        return result;
    }

    public ImportDeclaration newImportDeclaration() {
        ImportDeclaration result = new ImportDeclaration(this);
        return result;
    }

    public TypeDeclaration newTypeDeclaration() {
        TypeDeclaration result = new TypeDeclaration(this);
        result.setInterface(false);
        return result;
    }

    public MethodDeclaration newMethodDeclaration() {
        MethodDeclaration result = new MethodDeclaration(this);
        result.setConstructor(false);
        return result;
    }

    public SingleVariableDeclaration newSingleVariableDeclaration() {
        SingleVariableDeclaration result = new SingleVariableDeclaration(this);
        return result;
    }

    public VariableDeclarationFragment newVariableDeclarationFragment() {
        VariableDeclarationFragment result = new VariableDeclarationFragment(this);
        return result;
    }

    public Initializer newInitializer() {
        Initializer result = new Initializer(this);
        return result;
    }

    public EnumConstantDeclaration newEnumConstantDeclaration() {
        EnumConstantDeclaration result = new EnumConstantDeclaration(this);
        return result;
    }

    public EnumDeclaration newEnumDeclaration() {
        EnumDeclaration result = new EnumDeclaration(this);
        return result;
    }

    public TypeParameter newTypeParameter() {
        TypeParameter result = new TypeParameter(this);
        return result;
    }

    public AnnotationTypeDeclaration newAnnotationTypeDeclaration() {
        AnnotationTypeDeclaration result = new AnnotationTypeDeclaration(this);
        return result;
    }

    public AnnotationTypeMemberDeclaration newAnnotationTypeMemberDeclaration() {
        AnnotationTypeMemberDeclaration result = new AnnotationTypeMemberDeclaration(this);
        return result;
    }

    public Modifier newModifier(Modifier.ModifierKeyword keyword) {
        Modifier result = new Modifier(this);
        result.setKeyword(keyword);
        return result;
    }

    public List newModifiers(int flags) {
        if (this.apiLevel == 2) {
            this.unsupportedIn2();
        }
        ArrayList<Modifier> result = new ArrayList<Modifier>(3);
        if (Modifier.isPublic(flags)) {
            result.add(this.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        }
        if (Modifier.isProtected(flags)) {
            result.add(this.newModifier(Modifier.ModifierKeyword.PROTECTED_KEYWORD));
        }
        if (Modifier.isPrivate(flags)) {
            result.add(this.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
        }
        if (Modifier.isAbstract(flags)) {
            result.add(this.newModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD));
        }
        if (Modifier.isStatic(flags)) {
            result.add(this.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        }
        if (Modifier.isFinal(flags)) {
            result.add(this.newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
        }
        if (Modifier.isSynchronized(flags)) {
            result.add(this.newModifier(Modifier.ModifierKeyword.SYNCHRONIZED_KEYWORD));
        }
        if (Modifier.isNative(flags)) {
            result.add(this.newModifier(Modifier.ModifierKeyword.NATIVE_KEYWORD));
        }
        if (Modifier.isStrictfp(flags)) {
            result.add(this.newModifier(Modifier.ModifierKeyword.STRICTFP_KEYWORD));
        }
        if (Modifier.isTransient(flags)) {
            result.add(this.newModifier(Modifier.ModifierKeyword.TRANSIENT_KEYWORD));
        }
        if (Modifier.isVolatile(flags)) {
            result.add(this.newModifier(Modifier.ModifierKeyword.VOLATILE_KEYWORD));
        }
        return result;
    }

    public BlockComment newBlockComment() {
        BlockComment result = new BlockComment(this);
        return result;
    }

    public LineComment newLineComment() {
        LineComment result = new LineComment(this);
        return result;
    }

    public Javadoc newJavadoc() {
        Javadoc result = new Javadoc(this);
        return result;
    }

    public TagElement newTagElement() {
        TagElement result = new TagElement(this);
        return result;
    }

    public TextElement newTextElement() {
        TextElement result = new TextElement(this);
        return result;
    }

    public MemberRef newMemberRef() {
        MemberRef result = new MemberRef(this);
        return result;
    }

    public MethodRef newMethodRef() {
        MethodRef result = new MethodRef(this);
        return result;
    }

    public MethodRefParameter newMethodRefParameter() {
        MethodRefParameter result = new MethodRefParameter(this);
        return result;
    }

    public VariableDeclarationStatement newVariableDeclarationStatement(VariableDeclarationFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException();
        }
        VariableDeclarationStatement result = new VariableDeclarationStatement(this);
        result.fragments().add(fragment);
        return result;
    }

    public TypeDeclarationStatement newTypeDeclarationStatement(TypeDeclaration decl) {
        TypeDeclarationStatement result = new TypeDeclarationStatement(this);
        result.setDeclaration(decl);
        return result;
    }

    public TypeDeclarationStatement newTypeDeclarationStatement(AbstractTypeDeclaration decl) {
        TypeDeclarationStatement result = new TypeDeclarationStatement(this);
        if (this.apiLevel == 2) {
            result.internalSetTypeDeclaration((TypeDeclaration)decl);
        }
        if (this.apiLevel >= 3) {
            result.setDeclaration(decl);
        }
        return result;
    }

    public Block newBlock() {
        return new Block(this);
    }

    public ContinueStatement newContinueStatement() {
        return new ContinueStatement(this);
    }

    public BreakStatement newBreakStatement() {
        return new BreakStatement(this);
    }

    public ExpressionStatement newExpressionStatement(Expression expression) {
        ExpressionStatement result = new ExpressionStatement(this);
        result.setExpression(expression);
        return result;
    }

    public IfStatement newIfStatement() {
        return new IfStatement(this);
    }

    public WhileStatement newWhileStatement() {
        return new WhileStatement(this);
    }

    public DoStatement newDoStatement() {
        return new DoStatement(this);
    }

    public TryStatement newTryStatement() {
        return new TryStatement(this);
    }

    public CatchClause newCatchClause() {
        return new CatchClause(this);
    }

    public ReturnStatement newReturnStatement() {
        return new ReturnStatement(this);
    }

    public ThrowStatement newThrowStatement() {
        return new ThrowStatement(this);
    }

    public AssertStatement newAssertStatement() {
        return new AssertStatement(this);
    }

    public EmptyStatement newEmptyStatement() {
        return new EmptyStatement(this);
    }

    public LabeledStatement newLabeledStatement() {
        return new LabeledStatement(this);
    }

    public SwitchStatement newSwitchStatement() {
        return new SwitchStatement(this);
    }

    public SwitchCase newSwitchCase() {
        return new SwitchCase(this);
    }

    public SynchronizedStatement newSynchronizedStatement() {
        return new SynchronizedStatement(this);
    }

    public ForStatement newForStatement() {
        return new ForStatement(this);
    }

    public EnhancedForStatement newEnhancedForStatement() {
        return new EnhancedForStatement(this);
    }

    public StringLiteral newStringLiteral() {
        return new StringLiteral(this);
    }

    public CharacterLiteral newCharacterLiteral() {
        return new CharacterLiteral(this);
    }

    public NumberLiteral newNumberLiteral(String literal) {
        if (literal == null) {
            throw new IllegalArgumentException();
        }
        NumberLiteral result = new NumberLiteral(this);
        result.setToken(literal);
        return result;
    }

    public NumberLiteral newNumberLiteral() {
        NumberLiteral result = new NumberLiteral(this);
        return result;
    }

    public NullLiteral newNullLiteral() {
        return new NullLiteral(this);
    }

    public BooleanLiteral newBooleanLiteral(boolean value) {
        BooleanLiteral result = new BooleanLiteral(this);
        result.setBooleanValue(value);
        return result;
    }

    public Assignment newAssignment() {
        Assignment result = new Assignment(this);
        return result;
    }

    public MethodInvocation newMethodInvocation() {
        MethodInvocation result = new MethodInvocation(this);
        return result;
    }

    public SuperMethodInvocation newSuperMethodInvocation() {
        SuperMethodInvocation result = new SuperMethodInvocation(this);
        return result;
    }

    public ConstructorInvocation newConstructorInvocation() {
        ConstructorInvocation result = new ConstructorInvocation(this);
        return result;
    }

    public SuperConstructorInvocation newSuperConstructorInvocation() {
        SuperConstructorInvocation result = new SuperConstructorInvocation(this);
        return result;
    }

    public VariableDeclarationExpression newVariableDeclarationExpression(VariableDeclarationFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException();
        }
        VariableDeclarationExpression result = new VariableDeclarationExpression(this);
        result.fragments().add(fragment);
        return result;
    }

    public FieldDeclaration newFieldDeclaration(VariableDeclarationFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException();
        }
        FieldDeclaration result = new FieldDeclaration(this);
        result.fragments().add(fragment);
        return result;
    }

    public ThisExpression newThisExpression() {
        ThisExpression result = new ThisExpression(this);
        return result;
    }

    public FieldAccess newFieldAccess() {
        FieldAccess result = new FieldAccess(this);
        return result;
    }

    public SuperFieldAccess newSuperFieldAccess() {
        SuperFieldAccess result = new SuperFieldAccess(this);
        return result;
    }

    public TypeLiteral newTypeLiteral() {
        TypeLiteral result = new TypeLiteral(this);
        return result;
    }

    public CastExpression newCastExpression() {
        CastExpression result = new CastExpression(this);
        return result;
    }

    public ParenthesizedExpression newParenthesizedExpression() {
        ParenthesizedExpression result = new ParenthesizedExpression(this);
        return result;
    }

    public InfixExpression newInfixExpression() {
        InfixExpression result = new InfixExpression(this);
        return result;
    }

    public InstanceofExpression newInstanceofExpression() {
        InstanceofExpression result = new InstanceofExpression(this);
        return result;
    }

    public PostfixExpression newPostfixExpression() {
        PostfixExpression result = new PostfixExpression(this);
        return result;
    }

    public PrefixExpression newPrefixExpression() {
        PrefixExpression result = new PrefixExpression(this);
        return result;
    }

    public ArrayAccess newArrayAccess() {
        ArrayAccess result = new ArrayAccess(this);
        return result;
    }

    public ArrayCreation newArrayCreation() {
        ArrayCreation result = new ArrayCreation(this);
        return result;
    }

    public ClassInstanceCreation newClassInstanceCreation() {
        ClassInstanceCreation result = new ClassInstanceCreation(this);
        return result;
    }

    public AnonymousClassDeclaration newAnonymousClassDeclaration() {
        AnonymousClassDeclaration result = new AnonymousClassDeclaration(this);
        return result;
    }

    public ArrayInitializer newArrayInitializer() {
        ArrayInitializer result = new ArrayInitializer(this);
        return result;
    }

    public ConditionalExpression newConditionalExpression() {
        ConditionalExpression result = new ConditionalExpression(this);
        return result;
    }

    public NormalAnnotation newNormalAnnotation() {
        NormalAnnotation result = new NormalAnnotation(this);
        return result;
    }

    public MarkerAnnotation newMarkerAnnotation() {
        MarkerAnnotation result = new MarkerAnnotation(this);
        return result;
    }

    public SingleMemberAnnotation newSingleMemberAnnotation() {
        SingleMemberAnnotation result = new SingleMemberAnnotation(this);
        return result;
    }

    public MemberValuePair newMemberValuePair() {
        MemberValuePair result = new MemberValuePair(this);
        return result;
    }

    void recordModifications(CompilationUnit root) {
        if (this.modificationCount != this.originalModificationCount) {
            throw new IllegalArgumentException("AST is already modified");
        }
        if (this.rewriter != null) {
            throw new IllegalArgumentException("AST modifications are already recorded");
        }
        if ((root.getFlags() & 4) != 0) {
            throw new IllegalArgumentException("Root node is unmodifiable");
        }
        if (root.getAST() != this) {
            throw new IllegalArgumentException("Root node is not owned by this ast");
        }
        this.rewriter = new InternalASTRewrite(root);
        this.setEventHandler(this.rewriter);
    }

    TextEdit rewrite(IDocument document, Map options) {
        if (document == null) {
            throw new IllegalArgumentException();
        }
        if (this.rewriter == null) {
            throw new IllegalStateException("Modifications record is not enabled");
        }
        return this.rewriter.rewriteAST(document, options);
    }

    public boolean hasResolvedBindings() {
        return (this.bits & Integer.MIN_VALUE) != 0;
    }

    public boolean hasStatementsRecovery() {
        return (this.bits & 2) != 0;
    }

    public boolean hasBindingsRecovery() {
        return (this.bits & 4) != 0;
    }

    void setFlag(int newValue) {
        this.bits |= newValue;
    }
}

