/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint.jdt.core.compiler;

import com.netflix.nebula.lint.jdt.core.ICompilationUnit;
import com.netflix.nebula.lint.jdt.core.IJavaElementDelta;
import com.netflix.nebula.lint.jdt.core.JavaModelException;
import com.netflix.nebula.lint.jdt.core.compiler.CategorizedProblem;
import com.netflix.nebula.lint.jdt.core.dom.ASTParser;
import com.netflix.nebula.lint.jdt.internal.core.CompilationUnit;
import com.netflix.nebula.lint.jdt.internal.core.JavaProject;
import com.netflix.nebula.lint.jdt.internal.core.ReconcileWorkingCopyOperation;
import java.util.HashMap;

public class ReconcileContext {
    private ReconcileWorkingCopyOperation operation;
    private CompilationUnit workingCopy;

    public ReconcileContext(ReconcileWorkingCopyOperation operation, CompilationUnit workingCopy) {
        this.operation = operation;
        this.workingCopy = workingCopy;
    }

    public com.netflix.nebula.lint.jdt.core.dom.CompilationUnit getAST3() throws JavaModelException {
        if (this.operation.astLevel != 3 || !this.operation.resolveBindings) {
            ASTParser parser = ASTParser.newParser(3);
            parser.setCompilerOptions(this.workingCopy.getJavaProject().getOptions(true));
            if (JavaProject.hasJavaNature(this.workingCopy.getJavaProject().getProject())) {
                parser.setResolveBindings(true);
            }
            parser.setStatementsRecovery((this.operation.reconcileFlags & 2) != 0);
            parser.setBindingsRecovery((this.operation.reconcileFlags & 4) != 0);
            parser.setSource(this.workingCopy);
            return (com.netflix.nebula.lint.jdt.core.dom.CompilationUnit)parser.createAST(this.operation.progressMonitor);
        }
        return this.operation.makeConsistent(this.workingCopy);
    }

    public int getASTLevel() {
        return this.operation.astLevel;
    }

    public boolean isResolvingBindings() {
        return this.operation.resolveBindings;
    }

    public IJavaElementDelta getDelta() {
        return this.operation.deltaBuilder.delta;
    }

    public CategorizedProblem[] getProblems(String markerType) {
        if (this.operation.problems == null) {
            return null;
        }
        return (CategorizedProblem[])this.operation.problems.get(markerType);
    }

    public ICompilationUnit getWorkingCopy() {
        return this.workingCopy;
    }

    public void resetAST() {
        this.operation.ast = null;
        this.putProblems("com.netflix.nebula.lint.jdt.core.problem", null);
        this.putProblems("com.netflix.nebula.lint.jdt.core.task", null);
    }

    public void putProblems(String markerType, CategorizedProblem[] problems) {
        if (this.operation.problems == null) {
            this.operation.problems = new HashMap();
        }
        this.operation.problems.put(markerType, problems);
    }
}

